/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.modules;

import com.github.twitch4j.ITwitchClient;
import com.github.twitch4j.modules.Configuration;
import com.github.twitch4j.modules.IModule;
import com.github.twitch4j.modules.ModulePair;
import com.github.twitch4j.modules.event.ModuleDisabledEvent;
import com.github.twitch4j.modules.event.ModuleEnabledEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleLoader {
    private static final Logger log = LoggerFactory.getLogger(ModuleLoader.class);
    public static final String MODULE_DIR = "modules";
    private static final List<Class<? extends IModule>> classModules = new CopyOnWriteArrayList<Class<? extends IModule>>();
    private final Map<String, ModulePair> modules = new LinkedHashMap<String, ModulePair>();
    private final ITwitchClient client;

    public ModuleLoader(ITwitchClient client) {
        this.client = client;
        this.loadClassModules(false);
    }

    private void loadClassModules(boolean reloadAll) {
        if (reloadAll) {
            this.modules.clear();
        }
        classModules.forEach(clazz -> {
            try {
                IModule module = (IModule)clazz.newInstance();
                ModulePair modulePair = new ModulePair(module, false);
                log.info("Loading module {}", new Object[]{module.getName(), module.getVersion(), module.getAuthor()});
                if (Configuration.AUTOMATICALLY_ENABLE_MODULES) {
                    this.enableModule(module);
                } else {
                    this.addModule(module);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error("Unable to load module " + clazz.getName() + "!", (Throwable)e);
            }
        });
    }

    public void addModule(IModule module) {
        this.addModule(module, false);
    }

    private void addModule(IModule module, boolean active) {
        ModulePair pair = new ModulePair(module, active);
        String moduleName = module.getClass().getSimpleName();
        if (!this.modules.containsKey(moduleName) && active) {
            this.client.getEventManager().publish((Object)new ModuleEnabledEvent(module));
        }
        this.modules.put(moduleName, pair);
    }

    public void enableModule(IModule module) {
        if (!this.modules.containsKey(module.getClass().getSimpleName())) {
            this.addModule(module, true);
        } else {
            this.enableModule(module.getClass().getSimpleName());
        }
    }

    private void enableModule(String name) {
        ModulePair pair;
        if (this.modules.containsKey(name) && !(pair = this.modules.get(name)).isActive()) {
            this.client.getEventManager().publish((Object)new ModuleEnabledEvent(pair.getModule()));
            pair.getModule().enable(this.client);
            pair.setActive(true);
        }
    }

    public void disableModule(String name) {
        ModulePair pair;
        if (this.modules.containsKey(name) && (pair = this.modules.get(name)).isActive()) {
            this.client.getEventManager().publish((Object)new ModuleDisabledEvent(pair.getModule()));
            pair.getModule().disable();
            pair.setActive(false);
        }
    }

    public void removeModule(String name) {
        if (this.modules.containsKey(name)) {
            this.disableModule(name);
            this.modules.remove(name);
        }
    }

    public void removeModule(IModule module) {
        this.removeModule(module.getClass().getSimpleName());
    }

    public void reloadMdoules() {
        classModules.clear();
        ModuleLoader.loadModulesFromDirectory(new File(MODULE_DIR));
        this.loadClassModules(true);
    }

    private static void loadModulesFromDirectory(File modulesDir) {
        File[] files = modulesDir.listFiles((FilenameFilter)FileFilterUtils.suffixFileFilter((String)"jar"));
        if (files != null && files.length > 0) {
            log.info("Attempting to load {} external module(s)...", (Object)files.length);
            ModuleLoader.loadExternalModules(Arrays.asList(files));
        }
    }

    public static void loadExternalModules(List<File> files) {
        files.stream().filter(file -> file.isFile() && file.getName().endsWith(".jar")).forEach(ModuleLoader::loadExternalModules);
    }

    public static synchronized void loadExternalModules(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            try (JarFile jar = new JarFile(file);){
                Class classInstance2;
                Manifest mf = jar.getManifest();
                String moduleAttribute = mf.getMainAttributes().getValue("Twitch4J-ModuleClass");
                ArrayList<String> moduleClasses = new ArrayList<String>();
                if (moduleAttribute != null) {
                    moduleClasses.addAll(Arrays.asList(moduleAttribute.replaceAll("\\s", "").split(";")));
                }
                URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                URL url = file.toURI().toURL();
                for (URL it : loader.getURLs()) {
                    if (!it.equals(url)) continue;
                    return;
                }
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)loader, url);
                if (moduleClasses.size() == 0) {
                    for (String clazz : ModuleLoader.listClasses(jar)) {
                        try {
                            classInstance2 = ModuleLoader.loadClass(clazz);
                            if (!IModule.class.isAssignableFrom(classInstance2) || classInstance2.equals(IModule.class)) continue;
                            ModuleLoader.addModuleClass(classInstance2);
                        }
                        catch (NoClassDefFoundError classInstance2) {}
                    }
                } else {
                    for (String moduleClass : moduleClasses) {
                        log.info("Loading Class from Manifest Attribute: {}", (Object)moduleClass);
                        classInstance2 = ModuleLoader.loadClass(moduleClass);
                        if (!IModule.class.isAssignableFrom(classInstance2)) continue;
                        ModuleLoader.addModuleClass(classInstance2);
                    }
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Unable to load module " + file.getName() + "!", (Throwable)e);
            }
        }
    }

    private static void addModuleClass(Class<? extends IModule> clazz) {
        if (!(Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || classModules.contains(clazz))) {
            classModules.add(clazz);
        }
    }

    private static Class loadClass(String clazz) throws ClassNotFoundException {
        if (clazz.contains("$") && clazz.substring(0, clazz.lastIndexOf("$")).length() > 0) {
            try {
                ModuleLoader.loadClass(clazz.substring(0, clazz.lastIndexOf("$")));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(clazz);
    }

    private static List<String> listClasses(JarFile jar) {
        return jar.stream().filter(entry -> !entry.isDirectory() && entry.getName().endsWith(".class")).map(path -> path.getName().replace("/", ".").substring(0, path.getName().length() - ".class".length())).collect(Collectors.toList());
    }

    public static List<Class<? extends IModule>> getClassModules() {
        return classModules;
    }

    public Map<String, ModulePair> getModules() {
        return this.modules;
    }

    static {
        if (Configuration.LOAD_MODULES) {
            File modulesDir = new File(MODULE_DIR);
            if (modulesDir.exists()) {
                if (!modulesDir.isDirectory()) {
                    throw new RuntimeException("modules isn't a directory!");
                }
            } else if (!modulesDir.mkdir()) {
                throw new RuntimeException("Error creating modules directory");
            }
            ModuleLoader.loadModulesFromDirectory(modulesDir);
        }
    }
}

