/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.TwitchClient;
import com.github.twitch4j.auth.TwitchAuth;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.TwitchChatBuilder;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.extensions.TwitchExtensionsBuilder;
import com.github.twitch4j.graphql.TwitchGraphQL;
import com.github.twitch4j.graphql.TwitchGraphQLBuilder;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.kraken.TwitchKrakenBuilder;
import com.github.twitch4j.pubsub.TwitchPubSub;
import com.github.twitch4j.pubsub.TwitchPubSubBuilder;
import com.github.twitch4j.tmi.TwitchMessagingInterface;
import com.github.twitch4j.tmi.TwitchMessagingInterfaceBuilder;
import feign.Logger;
import io.github.bucket4j.Bandwidth;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchClientBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String redirectUrl = "http://localhost";
    private Integer timeout = 5000;
    private Boolean enableExtensions = false;
    private Boolean enableHelix = false;
    private Boolean enableKraken = false;
    private Boolean enableTMI = false;
    private Boolean enableChat = false;
    protected Collection<String> botOwnerIds = new HashSet<String>();
    protected final Set<String> commandPrefixes = new HashSet<String>();
    private Boolean enablePubSub = false;
    private Boolean enableGraphQL = false;
    private OAuth2Credential chatAccount;
    private EventManager eventManager = null;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    protected Integer chatQueueSize = 200;
    protected Bandwidth chatRateLimit = Bandwidth.simple((long)20L, (Duration)Duration.ofSeconds(30L));
    private long chatQueueTimeout = 1000L;
    private String chatServer = "wss://irc-ws.chat.twitch.tv:443";
    private CredentialManager credentialManager = CredentialManagerBuilder.builder().build();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private long helperThreadDelay = 10000L;
    private OAuth2Credential defaultAuthToken = null;
    private ProxyConfig proxyConfig = null;
    private Logger.Level feignLogLevel = Logger.Level.NONE;

    public TwitchClientBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchClientBuilder withCommandTrigger(String commandTrigger) {
        this.commandPrefixes.add(commandTrigger);
        return this;
    }

    @Deprecated
    public TwitchClientBuilder withHelperThreadRate(long helperThreadDelay) {
        return this.withHelperThreadDelay(helperThreadDelay);
    }

    public static TwitchClientBuilder builder() {
        return new TwitchClientBuilder();
    }

    public TwitchClient build() {
        log.debug("TwitchClient: Initializing ErrorTracking ...");
        TwitchAuth.registerIdentityProvider((CredentialManager)this.credentialManager, (String)this.getClientId(), (String)this.getClientSecret(), (String)this.redirectUrl);
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        int poolSize = 2;
        if (this.enableChat.booleanValue()) {
            poolSize += 2;
        }
        if (this.enablePubSub.booleanValue()) {
            ++poolSize;
        }
        if (this.scheduledThreadPoolExecutor != null && this.scheduledThreadPoolExecutor.getCorePoolSize() < poolSize) {
            log.warn("Twitch4J requires a scheduledThreadPoolExecutor with at least {} threads to be fully functional! Some features may not work as expected.", (Object)poolSize);
        }
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)poolSize);
        }
        TwitchExtensions extensions = null;
        if (this.enableExtensions.booleanValue()) {
            extensions = TwitchExtensionsBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize.intValue()).withTimeout((long)this.timeout.intValue()).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchHelix helix = null;
        if (this.enableHelix.booleanValue()) {
            helix = TwitchHelixBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withDefaultAuthToken(this.defaultAuthToken).withRequestQueueSize(this.requestQueueSize).withScheduledThreadPoolExecutor(this.scheduledThreadPoolExecutor).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchKraken kraken = null;
        if (this.enableKraken.booleanValue()) {
            kraken = TwitchKrakenBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchMessagingInterface tmi = null;
        if (this.enableTMI.booleanValue()) {
            tmi = TwitchMessagingInterfaceBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchChat chat = null;
        if (this.enableChat.booleanValue()) {
            chat = TwitchChatBuilder.builder().withEventManager(this.eventManager).withCredentialManager(this.credentialManager).withChatAccount(this.chatAccount).withChatQueueSize(this.chatQueueSize).withChatRateLimit(this.chatRateLimit).withScheduledThreadPoolExecutor(this.scheduledThreadPoolExecutor).withBaseUrl(this.chatServer).withChatQueueTimeout(this.chatQueueTimeout).withCommandTriggers(this.commandPrefixes).withProxyConfig(this.proxyConfig).setBotOwnerIds(this.botOwnerIds).build();
        }
        TwitchPubSub pubSub = null;
        if (this.enablePubSub.booleanValue()) {
            pubSub = TwitchPubSubBuilder.builder().withEventManager(this.eventManager).withScheduledThreadPoolExecutor(this.scheduledThreadPoolExecutor).withProxyConfig(this.proxyConfig).setBotOwnerIds(this.botOwnerIds).build();
        }
        TwitchGraphQL graphql = null;
        if (this.enableGraphQL.booleanValue()) {
            graphql = TwitchGraphQLBuilder.builder().withEventManager(this.eventManager).withClientId(this.clientId).withClientSecret(this.clientSecret).withProxyConfig(this.proxyConfig).build();
        }
        TwitchClient client = new TwitchClient(this.eventManager, extensions, helix, kraken, tmi, chat, pubSub, graphql, this.scheduledThreadPoolExecutor);
        client.getClientHelper().setThreadDelay(this.helperThreadDelay);
        return client;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Boolean getEnableExtensions() {
        return this.enableExtensions;
    }

    public Boolean getEnableHelix() {
        return this.enableHelix;
    }

    public Boolean getEnableKraken() {
        return this.enableKraken;
    }

    public Boolean getEnableTMI() {
        return this.enableTMI;
    }

    public Boolean getEnableChat() {
        return this.enableChat;
    }

    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    public Set<String> getCommandPrefixes() {
        return this.commandPrefixes;
    }

    public Boolean getEnablePubSub() {
        return this.enablePubSub;
    }

    public Boolean getEnableGraphQL() {
        return this.enableGraphQL;
    }

    public OAuth2Credential getChatAccount() {
        return this.chatAccount;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public Integer getChatQueueSize() {
        return this.chatQueueSize;
    }

    public Bandwidth getChatRateLimit() {
        return this.chatRateLimit;
    }

    public long getChatQueueTimeout() {
        return this.chatQueueTimeout;
    }

    public String getChatServer() {
        return this.chatServer;
    }

    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public long getHelperThreadDelay() {
        return this.helperThreadDelay;
    }

    public OAuth2Credential getDefaultAuthToken() {
        return this.defaultAuthToken;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public Logger.Level getFeignLogLevel() {
        return this.feignLogLevel;
    }

    private TwitchClientBuilder() {
    }

    private TwitchClientBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String redirectUrl, Integer timeout, Boolean enableExtensions, Boolean enableHelix, Boolean enableKraken, Boolean enableTMI, Boolean enableChat, Collection<String> botOwnerIds, Boolean enablePubSub, Boolean enableGraphQL, OAuth2Credential chatAccount, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, Integer chatQueueSize, Bandwidth chatRateLimit, long chatQueueTimeout, String chatServer, CredentialManager credentialManager, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long helperThreadDelay, OAuth2Credential defaultAuthToken, ProxyConfig proxyConfig, Logger.Level feignLogLevel) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.redirectUrl = redirectUrl;
        this.timeout = timeout;
        this.enableExtensions = enableExtensions;
        this.enableHelix = enableHelix;
        this.enableKraken = enableKraken;
        this.enableTMI = enableTMI;
        this.enableChat = enableChat;
        this.botOwnerIds = botOwnerIds;
        this.enablePubSub = enablePubSub;
        this.enableGraphQL = enableGraphQL;
        this.chatAccount = chatAccount;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.chatQueueSize = chatQueueSize;
        this.chatRateLimit = chatRateLimit;
        this.chatQueueTimeout = chatQueueTimeout;
        this.chatServer = chatServer;
        this.credentialManager = credentialManager;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.helperThreadDelay = helperThreadDelay;
        this.defaultAuthToken = defaultAuthToken;
        this.proxyConfig = proxyConfig;
        this.feignLogLevel = feignLogLevel;
    }

    public TwitchClientBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchClientBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchClientBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withRedirectUrl(String redirectUrl) {
        return this.redirectUrl == redirectUrl ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableExtensions(Boolean enableExtensions) {
        return this.enableExtensions == enableExtensions ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableHelix(Boolean enableHelix) {
        return this.enableHelix == enableHelix ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableKraken(Boolean enableKraken) {
        return this.enableKraken == enableKraken ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableTMI(Boolean enableTMI) {
        return this.enableTMI == enableTMI ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableChat(Boolean enableChat) {
        return this.enableChat == enableChat ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    public TwitchClientBuilder withEnablePubSub(Boolean enablePubSub) {
        return this.enablePubSub == enablePubSub ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEnableGraphQL(Boolean enableGraphQL) {
        return this.enableGraphQL == enableGraphQL ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withChatAccount(OAuth2Credential chatAccount) {
        return this.chatAccount == chatAccount ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withChatQueueSize(Integer chatQueueSize) {
        return this.chatQueueSize == chatQueueSize ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withChatRateLimit(Bandwidth chatRateLimit) {
        return this.chatRateLimit == chatRateLimit ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withChatQueueTimeout(long chatQueueTimeout) {
        return this.chatQueueTimeout == chatQueueTimeout ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withChatServer(String chatServer) {
        return this.chatServer == chatServer ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withCredentialManager(CredentialManager credentialManager) {
        return this.credentialManager == credentialManager ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withHelperThreadDelay(long helperThreadDelay) {
        return this.helperThreadDelay == helperThreadDelay ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, helperThreadDelay, this.defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withDefaultAuthToken(OAuth2Credential defaultAuthToken) {
        return this.defaultAuthToken == defaultAuthToken ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, defaultAuthToken, this.proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, proxyConfig, this.feignLogLevel);
    }

    public TwitchClientBuilder withFeignLogLevel(Logger.Level feignLogLevel) {
        return this.feignLogLevel == feignLogLevel ? this : new TwitchClientBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.botOwnerIds, this.enablePubSub, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatQueueTimeout, this.chatServer, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.proxyConfig, feignLogLevel);
    }
}

