/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.internal;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.chat.events.channel.ListModsEvent;
import com.github.twitch4j.chat.events.channel.ListVipsEvent;
import com.github.twitch4j.common.enums.AnnouncementColor;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.domain.BanUserInput;
import com.github.twitch4j.helix.domain.ChannelVipList;
import com.github.twitch4j.helix.domain.ChatSettings;
import com.github.twitch4j.helix.domain.Highlight;
import com.github.twitch4j.helix.domain.ModeratorList;
import com.github.twitch4j.helix.domain.NamedUserChatColor;
import com.github.twitch4j.helix.domain.User;
import com.github.twitch4j.helix.domain.UserList;
import com.github.twitch4j.internal.ChatCommandHandler;
import com.github.twitch4j.internal.ChatCommandHelixForwarder;
import com.github.twitch4j.internal.ChatCommandRateLimitType;
import com.github.twitch4j.util.EnumUtil;
import com.github.twitch4j.util.PaginationUtil;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ChatCommandRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private static final Map<String, String> HELIX_COLORS_BY_LOWER_CHAT_NAME;
    private static final Cache<String, String> USER_ID_BY_LOGIN_CACHE;
    private final Map<String, ChatCommandHandler> commandHandlers;

    private ChatCommandRegistry() {
        HashMap<String, ChatCommandHandler> m = new HashMap<String, ChatCommandHandler>();
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, AnnouncementColor> announceHandler = (args, color) -> {
            if (args.getRestOfMessage() == null || args.getRestOfMessage().isEmpty()) {
                return;
            }
            args.getHelix().sendChatAnnouncement(args.getToken().getAccessToken(), args.getChannelId(), args.getToken().getUserId(), args.getRestOfMessage(), color).execute();
        };
        m.put("announce", args -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, AnnouncementColor.PRIMARY));
        m.put("announceblue", args -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, AnnouncementColor.BLUE));
        m.put("announcegreen", args -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, AnnouncementColor.GREEN));
        m.put("announceorange", args -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, AnnouncementColor.ORANGE));
        m.put("announcepurple", args -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, AnnouncementColor.PURPLE));
        m.put("ban", args -> {
            String[] banParts = StringUtils.split((String)args.getRestOfMessage(), (String)" ", (int)2);
            if (banParts.length == 0) {
                return;
            }
            String banReason = banParts.length > 1 ? banParts[1] : "";
            ChatCommandRegistry.doBan(args.getHelix(), args.getToken(), args.getChannelId(), ChatCommandRegistry.getId(args.getHelix(), args.getToken(), banParts[0], null), banReason, null);
        });
        m.put("color", new ChatCommandHandler(){

            @Override
            public void accept(ChatCommandHelixForwarder.CommandArguments args) {
                String color;
                String string = color = args.getRestOfMessage().startsWith("#") ? args.getRestOfMessage() : (String)HELIX_COLORS_BY_LOWER_CHAT_NAME.get(args.getRestOfMessage().toLowerCase());
                if (color == null) {
                    return;
                }
                args.getHelix().updateUserChatColor(args.getToken().getAccessToken(), args.getToken().getUserId(), color).execute();
            }

            @Override
            public ChatCommandRateLimitType getLimitKey() {
                return ChatCommandRateLimitType.USER;
            }
        });
        m.put("commercial", args -> {
            if (args.getRestOfMessage() == null || args.getRestOfMessage().isEmpty()) {
                return;
            }
            int length = Integer.parseInt(args.getRestOfMessage());
            length = length / 30 * 30;
            length = Math.max(Math.min(length, 180), 30);
            args.getHelix().startCommercial(args.getToken().getAccessToken(), args.getChannelId(), Integer.valueOf(length)).execute();
        });
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, String> deleteHandler = (args, messageId) -> {
            if (messageId != null && messageId.isEmpty()) {
                return;
            }
            args.getHelix().deleteChatMessages(args.getToken().getAccessToken(), args.getChannelId(), args.getToken().getUserId(), messageId).execute();
        };
        m.put("clear", args -> deleteHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, (String)null));
        m.put("delete", args -> deleteHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, args.getRestOfMessage()));
        ChatCommandHandler unbanHandler = args -> {
            String userId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), args.getRestOfMessage(), null);
            args.getHelix().unbanUser(args.getToken().getAccessToken(), args.getChannelId(), args.getToken().getUserId(), userId).execute();
        };
        m.put("unban", unbanHandler);
        m.put("untimeout", unbanHandler);
        m.put("marker", args -> {
            String description = args.getRestOfMessage() != null ? args.getRestOfMessage() : "";
            args.getHelix().createStreamMarker(args.getToken().getAccessToken(), new Highlight(args.getChannelId(), description)).execute();
        });
        m.put("mod", args -> {
            String targetName = args.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args.getHelix().addChannelModerator(args.getToken().getAccessToken(), args.getChannelId(), targetId).execute();
        });
        m.put("unmod", args -> {
            String targetName = args.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args.getHelix().removeChannelModerator(args.getToken().getAccessToken(), args.getChannelId(), targetId).execute();
        });
        m.put("mods", args -> {
            String channelId = args.getChannelId();
            if (args.getChannelName() == null || channelId == null) {
                return;
            }
            AtomicBoolean failure = new AtomicBoolean();
            List mods = PaginationUtil.getPaginated(cursor -> {
                try {
                    return (ModeratorList)args.getHelix().getModerators(args.getToken().getAccessToken(), channelId, null, cursor, Integer.valueOf(100)).execute();
                }
                catch (Exception e) {
                    failure.set(true);
                    this.getLogger().warn("Failed to query moderators from Helix chat command forwarder", (Throwable)e);
                    return null;
                }
            }, ModeratorList::getModerators, result -> result.getPagination() != null ? result.getPagination().getCursor() : null);
            if (failure.get()) {
                return;
            }
            ArrayList names = new ArrayList(mods.size());
            mods.forEach(v -> names.add(v.getUserLogin()));
            EventChannel channel = new EventChannel(channelId, args.getChannelName());
            ListModsEvent event = new ListModsEvent(channel, names);
            args.getChat().getEventManager().publish((Object)event);
        });
        m.put("raid", args -> {
            String targetName = args.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args.getHelix().startRaid(args.getToken().getAccessToken(), args.getChannelId(), targetId).execute();
        });
        m.put("unraid", args -> args.getHelix().cancelRaid(args.getToken().getAccessToken(), args.getChannelId()).execute());
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, ChatSettings> roomHandler = (args, settings) -> {
            if (settings == null) {
                return;
            }
            args.getHelix().updateChatSettings(args.getToken().getAccessToken(), args.getChannelId(), args.getToken().getUserId(), settings).execute();
        };
        m.put("emoteonly", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isEmoteOnlyMode(Boolean.valueOf(true)).build()));
        m.put("emoteonlyoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isEmoteOnlyMode(Boolean.valueOf(false)).build()));
        m.put("followers", args -> {
            Integer followTime = ChatCommandRegistry.parseDuration(args.getRestOfMessage());
            followTime = followTime != null ? followTime : 0;
            followTime = Math.min(Math.max(followTime, 0), 129600);
            roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isFollowersOnlyMode(Boolean.valueOf(true)).followerModeDuration(followTime).build());
        });
        m.put("followersoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isFollowersOnlyMode(Boolean.valueOf(false)).build()));
        m.put("slow", args -> {
            Integer slowTime = ChatCommandRegistry.parseDuration(args.getRestOfMessage());
            slowTime = slowTime != null ? slowTime : 30;
            slowTime = Math.min(Math.max(slowTime, 3), 120);
            roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isSlowMode(Boolean.valueOf(true)).slowModeWaitTime(slowTime).build());
        });
        m.put("slowoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isSlowMode(Boolean.valueOf(false)).build()));
        m.put("subscribers", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isSubscribersOnlyMode(Boolean.valueOf(true)).build()));
        m.put("subscribersoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isSubscribersOnlyMode(Boolean.valueOf(false)).build()));
        m.put("r9kbeta", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isUniqueChatMode(Boolean.valueOf(true)).build()));
        m.put("uniquechat", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isUniqueChatMode(Boolean.valueOf(true)).build()));
        m.put("r9kbetaoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isUniqueChatMode(Boolean.valueOf(false)).build()));
        m.put("uniquechatoff", args -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args, ChatSettings.builder().isUniqueChatMode(Boolean.valueOf(false)).build()));
        m.put("timeout", args -> {
            String[] timeoutParts = StringUtils.split((String)args.getRestOfMessage(), (String)" ", (int)3);
            if (timeoutParts.length < 2) {
                return;
            }
            String timeoutReason = timeoutParts.length >= 3 ? timeoutParts[2] : "";
            Integer seconds = ChatCommandRegistry.parseDuration(timeoutParts[1]);
            if (seconds == null) {
                return;
            }
            seconds = Math.min(Math.max(seconds, 1), 1209600);
            ChatCommandRegistry.doBan(args.getHelix(), args.getToken(), args.getChannelId(), ChatCommandRegistry.getId(args.getHelix(), args.getToken(), timeoutParts[0], null), timeoutReason, seconds);
        });
        m.put("vip", args -> {
            String targetName = args.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args.getHelix().addChannelVip(args.getToken().getAccessToken(), args.getChannelId(), targetId).execute();
        });
        m.put("unvip", args -> {
            String targetName = args.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args.getHelix().removeChannelVip(args.getToken().getAccessToken(), args.getChannelId(), targetId).execute();
        });
        m.put("vips", args -> {
            String channelId = args.getChannelId();
            if (args.getChannelName() == null || channelId == null) {
                return;
            }
            AtomicBoolean failure = new AtomicBoolean();
            List vips = PaginationUtil.getPaginated(cursor -> {
                try {
                    return (ChannelVipList)args.getHelix().getChannelVips(args.getToken().getAccessToken(), channelId, null, Integer.valueOf(100), cursor).execute();
                }
                catch (Exception e) {
                    failure.set(true);
                    this.getLogger().warn("Failed to query VIPs from Helix chat command forwarder", (Throwable)e);
                    return null;
                }
            }, ChannelVipList::getData, result -> result.getPagination() != null ? result.getPagination().getCursor() : null);
            if (failure.get()) {
                return;
            }
            ArrayList names = new ArrayList(vips.size());
            vips.forEach(v -> names.add(v.getUserLogin()));
            EventChannel channel = new EventChannel(channelId, args.getChannelName());
            ListVipsEvent event = new ListVipsEvent(channel, names);
            args.getChat().getEventManager().publish((Object)event);
        });
        m.put("w", new ChatCommandHandler(){

            @Override
            public void accept(ChatCommandHelixForwarder.CommandArguments args) {
                String[] whisperParts = StringUtils.split((String)args.getRestOfMessage(), (String)" ", (int)2);
                if (whisperParts.length != 2) {
                    return;
                }
                String message = whisperParts[1];
                if (message == null || message.isEmpty()) {
                    return;
                }
                String targetName = whisperParts[0];
                String targetId = ChatCommandRegistry.getId(args.getHelix(), args.getToken(), targetName, (String)args.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
                args.getHelix().sendWhisper(args.getToken().getAccessToken(), args.getToken().getUserId(), targetId, message).execute();
            }

            @Override
            public ChatCommandRateLimitType getLimitKey() {
                return ChatCommandRateLimitType.USER;
            }
        });
        this.commandHandlers = Collections.unmodifiableMap(m);
    }

    private Logger getLogger() {
        return log;
    }

    static String getId(TwitchHelix helix, OAuth2Credential token, @NotNull String name, @Nullable String optimisticId) {
        if (optimisticId != null) {
            return optimisticId;
        }
        if (name.equalsIgnoreCase(token.getUserName())) {
            return token.getUserId();
        }
        String cachedId = (String)USER_ID_BY_LOGIN_CACHE.get((Object)name.toLowerCase());
        if (cachedId != null) {
            return cachedId;
        }
        User user = (User)((UserList)helix.getUsers(token.getAccessToken(), null, Collections.singletonList(name)).execute()).getUsers().get(0);
        USER_ID_BY_LOGIN_CACHE.put((Object)user.getLogin(), (Object)user.getId());
        return user.getId();
    }

    private static void doBan(TwitchHelix helix, OAuth2Credential token, String channelId, String targetId, String reason, Integer duration) {
        if (channelId == null || targetId == null || duration != null && duration == 0) {
            return;
        }
        helix.banUser(token.getAccessToken(), channelId, token.getUserId(), BanUserInput.builder().userId(targetId).reason(reason != null ? reason : "").duration(duration).build()).execute();
    }

    @Nullable
    static Integer parseDuration(@NotNull String time) {
        int seconds = 0;
        int part = 0;
        int n = time.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = time.charAt(i);
            if (Character.isDigit(c)) {
                part *= 10;
                part += c - 48;
                continue;
            }
            if (i == 0 && c != ' ') {
                return null;
            }
            switch (Character.toLowerCase(c)) {
                case 's': {
                    seconds += part;
                    break;
                }
                case 'm': {
                    if (i + 1 < n && Character.toLowerCase(time.charAt(i + 1)) == 'o') {
                        seconds += part * 60 * 60 * 24 * 7 * 4;
                        break;
                    }
                    seconds += part * 60;
                    break;
                }
                case 'h': {
                    seconds += part * 60 * 60;
                    break;
                }
                case 'd': {
                    seconds += part * 60 * 60 * 24;
                    break;
                }
                case 'w': {
                    seconds += part * 60 * 60 * 24 * 7;
                    break;
                }
                default: {
                    if (part <= 0) break;
                    if (c == ' ') continue block7;
                    return null;
                }
            }
            part = 0;
        }
        return seconds += part;
    }

    @Generated
    public Map<String, ChatCommandHandler> getCommandHandlers() {
        return this.commandHandlers;
    }

    static {
        log = LoggerFactory.getLogger(ChatCommandRegistry.class);
        HELIX_COLORS_BY_LOWER_CHAT_NAME = EnumUtil.buildMapping((Enum[])NamedUserChatColor.values(), c -> c.toString().replace("_", ""), Enum::toString);
        USER_ID_BY_LOGIN_CACHE = CacheApi.create(spec -> {
            spec.expiryType(ExpiryType.POST_ACCESS);
            spec.expiryTime(Duration.ofMinutes(5L));
            spec.maxSize(Long.valueOf(2048L));
        });
    }
}

