/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.internal;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.TwitchChat;
import com.github.twitch4j.chat.util.TwitchChatLimitHelper;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.internal.ChatCommandHandler;
import com.github.twitch4j.internal.ChatCommandRateLimitType;
import com.github.twitch4j.internal.ChatCommandRegistry;
import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ChatCommandHelixForwarder
implements BiPredicate<TwitchChat, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChatCommandHelixForwarder.class);
    public static final Instant ENABLE_AFTER = Instant.ofEpochSecond(1677000000L);
    static final Pattern COMMAND_PATTERN = Pattern.compile((String)"^(?:@(?<tags>\\S+?)\\s)?PRIVMSG\\s#(?<channel>\\S*?)\\s:\\s*[/\\.](?<command>.+)$");
    private static final Map<String, ChatCommandHandler> COMMAND_HANDLERS = ChatCommandRegistry.INSTANCE.getCommandHandlers();
    private final TwitchHelix helix;
    private final OAuth2Credential token;
    private final ScheduledExecutorService executor;
    private final Bandwidth channelHelixLimit;
    private final Cache<String, Bucket> bucketByChannel;

    public ChatCommandHelixForwarder(TwitchHelix helix, OAuth2Credential token, TwitchIdentityProvider identityProvider, ScheduledExecutorService executor, Bandwidth channelHelixLimit) {
        this.helix = helix;
        this.token = token;
        this.executor = executor;
        this.channelHelixLimit = channelHelixLimit != null ? channelHelixLimit : TwitchChatLimitHelper.MOD_MESSAGE_LIMIT;
        this.bucketByChannel = CacheApi.create(spec -> {
            spec.expiryType(ExpiryType.POST_ACCESS);
            spec.expiryTime(Duration.ofNanos(this.channelHelixLimit.getRefillPeriodNanos() * 2L));
            spec.maxSize(Long.valueOf(2048L));
        });
        if (token != null && StringUtils.isEmpty((CharSequence)token.getUserId())) {
            TwitchIdentityProvider tip = identityProvider != null ? identityProvider : new TwitchIdentityProvider(null, null, null);
            tip.getAdditionalCredentialInformation(token).ifPresent(arg_0 -> ((OAuth2Credential)token).updateCredential(arg_0));
            if (StringUtils.isEmpty((CharSequence)token.getUserId())) {
                log.warn("ChatCommandHelixForwarder requires a valid user access token to function correctly.");
            }
        }
        log.debug("Initialized ChatCommandHelixForwarder");
    }

    @Override
    public boolean test(TwitchChat chat, String rawIrcCommand) {
        if (this.helix == null || this.token == null) {
            return false;
        }
        Matcher matcher = COMMAND_PATTERN.matcher((CharSequence)rawIrcCommand);
        if (matcher.matches()) {
            String fullMessage;
            String channelName = matcher.group("channel");
            int firstSpace = (fullMessage = matcher.group("command").trim()).indexOf(32);
            String command = fullMessage.substring(0, firstSpace > 0 ? firstSpace : fullMessage.length());
            String restOfMessage = firstSpace > 0 ? fullMessage.substring(firstSpace + 1) : "";
            ChatCommandHandler handler = COMMAND_HANDLERS.get(command.toLowerCase());
            if (handler != null) {
                log.trace("Handling chat command from Helix forwarder: /" + fullMessage);
                BucketUtils.scheduleAgainstBucket((Bucket)this.getCommandBucket(handler.getLimitKey(), channelName), (ScheduledExecutorService)this.executor, () -> {
                    try {
                        handler.accept(new CommandArguments(chat, channelName, command, restOfMessage));
                    }
                    catch (Exception e) {
                        log.warn("Failed to execute command from Helix forwarder: /" + fullMessage, (Throwable)e);
                    }
                });
                return true;
            }
        }
        return false;
    }

    private Bucket getCommandBucket(ChatCommandRateLimitType limitType, String channelName) {
        String key = limitType == ChatCommandRateLimitType.CHANNEL ? channelName.toLowerCase() : "";
        return (Bucket)this.bucketByChannel.computeIfAbsent((Object)key, k -> BucketUtils.createBucket((Bandwidth)this.channelHelixLimit));
    }

    final class CommandArguments {
        private final TwitchChat chat;
        private final String channelName;
        private final String command;
        private final String restOfMessage;

        String getChannelId() {
            return ChatCommandRegistry.getId(ChatCommandHelixForwarder.this.helix, ChatCommandHelixForwarder.this.token, this.channelName, (String)this.chat.getChannelNameToChannelId().get(this.channelName.toLowerCase()));
        }

        TwitchHelix getHelix() {
            return ChatCommandHelixForwarder.this.helix;
        }

        OAuth2Credential getToken() {
            return ChatCommandHelixForwarder.this.token;
        }

        @Generated
        public CommandArguments(TwitchChat chat, String channelName, String command, String restOfMessage) {
            this.chat = chat;
            this.channelName = channelName;
            this.command = command;
            this.restOfMessage = restOfMessage;
        }

        @Generated
        public TwitchChat getChat() {
            return this.chat;
        }

        @Generated
        public String getChannelName() {
            return this.channelName;
        }

        @Generated
        public String getCommand() {
            return this.command;
        }

        @Generated
        public String getRestOfMessage() {
            return this.restOfMessage;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandArguments)) {
                return false;
            }
            CommandArguments other = (CommandArguments)o;
            TwitchChat this$chat = this.getChat();
            TwitchChat other$chat = other.getChat();
            if (this$chat == null ? other$chat != null : !this$chat.equals(other$chat)) {
                return false;
            }
            String this$channelName = this.getChannelName();
            String other$channelName = other.getChannelName();
            if (this$channelName == null ? other$channelName != null : !this$channelName.equals(other$channelName)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$restOfMessage = this.getRestOfMessage();
            String other$restOfMessage = other.getRestOfMessage();
            return !(this$restOfMessage == null ? other$restOfMessage != null : !this$restOfMessage.equals(other$restOfMessage));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TwitchChat $chat = this.getChat();
            result = result * 59 + ($chat == null ? 43 : $chat.hashCode());
            String $channelName = this.getChannelName();
            result = result * 59 + ($channelName == null ? 43 : $channelName.hashCode());
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $restOfMessage = this.getRestOfMessage();
            result = result * 59 + ($restOfMessage == null ? 43 : $restOfMessage.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChatCommandHelixForwarder.CommandArguments(chat=" + this.getChat() + ", channelName=" + this.getChannelName() + ", command=" + this.getCommand() + ", restOfMessage=" + this.getRestOfMessage() + ")";
        }
    }
}

