/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.twitch4j.IClientHelper;
import com.github.twitch4j.auth.domain.TwitchScopes;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.events.channel.FollowEvent;
import com.github.twitch4j.common.events.channel.ChannelChangeGameEvent;
import com.github.twitch4j.common.events.channel.ChannelChangeTitleEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.common.util.CollectionUtils;
import com.github.twitch4j.common.util.ExponentialBackoffStrategy;
import com.github.twitch4j.domain.ChannelCache;
import com.github.twitch4j.events.ChannelClipCreatedEvent;
import com.github.twitch4j.events.ChannelFollowCountUpdateEvent;
import com.github.twitch4j.events.ChannelGoLiveEvent;
import com.github.twitch4j.events.ChannelGoOfflineEvent;
import com.github.twitch4j.events.ChannelViewerCountUpdateEvent;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.domain.Clip;
import com.github.twitch4j.helix.domain.ClipList;
import com.github.twitch4j.helix.domain.InboundFollow;
import com.github.twitch4j.helix.domain.InboundFollowers;
import com.github.twitch4j.helix.domain.Stream;
import com.github.twitch4j.helix.domain.StreamList;
import com.github.twitch4j.util.PaginationUtil;
import com.netflix.hystrix.HystrixCommand;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClientHelper
implements IClientHelper {
    static final Logger log = LoggerFactory.getLogger(TwitchClientHelper.class);
    public static final int REQUIRED_THREAD_COUNT = 2;
    static final int MAX_LIMIT = 100;
    private final Set<String> listenForGoLive = ConcurrentHashMap.newKeySet();
    private final Set<String> listenForFollow = ConcurrentHashMap.newKeySet();
    private final Set<String> listenForClips = ConcurrentHashMap.newKeySet();
    private final TwitchHelix twitchHelix;
    private final Consumer<List<String>> streamStatusEventTask;
    private final AtomicReference<Future<?>> streamStatusEventFuture = new AtomicReference();
    private final Function<String, Boolean> followerEventTask;
    private final AtomicReference<Future<?>> followerEventFuture = new AtomicReference();
    private final Function<String, Boolean> clipEventTask;
    private final AtomicReference<Future<?>> clipEventFuture = new AtomicReference();
    private final Cache<String, ChannelCache> channelInformation = CacheApi.create(spec -> {
        spec.expiryType(ExpiryType.POST_ACCESS);
        spec.expiryTime(Duration.ofMinutes(10L));
        spec.maxSize(Long.valueOf(0x100000L));
    });
    private final ScheduledThreadPoolExecutor executor;
    private final AtomicReference<ExponentialBackoffStrategy> liveBackoff;
    private final AtomicReference<ExponentialBackoffStrategy> followBackoff;
    private final AtomicReference<ExponentialBackoffStrategy> clipBackoff;
    @Nullable
    private String followListenerWarning = null;

    @ApiStatus.Internal
    public TwitchClientHelper(TwitchHelix twitchHelix, EventManager eventManager, ScheduledThreadPoolExecutor executor, CredentialManager credentialManager, OAuth2Credential defaultToken) {
        this.twitchHelix = twitchHelix;
        this.executor = executor;
        ExponentialBackoffStrategy defaultBackoff = ExponentialBackoffStrategy.builder().immediateFirst(false).baseMillis(1000L).jitter(false).build();
        this.liveBackoff = new AtomicReference<ExponentialBackoffStrategy>(defaultBackoff);
        this.followBackoff = new AtomicReference<ExponentialBackoffStrategy>(defaultBackoff.copy());
        this.clipBackoff = new AtomicReference<ExponentialBackoffStrategy>(defaultBackoff.copy());
        this.streamStatusEventTask = channels -> {
            HystrixCommand hystrixGetAllStreams = twitchHelix.getStreams(null, null, null, Integer.valueOf(channels.size()), null, null, channels, null);
            try {
                HashMap<String, Stream> streams = new HashMap<String, Stream>();
                channels.forEach(id -> streams.put((String)id, (Stream)null));
                ((StreamList)hystrixGetAllStreams.execute()).getStreams().forEach(s -> streams.put(s.getUserId(), (Stream)s));
                this.liveBackoff.get().reset();
                streams.forEach((userId, stream) -> {
                    if (!this.listenForGoLive.contains(userId)) {
                        return;
                    }
                    ChannelCache currentChannelCache = (ChannelCache)this.channelInformation.computeIfAbsent(userId, s -> new ChannelCache());
                    if (stream != null) {
                        currentChannelCache.setUserName(stream.getUserLogin());
                    }
                    EventChannel channel = new EventChannel(userId, currentChannelCache.getUserName());
                    boolean dispatchGoLiveEvent = false;
                    boolean dispatchGoOfflineEvent = false;
                    boolean dispatchTitleChangedEvent = false;
                    boolean dispatchGameChangedEvent = false;
                    boolean dispatchViewersChangedEvent = false;
                    if (stream != null && stream.getType().equalsIgnoreCase("live")) {
                        boolean wasAlreadyLive;
                        if (currentChannelCache.getIsLive() != null && !currentChannelCache.getIsLive().booleanValue()) {
                            dispatchGoLiveEvent = true;
                        }
                        currentChannelCache.setIsLive(true);
                        boolean bl = wasAlreadyLive = !dispatchGoLiveEvent && currentChannelCache.getIsLive() != false;
                        if (wasAlreadyLive && currentChannelCache.getTitle() != null && !currentChannelCache.getTitle().equalsIgnoreCase(stream.getTitle())) {
                            dispatchTitleChangedEvent = true;
                        }
                        currentChannelCache.setTitle(stream.getTitle());
                        if (wasAlreadyLive && currentChannelCache.getGameId() != null && !currentChannelCache.getGameId().equals(stream.getGameId())) {
                            dispatchGameChangedEvent = true;
                        }
                        currentChannelCache.setGameId(stream.getGameId());
                        if (stream.getViewerCount() != null && !stream.getViewerCount().equals(currentChannelCache.getViewerCount().getAndSet(stream.getViewerCount())) && wasAlreadyLive) {
                            dispatchViewersChangedEvent = true;
                        }
                    } else {
                        if (currentChannelCache.getIsLive() != null && currentChannelCache.getIsLive().booleanValue()) {
                            dispatchGoOfflineEvent = true;
                        }
                        currentChannelCache.setIsLive(false);
                        currentChannelCache.setTitle(null);
                        currentChannelCache.setGameId(null);
                        currentChannelCache.getViewerCount().lazySet(null);
                    }
                    if (dispatchGoLiveEvent) {
                        com.github.twitch4j.common.events.channel.ChannelGoLiveEvent event = new com.github.twitch4j.common.events.channel.ChannelGoLiveEvent(channel, currentChannelCache.getTitle(), currentChannelCache.getGameId());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new ChannelGoLiveEvent(channel, (Stream)stream));
                    }
                    if (dispatchGoOfflineEvent) {
                        com.github.twitch4j.common.events.channel.ChannelGoOfflineEvent event = new com.github.twitch4j.common.events.channel.ChannelGoOfflineEvent(channel);
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new ChannelGoOfflineEvent(channel));
                    }
                    if (dispatchTitleChangedEvent) {
                        ChannelChangeTitleEvent event = new ChannelChangeTitleEvent(channel, currentChannelCache.getTitle());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new com.github.twitch4j.events.ChannelChangeTitleEvent(channel, (Stream)stream));
                    }
                    if (dispatchGameChangedEvent) {
                        ChannelChangeGameEvent event = new ChannelChangeGameEvent(channel, currentChannelCache.getGameId());
                        eventManager.publish((Object)event);
                        eventManager.publish((Object)new com.github.twitch4j.events.ChannelChangeGameEvent(channel, (Stream)stream));
                    }
                    if (dispatchViewersChangedEvent) {
                        eventManager.publish((Object)new ChannelViewerCountUpdateEvent(channel, (Stream)stream));
                    }
                });
            }
            catch (Exception ex) {
                if (hystrixGetAllStreams != null && hystrixGetAllStreams.isFailedExecution()) {
                    log.trace(hystrixGetAllStreams.getFailedExecutionException().getMessage(), hystrixGetAllStreams.getFailedExecutionException());
                }
                log.error("Failed to check for Stream Events (Live/Offline/...): " + ex.getMessage());
            }
        };
        this.followerEventTask = channelId -> {
            HystrixCommand commandGetFollowers = twitchHelix.getChannelFollowers(null, channelId, null, Integer.valueOf(100), null);
            try {
                ChannelCache currentChannelCache = (ChannelCache)this.channelInformation.computeIfAbsent(channelId, s -> new ChannelCache());
                Instant lastFollowDate = currentChannelCache.getLastFollowCheck();
                boolean nextRequestCanBeImmediate = false;
                if (lastFollowDate != null) {
                    InboundFollowers executionResult = (InboundFollowers)commandGetFollowers.execute();
                    List followList = executionResult.getFollows();
                    this.followBackoff.get().reset();
                    String channelName = currentChannelCache.getUserName();
                    EventChannel channel = new EventChannel(channelId, channelName);
                    Integer followCount = executionResult.getTotal();
                    Integer oldTotal = currentChannelCache.getFollowers().getAndSet(followCount);
                    if (oldTotal != null && followCount != null && !followCount.equals(oldTotal)) {
                        eventManager.publish((Object)new ChannelFollowCountUpdateEvent(channel, followCount, oldTotal));
                    }
                    if (followList == null || followList.isEmpty() && followCount != null && followCount > 0) {
                        log.trace("Unable to read individual followers of {} due to insufficient authorization (token does not represent a moderator of the channel or lacks 'moderator:read:followers' scope)", (Object)channel);
                    } else {
                        for (InboundFollow follow : followList) {
                            if (lastFollowDate == null || follow.getFollowedAt().isAfter(lastFollowDate)) {
                                lastFollowDate = follow.getFollowedAt();
                            }
                            if (!follow.getFollowedAt().isAfter(currentChannelCache.getLastFollowCheck())) continue;
                            FollowEvent event = new FollowEvent(channel, new EventUser(follow.getUserId(), follow.getUserLogin()));
                            eventManager.publish((Object)event);
                        }
                    }
                } else {
                    nextRequestCanBeImmediate = true;
                }
                if (currentChannelCache.getLastFollowCheck() == null) {
                    currentChannelCache.setLastFollowCheck(Instant.now());
                } else if (lastFollowDate != null) {
                    currentChannelCache.setLastFollowCheck(lastFollowDate);
                }
                return nextRequestCanBeImmediate;
            }
            catch (Exception ex) {
                if (commandGetFollowers != null && commandGetFollowers.isFailedExecution()) {
                    log.trace(ex.getMessage(), (Throwable)ex);
                }
                log.error("Failed to check for Follow Events: " + ex.getMessage());
                return false;
            }
        };
        this.clipEventTask = channelId -> {
            boolean nextRequestCanBeImmediate = false;
            ChannelCache currentChannelCache = (ChannelCache)this.channelInformation.computeIfAbsent(channelId, c -> new ChannelCache());
            AtomicReference<Instant> windowStart = currentChannelCache.getClipWindowStart();
            Instant startedAt = windowStart.get();
            Instant now = Instant.now();
            if (startedAt == null) {
                nextRequestCanBeImmediate = windowStart.compareAndSet(null, now);
            } else {
                List<Clip> clips = this.getClips((String)channelId, startedAt, now.plus(10L, ChronoUnit.MINUTES));
                if (!clips.isEmpty() && clips.get(0) != null && currentChannelCache.getUserName() == null) {
                    currentChannelCache.setUserName(clips.get(0).getBroadcasterName());
                }
                EventChannel channel = new EventChannel(channelId, currentChannelCache.getUserName());
                Instant maxCreatedAt = startedAt;
                for (Clip clip : clips) {
                    if (clip == null || clip.getCreatedAtInstant() == null || clip.getCreatedAtInstant().compareTo(startedAt) <= 0) continue;
                    eventManager.publish((Object)new ChannelClipCreatedEvent(channel, clip));
                    if (clip.getCreatedAtInstant().compareTo(maxCreatedAt) <= 0) continue;
                    maxCreatedAt = clip.getCreatedAtInstant();
                }
                Instant nextStartedAt = maxCreatedAt;
                if (nextStartedAt != startedAt) {
                    windowStart.updateAndGet(old -> old == null || old.compareTo(nextStartedAt) < 0 ? nextStartedAt : old);
                }
            }
            return nextRequestCanBeImmediate;
        };
        String warningPrefix = "The client helper can only fire ChannelFollowCountUpdateEvent; ";
        if (defaultToken == null) {
            this.followListenerWarning = "The client helper can only fire ChannelFollowCountUpdateEvent; the automatic app access token is insufficient to fire FollowEvent due to Twitch API changes.";
        } else {
            credentialManager.getIdentityProviderByName("twitch", TwitchIdentityProvider.class).orElseGet(() -> new TwitchIdentityProvider(null, null, null)).getAdditionalCredentialInformation(defaultToken).ifPresent(cred -> {
                if (cred.getUserId() == null || cred.getUserId().isEmpty()) {
                    this.followListenerWarning = "The client helper can only fire ChannelFollowCountUpdateEvent; the provided app access token is insufficient to fire FollowEvent due to Twitch API changes.";
                } else {
                    List scopes = cred.getScopes();
                    if (scopes == null || !scopes.contains(TwitchScopes.HELIX_CHANNEL_FOLLOWERS_READ.toString())) {
                        this.followListenerWarning = "The client helper can only fire ChannelFollowCountUpdateEvent; the provided user access token lacks the 'moderator:read:followers' scope (and must represent a moderator of the target channel) to fire FollowEvent due to Twitch API changes.";
                    }
                }
            });
        }
    }

    @Override
    public boolean enableStreamEventListener(String channelId, String channelName) {
        boolean add = this.listenForGoLive.add(channelId);
        if (!add) {
            log.info("Channel {} already added for Stream Events", (Object)channelName);
        } else {
            this.channelInformation.computeIfAbsent((Object)channelId, s -> new ChannelCache(channelName));
        }
        this.startOrStopEventGenerationThread();
        return add;
    }

    @Override
    public boolean disableStreamEventListenerForId(String channelId) {
        ChannelCache info;
        boolean remove = this.listenForGoLive.remove(channelId);
        if (!this.listenForFollow.contains(channelId) && !this.listenForClips.contains(channelId)) {
            this.channelInformation.remove((Object)channelId);
        } else if (remove && (info = (ChannelCache)this.channelInformation.get((Object)channelId)) != null) {
            info.setIsLive(null);
            info.setGameId(null);
            info.setTitle(null);
        }
        this.startOrStopEventGenerationThread();
        return remove;
    }

    @Override
    public boolean enableFollowEventListener(String channelId, String channelName) {
        boolean add = this.listenForFollow.add(channelId);
        if (!add) {
            log.info("Channel {} already added for Follow Events", (Object)channelName);
        } else {
            this.channelInformation.computeIfAbsent((Object)channelId, s -> new ChannelCache(channelName));
            if (this.followListenerWarning != null) {
                log.info(this.followListenerWarning);
            }
        }
        this.startOrStopEventGenerationThread();
        return add;
    }

    @Override
    public boolean disableFollowEventListenerForId(String channelId) {
        ChannelCache info;
        boolean remove = this.listenForFollow.remove(channelId);
        if (!this.listenForGoLive.contains(channelId) && !this.listenForClips.contains(channelId)) {
            this.channelInformation.remove((Object)channelId);
        } else if (remove && (info = (ChannelCache)this.channelInformation.get((Object)channelId)) != null) {
            info.setLastFollowCheck(null);
            info.getFollowers().lazySet(null);
        }
        this.startOrStopEventGenerationThread();
        return remove;
    }

    @Override
    public boolean enableClipEventListener(String channelId, String channelName, Instant startedAt) {
        boolean add = this.listenForClips.add(channelId);
        if (!add) {
            log.info("Channel {} already added for Clip Creation Events", (Object)channelName);
        } else {
            ChannelCache channelCache = (ChannelCache)this.channelInformation.computeIfAbsent((Object)channelId, s -> new ChannelCache(channelName));
            channelCache.getClipWindowStart().compareAndSet(null, startedAt);
        }
        this.startOrStopEventGenerationThread();
        return add;
    }

    @Override
    public boolean disableClipEventListenerForId(String channelId) {
        ChannelCache info;
        boolean remove = this.listenForClips.remove(channelId);
        if (!this.listenForGoLive.contains(channelId) && !this.listenForFollow.contains(channelId)) {
            this.channelInformation.remove((Object)channelId);
        } else if (remove && (info = (ChannelCache)this.channelInformation.get((Object)channelId)) != null) {
            info.getClipWindowStart().lazySet(null);
        }
        this.startOrStopEventGenerationThread();
        return remove;
    }

    @Override
    public void setThreadDelay(long threadDelay) {
        UnaryOperator updateBackoff = old -> {
            ExponentialBackoffStrategy next = old.toBuilder().baseMillis(threadDelay).build();
            next.setFailures(old.getFailures());
            return next;
        };
        this.liveBackoff.getAndUpdate(updateBackoff);
        this.followBackoff.getAndUpdate(updateBackoff);
        this.clipBackoff.getAndUpdate(updateBackoff);
    }

    @Override
    public Optional<ChannelCache> getCachedInformation(String channelId) {
        return Optional.ofNullable((ChannelCache)this.channelInformation.get((Object)channelId));
    }

    @Override
    public void close() {
        Future clipFuture;
        Future followerFuture;
        Future streamStatusFuture = this.streamStatusEventFuture.getAndSet(null);
        if (streamStatusFuture != null) {
            streamStatusFuture.cancel(false);
        }
        if ((followerFuture = (Future)this.followerEventFuture.getAndSet(null)) != null) {
            followerFuture.cancel(false);
        }
        if ((clipFuture = (Future)this.clipEventFuture.getAndSet(null)) != null) {
            clipFuture.cancel(false);
        }
        this.listenForGoLive.clear();
        this.listenForFollow.clear();
        this.listenForClips.clear();
        this.channelInformation.clear();
    }

    private void startOrStopEventGenerationThread() {
        this.updateListener(this.listenForGoLive::isEmpty, this.streamStatusEventFuture, this::runRecursiveStreamStatusCheck, this.liveBackoff);
        this.updateListener(this.listenForFollow::isEmpty, this.followerEventFuture, this::runRecursiveFollowerCheck, this.followBackoff);
        this.updateListener(this.listenForClips::isEmpty, this.clipEventFuture, this::runRecursiveClipCheck, this.clipBackoff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListener(BooleanSupplier stopCondition, AtomicReference<Future<?>> futureReference, Runnable startCommand, AtomicReference<ExponentialBackoffStrategy> backoff) {
        if (stopCondition.getAsBoolean()) {
            if (futureReference.get() != null) {
                Future future = null;
                AtomicReference<Future<?>> atomicReference = futureReference;
                synchronized (atomicReference) {
                    if (stopCondition.getAsBoolean()) {
                        future = futureReference.getAndSet(null);
                    }
                }
                if (future != null) {
                    future.cancel(false);
                    backoff.get().reset();
                }
            }
        } else if (futureReference.get() == null) {
            AtomicReference<Future<?>> atomicReference = futureReference;
            synchronized (atomicReference) {
                if (!stopCondition.getAsBoolean() && futureReference.get() == null) {
                    futureReference.set(this.executor.schedule(startCommand, backoff.get().get(), TimeUnit.MILLISECONDS));
                }
            }
        }
    }

    private void runRecursiveStreamStatusCheck() {
        TwitchClientHelper.runRecursiveCheck(this.streamStatusEventFuture, this.executor, CollectionUtils.chunked(this.listenForGoLive, (int)100), this.liveBackoff, this::runRecursiveStreamStatusCheck, chunk -> {
            this.streamStatusEventTask.accept((List<String>)chunk);
            return false;
        });
    }

    private void runRecursiveFollowerCheck() {
        TwitchClientHelper.runRecursiveCheck(this.followerEventFuture, this.executor, new ArrayList<String>(this.listenForFollow), this.followBackoff, this::runRecursiveFollowerCheck, this.followerEventTask);
    }

    private void runRecursiveClipCheck() {
        TwitchClientHelper.runRecursiveCheck(this.clipEventFuture, this.executor, new ArrayList<String>(this.listenForClips), this.clipBackoff, this::runRecursiveClipCheck, this.clipEventTask);
    }

    private List<Clip> getClips(String channelId, Instant startedAt, Instant endedAt) {
        return PaginationUtil.getPaginated(cursor -> {
            HystrixCommand commandGetClips = this.twitchHelix.getClips(null, channelId, null, null, cursor, null, Integer.valueOf(100), startedAt, endedAt, null);
            try {
                ClipList result = (ClipList)commandGetClips.execute();
                this.clipBackoff.get().reset();
                return result;
            }
            catch (Exception ex) {
                if (commandGetClips != null && commandGetClips.isFailedExecution()) {
                    log.trace(ex.getMessage(), (Throwable)ex);
                }
                log.error("Failed to check for Clip Events: " + ex.getMessage());
                this.clipBackoff.get().get();
                return null;
            }
        }, ClipList::getData, call -> call.getPagination() != null ? call.getPagination().getCursor() : null, (int)10);
    }

    private static boolean cancel(AtomicReference<Future<?>> futureRef) {
        Future<?> future = futureRef.get();
        return future != null && future.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void runRecursiveCheck(AtomicReference<Future<?>> future, ScheduledExecutorService executor, List<T> units, AtomicReference<ExponentialBackoffStrategy> backoff, Runnable startCommand, Function<T, Boolean> task) {
        if (future.get() != null) {
            AtomicReference<Future<?>> atomicReference = future;
            synchronized (atomicReference) {
                if (TwitchClientHelper.cancel(future)) {
                    future.set(executor.submit(new ListenerRunnable<T>(executor, units, future, backoff, startCommand, task)));
                }
            }
        }
    }

    @Override
    @Generated
    public TwitchHelix getTwitchHelix() {
        return this.twitchHelix;
    }

    private static final class ListenerRunnable<T>
    implements Runnable {
        private final ScheduledExecutorService executor;
        private final List<T> channels;
        private final AtomicReference<Future<?>> futureReference;
        private final AtomicReference<ExponentialBackoffStrategy> backoff;
        private final Runnable startCommand;
        private final Function<T, Boolean> executeSingle;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.channels.isEmpty()) {
                if (this.futureReference.get() != null) {
                    AtomicReference<Future<?>> atomicReference = this.futureReference;
                    synchronized (atomicReference) {
                        if (TwitchClientHelper.cancel(this.futureReference)) {
                            this.backoff.get().reset();
                            this.futureReference.set(this.executor.schedule(this.startCommand, this.backoff.get().get(), TimeUnit.MILLISECONDS));
                        }
                    }
                }
            } else {
                this.run(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run(int index) {
            Boolean skipDelay = this.executeSingle.apply(this.channels.get(index));
            if (this.futureReference.get() != null) {
                AtomicReference<Future<?>> atomicReference = this.futureReference;
                synchronized (atomicReference) {
                    if (TwitchClientHelper.cancel(this.futureReference)) {
                        this.futureReference.set(this.executor.schedule(index + 1 < this.channels.size() ? () -> this.run(index + 1) : this.startCommand, skipDelay != false ? 0L : this.backoff.get().get(), TimeUnit.MILLISECONDS));
                    }
                }
            }
        }

        @Generated
        public ListenerRunnable(ScheduledExecutorService executor, List<T> channels, AtomicReference<Future<?>> futureReference, AtomicReference<ExponentialBackoffStrategy> backoff, Runnable startCommand, Function<T, Boolean> executeSingle) {
            this.executor = executor;
            this.channels = channels;
            this.futureReference = futureReference;
            this.backoff = backoff;
            this.startCommand = startCommand;
            this.executeSingle = executeSingle;
        }

        @Generated
        public ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        @Generated
        public List<T> getChannels() {
            return this.channels;
        }

        @Generated
        public AtomicReference<Future<?>> getFutureReference() {
            return this.futureReference;
        }

        @Generated
        public AtomicReference<ExponentialBackoffStrategy> getBackoff() {
            return this.backoff;
        }

        @Generated
        public Runnable getStartCommand() {
            return this.startCommand;
        }

        @Generated
        public Function<T, Boolean> getExecuteSingle() {
            return this.executeSingle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListenerRunnable)) {
                return false;
            }
            ListenerRunnable other = (ListenerRunnable)o;
            ScheduledExecutorService this$executor = this.getExecutor();
            ScheduledExecutorService other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                return false;
            }
            List<T> this$channels = this.getChannels();
            List<T> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            AtomicReference<Future<?>> this$futureReference = this.getFutureReference();
            AtomicReference<Future<?>> other$futureReference = other.getFutureReference();
            if (this$futureReference == null ? other$futureReference != null : !this$futureReference.equals(other$futureReference)) {
                return false;
            }
            AtomicReference<ExponentialBackoffStrategy> this$backoff = this.getBackoff();
            AtomicReference<ExponentialBackoffStrategy> other$backoff = other.getBackoff();
            if (this$backoff == null ? other$backoff != null : !this$backoff.equals(other$backoff)) {
                return false;
            }
            Runnable this$startCommand = this.getStartCommand();
            Runnable other$startCommand = other.getStartCommand();
            if (this$startCommand == null ? other$startCommand != null : !this$startCommand.equals(other$startCommand)) {
                return false;
            }
            Function<T, Boolean> this$executeSingle = this.getExecuteSingle();
            Function<T, Boolean> other$executeSingle = other.getExecuteSingle();
            return !(this$executeSingle == null ? other$executeSingle != null : !this$executeSingle.equals(other$executeSingle));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduledExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            List<T> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            AtomicReference<Future<?>> $futureReference = this.getFutureReference();
            result = result * 59 + ($futureReference == null ? 43 : $futureReference.hashCode());
            AtomicReference<ExponentialBackoffStrategy> $backoff = this.getBackoff();
            result = result * 59 + ($backoff == null ? 43 : $backoff.hashCode());
            Runnable $startCommand = this.getStartCommand();
            result = result * 59 + ($startCommand == null ? 43 : $startCommand.hashCode());
            Function<T, Boolean> $executeSingle = this.getExecuteSingle();
            result = result * 59 + ($executeSingle == null ? 43 : $executeSingle.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TwitchClientHelper.ListenerRunnable(executor=" + this.getExecutor() + ", channels=" + this.getChannels() + ", futureReference=" + this.getFutureReference() + ", backoff=" + this.getBackoff() + ", startCommand=" + this.getStartCommand() + ", executeSingle=" + this.getExecuteSingle() + ")";
        }
    }
}

