/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.github.twitch4j.TwitchClientPool;
import com.github.twitch4j.auth.TwitchAuth;
import com.github.twitch4j.auth.providers.TwitchIdentityProvider;
import com.github.twitch4j.chat.ITwitchChat;
import com.github.twitch4j.chat.TwitchChatBuilder;
import com.github.twitch4j.chat.TwitchChatConnectionPool;
import com.github.twitch4j.chat.util.TwitchChatLimitHelper;
import com.github.twitch4j.common.config.ProxyConfig;
import com.github.twitch4j.common.config.Twitch4JGlobal;
import com.github.twitch4j.common.util.BucketUtils;
import com.github.twitch4j.common.util.EventManagerUtils;
import com.github.twitch4j.common.util.ThreadUtils;
import com.github.twitch4j.eventsub.socket.IEventSubSocket;
import com.github.twitch4j.eventsub.socket.TwitchEventSocketPool;
import com.github.twitch4j.eventsub.socket.TwitchSingleUserEventSocketPool;
import com.github.twitch4j.extensions.TwitchExtensions;
import com.github.twitch4j.extensions.TwitchExtensionsBuilder;
import com.github.twitch4j.graphql.TwitchGraphQL;
import com.github.twitch4j.graphql.TwitchGraphQLBuilder;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.TwitchHelixBuilder;
import com.github.twitch4j.internal.ChatCommandHelixForwarder;
import com.github.twitch4j.kraken.TwitchKraken;
import com.github.twitch4j.kraken.TwitchKrakenBuilder;
import com.github.twitch4j.pubsub.ITwitchPubSub;
import com.github.twitch4j.pubsub.TwitchPubSubBuilder;
import com.github.twitch4j.pubsub.TwitchPubSubConnectionPool;
import com.github.twitch4j.tmi.TwitchMessagingInterface;
import com.github.twitch4j.tmi.TwitchMessagingInterfaceBuilder;
import feign.Logger;
import io.github.bucket4j.Bandwidth;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchClientPoolBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitchClientPoolBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String redirectUrl = "http://localhost";
    private Integer timeout = 5000;
    @Deprecated
    private Boolean enableExtensions = false;
    private Boolean enableHelix = false;
    @Deprecated
    private Boolean enableKraken = false;
    @Deprecated
    private Boolean enableTMI = false;
    private Boolean enableChat = false;
    private Boolean enableEventSocket = false;
    private Boolean enableChatPool = false;
    private int maxChannelsPerChatInstance = 100;
    protected Collection<String> botOwnerIds = new HashSet<String>();
    protected Set<String> commandPrefixes = new HashSet<String>();
    private Boolean enablePubSub = false;
    private Boolean enablePubSubPool = false;
    private int maxTopicsPerPubSubInstance = 50;
    private Boolean enableGraphQL = false;
    private OAuth2Credential chatAccount;
    private EventManager eventManager = null;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    protected Integer chatQueueSize = 200;
    protected Bandwidth chatRateLimit = TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    @Deprecated
    protected Bandwidth[] chatWhisperLimit = TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    protected Bandwidth chatJoinLimit = TwitchChatLimitHelper.USER_JOIN_LIMIT;
    protected Bandwidth chatAuthLimit = TwitchChatLimitHelper.USER_AUTH_LIMIT;
    protected Bandwidth chatChannelMessageLimit = BucketUtils.simple((long)100L, (Duration)Duration.ofSeconds(30L), (String)"per-channel-limit");
    private long chatQueueTimeout = 1000L;
    private int chatMaxJoinRetries = 7;
    private String chatServer = "wss://irc-ws.chat.twitch.tv:443";
    private String helixBaseUrl = "https://api.twitch.tv/helix";
    @NotNull
    private CredentialManager credentialManager = CredentialManagerBuilder.builder().build();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private long helperThreadDelay = 10000L;
    private OAuth2Credential defaultAuthToken = null;
    private OAuth2Credential defaultFirstPartyToken = null;
    private ProxyConfig proxyConfig = null;
    private Logger.Level feignLogLevel = Logger.Level.NONE;
    private int wsPingPeriod = 15000;
    private int wsCloseDelay = 1000;
    private boolean chatCommandsViaHelix = Instant.now().isAfter(ChatCommandHelixForwarder.ENABLE_AFTER);
    private Bandwidth forwardedChatCommandHelixLimitPerChannel = TwitchChatLimitHelper.MOD_MESSAGE_LIMIT;

    public TwitchClientPoolBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchClientPoolBuilder withCommandTrigger(String commandTrigger) {
        this.commandPrefixes.add(commandTrigger);
        return this;
    }

    @Deprecated
    public TwitchClientPoolBuilder withHelperThreadRate(long helperThreadDelay) {
        return this.withHelperThreadDelay(helperThreadDelay);
    }

    public static TwitchClientPoolBuilder builder() {
        return new TwitchClientPoolBuilder();
    }

    public TwitchClientPool build() {
        ChatCommandHelixForwarder forwarder;
        log.debug("TwitchClientPool: Initializing ErrorTracking ...");
        TwitchAuth.registerIdentityProvider((CredentialManager)this.credentialManager, (String)this.getClientId(), (String)this.getClientSecret(), (String)this.redirectUrl);
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager((EventManager)this.eventManager, this.defaultEventHandler);
        int poolSize = 2;
        if (this.enableChat.booleanValue() || this.enableChatPool.booleanValue()) {
            poolSize += 2;
        }
        if (this.enablePubSub.booleanValue() || this.enablePubSubPool.booleanValue()) {
            ++poolSize;
        }
        if (this.enableEventSocket.booleanValue()) {
            ++poolSize;
        }
        if (this.scheduledThreadPoolExecutor != null && this.scheduledThreadPoolExecutor.getCorePoolSize() < poolSize) {
            log.warn("Twitch4J requires a scheduledThreadPoolExecutor with at least {} threads to be fully functional! Some features may not work as expected.", (Object)poolSize);
        }
        if (this.scheduledThreadPoolExecutor == null) {
            if (this.enableChatPool.booleanValue() || this.enablePubSubPool.booleanValue()) {
                poolSize = Math.max(poolSize, Runtime.getRuntime().availableProcessors());
            }
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor((String)("twitch4j-" + RandomStringUtils.random((int)4, (boolean)true, (boolean)true)), (Integer)poolSize);
        }
        TwitchExtensions extensions = null;
        if (this.enableExtensions.booleanValue()) {
            extensions = TwitchExtensionsBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize.intValue()).withTimeout((long)this.timeout.intValue()).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchHelix helix = this.enableHelix != false ? TwitchHelixBuilder.builder().withBaseUrl(this.helixBaseUrl).withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withDefaultAuthToken(this.defaultAuthToken).withRequestQueueSize(this.requestQueueSize).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build() : null;
        TwitchKraken kraken = null;
        if (this.enableKraken.booleanValue()) {
            kraken = TwitchKrakenBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchMessagingInterface tmi = null;
        if (this.enableTMI.booleanValue()) {
            tmi = TwitchMessagingInterfaceBuilder.builder().withClientId(this.clientId).withClientSecret(this.clientSecret).withUserAgent(this.userAgent).withRequestQueueSize(this.requestQueueSize).withTimeout(this.timeout).withProxyConfig(this.proxyConfig).withLogLevel(this.feignLogLevel).build();
        }
        TwitchChatConnectionPool chat = null;
        ChatCommandHelixForwarder chatCommandHelixForwarder = !(!this.chatCommandsViaHelix || this.enableHelix == false || this.enableChat == false && this.enableChatPool == false || this.chatAccount == null && this.defaultAuthToken == null) ? new ChatCommandHelixForwarder(helix, this.chatAccount != null ? this.chatAccount : this.defaultAuthToken, this.credentialManager.getIdentityProviderByName("twitch", TwitchIdentityProvider.class).orElse(null), this.scheduledThreadPoolExecutor, this.forwardedChatCommandHelixLimitPerChannel) : (forwarder = null);
        if (this.enableChatPool.booleanValue()) {
            chat = ((TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder)((TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder)((TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder)((TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder)((TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder)TwitchChatConnectionPool.builder().eventManager(this.eventManager)).chatAccount(() -> this.chatAccount).chatRateLimit(this.chatRateLimit).whisperRateLimit(this.chatWhisperLimit).joinRateLimit(this.chatJoinLimit).authRateLimit(this.chatAuthLimit).perChannelRateLimit(this.chatChannelMessageLimit).executor(() -> this.scheduledThreadPoolExecutor)).proxyConfig(() -> this.proxyConfig)).maxSubscriptionsPerConnection(this.maxChannelsPerChatInstance)).advancedConfiguration(builder -> builder.withCredentialManager(this.credentialManager).withChatQueueSize(this.chatQueueSize).withBaseUrl(this.chatServer).withChatQueueTimeout(this.chatQueueTimeout).withMaxJoinRetries(this.chatMaxJoinRetries).withOutboundCommandFilter((BiPredicate)forwarder).withWsPingPeriod(this.wsPingPeriod).withWsCloseDelay(this.wsCloseDelay).setCommandPrefixes(this.commandPrefixes).setBotOwnerIds(this.botOwnerIds))).build();
        } else if (this.enableChat.booleanValue()) {
            chat = TwitchChatBuilder.builder().withEventManager(this.eventManager).withCredentialManager(this.credentialManager).withChatAccount(this.chatAccount).withChatQueueSize(this.chatQueueSize).withChatRateLimit(this.chatRateLimit).withWhisperRateLimit(this.chatWhisperLimit).withJoinRateLimit(this.chatJoinLimit).withAuthRateLimit(this.chatAuthLimit).withPerChannelRateLimit(this.chatChannelMessageLimit).withScheduledThreadPoolExecutor(this.scheduledThreadPoolExecutor).withBaseUrl(this.chatServer).withChatQueueTimeout(this.chatQueueTimeout).withProxyConfig(this.proxyConfig).withMaxJoinRetries(this.chatMaxJoinRetries).withOutboundCommandFilter((BiPredicate)forwarder).setBotOwnerIds(this.botOwnerIds).setCommandPrefixes(this.commandPrefixes).withWsPingPeriod(this.wsPingPeriod).withWsCloseDelay(this.wsCloseDelay).build();
        }
        TwitchEventSocketPool eventSocket = null;
        if (this.enableEventSocket.booleanValue()) {
            eventSocket = TwitchEventSocketPool.builder().eventManager(this.eventManager).executor(this.scheduledThreadPoolExecutor).fallbackToken(this.defaultAuthToken).helix(helix).advancedConfiguration(builder -> (TwitchSingleUserEventSocketPool.TwitchSingleUserEventSocketPoolBuilder)builder.proxyConfig(() -> this.proxyConfig)).build();
        }
        TwitchPubSubConnectionPool pubSub = null;
        if (this.enablePubSubPool.booleanValue()) {
            pubSub = ((TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder)((TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder)((TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder)((TwitchPubSubConnectionPool.TwitchPubSubConnectionPoolBuilder)TwitchPubSubConnectionPool.builder().eventManager(this.eventManager)).executor(() -> this.scheduledThreadPoolExecutor)).proxyConfig(() -> this.proxyConfig)).advancedConfiguration(builder -> builder.withWsPingPeriod(this.wsPingPeriod).withWsCloseDelay(this.wsCloseDelay).setBotOwnerIds(this.botOwnerIds))).build();
        } else if (this.enablePubSub.booleanValue()) {
            pubSub = TwitchPubSubBuilder.builder().withEventManager(this.eventManager).withScheduledThreadPoolExecutor(this.scheduledThreadPoolExecutor).withProxyConfig(this.proxyConfig).withWsPingPeriod(this.wsPingPeriod).withWsCloseDelay(this.wsCloseDelay).setBotOwnerIds(this.botOwnerIds).build();
        }
        TwitchGraphQL graphql = null;
        if (this.enableGraphQL.booleanValue()) {
            graphql = TwitchGraphQLBuilder.builder().withEventManager(this.eventManager).withDefaultFirstPartyToken(this.defaultFirstPartyToken).withProxyConfig(this.proxyConfig).withTimeout(this.timeout).build();
        }
        TwitchClientPool client = new TwitchClientPool(this.eventManager, extensions, helix, kraken, tmi, (ITwitchChat)chat, (ITwitchPubSub)pubSub, graphql, (IEventSubSocket)eventSocket, this.scheduledThreadPoolExecutor, this.credentialManager, this.defaultAuthToken);
        client.getClientHelper().setThreadDelay(this.helperThreadDelay);
        return client;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public Boolean getEnableExtensions() {
        return this.enableExtensions;
    }

    public Boolean getEnableHelix() {
        return this.enableHelix;
    }

    @Deprecated
    public Boolean getEnableKraken() {
        return this.enableKraken;
    }

    @Deprecated
    public Boolean getEnableTMI() {
        return this.enableTMI;
    }

    public Boolean getEnableChat() {
        return this.enableChat;
    }

    public Boolean getEnableEventSocket() {
        return this.enableEventSocket;
    }

    public Boolean getEnableChatPool() {
        return this.enableChatPool;
    }

    public int getMaxChannelsPerChatInstance() {
        return this.maxChannelsPerChatInstance;
    }

    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    public Set<String> getCommandPrefixes() {
        return this.commandPrefixes;
    }

    public Boolean getEnablePubSub() {
        return this.enablePubSub;
    }

    public Boolean getEnablePubSubPool() {
        return this.enablePubSubPool;
    }

    public int getMaxTopicsPerPubSubInstance() {
        return this.maxTopicsPerPubSubInstance;
    }

    public Boolean getEnableGraphQL() {
        return this.enableGraphQL;
    }

    public OAuth2Credential getChatAccount() {
        return this.chatAccount;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    public Integer getChatQueueSize() {
        return this.chatQueueSize;
    }

    public Bandwidth getChatRateLimit() {
        return this.chatRateLimit;
    }

    @Deprecated
    public Bandwidth[] getChatWhisperLimit() {
        return this.chatWhisperLimit;
    }

    public Bandwidth getChatJoinLimit() {
        return this.chatJoinLimit;
    }

    public Bandwidth getChatAuthLimit() {
        return this.chatAuthLimit;
    }

    public Bandwidth getChatChannelMessageLimit() {
        return this.chatChannelMessageLimit;
    }

    public long getChatQueueTimeout() {
        return this.chatQueueTimeout;
    }

    public int getChatMaxJoinRetries() {
        return this.chatMaxJoinRetries;
    }

    public String getChatServer() {
        return this.chatServer;
    }

    public String getHelixBaseUrl() {
        return this.helixBaseUrl;
    }

    @NotNull
    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    public long getHelperThreadDelay() {
        return this.helperThreadDelay;
    }

    public OAuth2Credential getDefaultAuthToken() {
        return this.defaultAuthToken;
    }

    public OAuth2Credential getDefaultFirstPartyToken() {
        return this.defaultFirstPartyToken;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public Logger.Level getFeignLogLevel() {
        return this.feignLogLevel;
    }

    public int getWsPingPeriod() {
        return this.wsPingPeriod;
    }

    public int getWsCloseDelay() {
        return this.wsCloseDelay;
    }

    public boolean isChatCommandsViaHelix() {
        return this.chatCommandsViaHelix;
    }

    public Bandwidth getForwardedChatCommandHelixLimitPerChannel() {
        return this.forwardedChatCommandHelixLimitPerChannel;
    }

    private TwitchClientPoolBuilder() {
    }

    private TwitchClientPoolBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String redirectUrl, Integer timeout, Boolean enableExtensions, Boolean enableHelix, Boolean enableKraken, Boolean enableTMI, Boolean enableChat, Boolean enableEventSocket, Boolean enableChatPool, int maxChannelsPerChatInstance, Collection<String> botOwnerIds, Set<String> commandPrefixes, Boolean enablePubSub, Boolean enablePubSubPool, int maxTopicsPerPubSubInstance, Boolean enableGraphQL, OAuth2Credential chatAccount, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, Integer chatQueueSize, Bandwidth chatRateLimit, Bandwidth[] chatWhisperLimit, Bandwidth chatJoinLimit, Bandwidth chatAuthLimit, Bandwidth chatChannelMessageLimit, long chatQueueTimeout, int chatMaxJoinRetries, String chatServer, String helixBaseUrl, @NotNull CredentialManager credentialManager, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long helperThreadDelay, OAuth2Credential defaultAuthToken, OAuth2Credential defaultFirstPartyToken, ProxyConfig proxyConfig, Logger.Level feignLogLevel, int wsPingPeriod, int wsCloseDelay, boolean chatCommandsViaHelix, Bandwidth forwardedChatCommandHelixLimitPerChannel) {
        if (credentialManager == null) {
            throw new NullPointerException("credentialManager is marked non-null but is null");
        }
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.redirectUrl = redirectUrl;
        this.timeout = timeout;
        this.enableExtensions = enableExtensions;
        this.enableHelix = enableHelix;
        this.enableKraken = enableKraken;
        this.enableTMI = enableTMI;
        this.enableChat = enableChat;
        this.enableEventSocket = enableEventSocket;
        this.enableChatPool = enableChatPool;
        this.maxChannelsPerChatInstance = maxChannelsPerChatInstance;
        this.botOwnerIds = botOwnerIds;
        this.commandPrefixes = commandPrefixes;
        this.enablePubSub = enablePubSub;
        this.enablePubSubPool = enablePubSubPool;
        this.maxTopicsPerPubSubInstance = maxTopicsPerPubSubInstance;
        this.enableGraphQL = enableGraphQL;
        this.chatAccount = chatAccount;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.chatQueueSize = chatQueueSize;
        this.chatRateLimit = chatRateLimit;
        this.chatWhisperLimit = chatWhisperLimit;
        this.chatJoinLimit = chatJoinLimit;
        this.chatAuthLimit = chatAuthLimit;
        this.chatChannelMessageLimit = chatChannelMessageLimit;
        this.chatQueueTimeout = chatQueueTimeout;
        this.chatMaxJoinRetries = chatMaxJoinRetries;
        this.chatServer = chatServer;
        this.helixBaseUrl = helixBaseUrl;
        this.credentialManager = credentialManager;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.helperThreadDelay = helperThreadDelay;
        this.defaultAuthToken = defaultAuthToken;
        this.defaultFirstPartyToken = defaultFirstPartyToken;
        this.proxyConfig = proxyConfig;
        this.feignLogLevel = feignLogLevel;
        this.wsPingPeriod = wsPingPeriod;
        this.wsCloseDelay = wsCloseDelay;
        this.chatCommandsViaHelix = chatCommandsViaHelix;
        this.forwardedChatCommandHelixLimitPerChannel = forwardedChatCommandHelixLimitPerChannel;
    }

    public TwitchClientPoolBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchClientPoolBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchClientPoolBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withRedirectUrl(String redirectUrl) {
        return this.redirectUrl == redirectUrl ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withTimeout(Integer timeout) {
        return this.timeout == timeout ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    @Deprecated
    public TwitchClientPoolBuilder withEnableExtensions(Boolean enableExtensions) {
        return this.enableExtensions == enableExtensions ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnableHelix(Boolean enableHelix) {
        return this.enableHelix == enableHelix ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    @Deprecated
    public TwitchClientPoolBuilder withEnableKraken(Boolean enableKraken) {
        return this.enableKraken == enableKraken ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    @Deprecated
    public TwitchClientPoolBuilder withEnableTMI(Boolean enableTMI) {
        return this.enableTMI == enableTMI ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnableChat(Boolean enableChat) {
        return this.enableChat == enableChat ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnableEventSocket(Boolean enableEventSocket) {
        return this.enableEventSocket == enableEventSocket ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnableChatPool(Boolean enableChatPool) {
        return this.enableChatPool == enableChatPool ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withMaxChannelsPerChatInstance(int maxChannelsPerChatInstance) {
        return this.maxChannelsPerChatInstance == maxChannelsPerChatInstance ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    public TwitchClientPoolBuilder withEnablePubSub(Boolean enablePubSub) {
        return this.enablePubSub == enablePubSub ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnablePubSubPool(Boolean enablePubSubPool) {
        return this.enablePubSubPool == enablePubSubPool ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withMaxTopicsPerPubSubInstance(int maxTopicsPerPubSubInstance) {
        return this.maxTopicsPerPubSubInstance == maxTopicsPerPubSubInstance ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEnableGraphQL(Boolean enableGraphQL) {
        return this.enableGraphQL == enableGraphQL ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatAccount(OAuth2Credential chatAccount) {
        return this.chatAccount == chatAccount ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatQueueSize(Integer chatQueueSize) {
        return this.chatQueueSize == chatQueueSize ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatRateLimit(Bandwidth chatRateLimit) {
        return this.chatRateLimit == chatRateLimit ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    @Deprecated
    public TwitchClientPoolBuilder withChatWhisperLimit(Bandwidth[] chatWhisperLimit) {
        return this.chatWhisperLimit == chatWhisperLimit ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatJoinLimit(Bandwidth chatJoinLimit) {
        return this.chatJoinLimit == chatJoinLimit ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatAuthLimit(Bandwidth chatAuthLimit) {
        return this.chatAuthLimit == chatAuthLimit ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatChannelMessageLimit(Bandwidth chatChannelMessageLimit) {
        return this.chatChannelMessageLimit == chatChannelMessageLimit ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatQueueTimeout(long chatQueueTimeout) {
        return this.chatQueueTimeout == chatQueueTimeout ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatMaxJoinRetries(int chatMaxJoinRetries) {
        return this.chatMaxJoinRetries == chatMaxJoinRetries ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatServer(String chatServer) {
        return this.chatServer == chatServer ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withHelixBaseUrl(String helixBaseUrl) {
        return this.helixBaseUrl == helixBaseUrl ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withCredentialManager(@NotNull CredentialManager credentialManager) {
        if (credentialManager == null) {
            throw new NullPointerException("credentialManager is marked non-null but is null");
        }
        return this.credentialManager == credentialManager ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withHelperThreadDelay(long helperThreadDelay) {
        return this.helperThreadDelay == helperThreadDelay ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withDefaultAuthToken(OAuth2Credential defaultAuthToken) {
        return this.defaultAuthToken == defaultAuthToken ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withDefaultFirstPartyToken(OAuth2Credential defaultFirstPartyToken) {
        return this.defaultFirstPartyToken == defaultFirstPartyToken ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withFeignLogLevel(Logger.Level feignLogLevel) {
        return this.feignLogLevel == feignLogLevel ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withWsPingPeriod(int wsPingPeriod) {
        return this.wsPingPeriod == wsPingPeriod ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withWsCloseDelay(int wsCloseDelay) {
        return this.wsCloseDelay == wsCloseDelay ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, wsCloseDelay, this.chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    public TwitchClientPoolBuilder withChatCommandsViaHelix(boolean chatCommandsViaHelix) {
        return this.chatCommandsViaHelix == chatCommandsViaHelix ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, chatCommandsViaHelix, this.forwardedChatCommandHelixLimitPerChannel);
    }

    @Deprecated
    public TwitchClientPoolBuilder withForwardedChatCommandHelixLimitPerChannel(Bandwidth forwardedChatCommandHelixLimitPerChannel) {
        return this.forwardedChatCommandHelixLimitPerChannel == forwardedChatCommandHelixLimitPerChannel ? this : new TwitchClientPoolBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.redirectUrl, this.timeout, this.enableExtensions, this.enableHelix, this.enableKraken, this.enableTMI, this.enableChat, this.enableEventSocket, this.enableChatPool, this.maxChannelsPerChatInstance, this.botOwnerIds, this.commandPrefixes, this.enablePubSub, this.enablePubSubPool, this.maxTopicsPerPubSubInstance, this.enableGraphQL, this.chatAccount, this.eventManager, this.defaultEventHandler, this.chatQueueSize, this.chatRateLimit, this.chatWhisperLimit, this.chatJoinLimit, this.chatAuthLimit, this.chatChannelMessageLimit, this.chatQueueTimeout, this.chatMaxJoinRetries, this.chatServer, this.helixBaseUrl, this.credentialManager, this.scheduledThreadPoolExecutor, this.helperThreadDelay, this.defaultAuthToken, this.defaultFirstPartyToken, this.proxyConfig, this.feignLogLevel, this.wsPingPeriod, this.wsCloseDelay, this.chatCommandsViaHelix, forwardedChatCommandHelixLimitPerChannel);
    }
}

