/*
 * Decompiled with CFR 0.152.
 */
package com.github.twitch4j.events;

import com.github.twitch4j.common.events.TwitchEvent;
import com.github.twitch4j.common.events.domain.EventChannel;
import com.github.twitch4j.common.events.domain.EventUser;
import com.github.twitch4j.helix.domain.Clip;
import java.util.Optional;

public final class ChannelClipCreatedEvent
extends TwitchEvent {
    private final EventChannel channel;
    private final Clip clip;

    public Optional<EventUser> getCreatingUser() {
        return Optional.ofNullable(this.clip.getCreatorId()).map(id -> new EventUser(id, this.clip.getCreatorName()));
    }

    public ChannelClipCreatedEvent(EventChannel channel, Clip clip) {
        this.channel = channel;
        this.clip = clip;
    }

    public EventChannel getChannel() {
        return this.channel;
    }

    public Clip getClip() {
        return this.clip;
    }

    public String toString() {
        return "ChannelClipCreatedEvent(channel=" + this.getChannel() + ", clip=" + this.getClip() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelClipCreatedEvent)) {
            return false;
        }
        ChannelClipCreatedEvent other = (ChannelClipCreatedEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EventChannel this$channel = this.getChannel();
        EventChannel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Clip this$clip = this.getClip();
        Clip other$clip = other.getClip();
        return !(this$clip == null ? other$clip != null : !this$clip.equals(other$clip));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelClipCreatedEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventChannel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Clip $clip = this.getClip();
        result = result * 59 + ($clip == null ? 43 : $clip.hashCode());
        return result;
    }
}

