package com.github.theholywaffle.teamspeak3;

/*
 * #%L
 * TeamSpeak 3 Java API
 * %%
 * Copyright (C) 2018 Bert De Geyter, Roger Baumgartner
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeepAlive extends Thread {

	private static final Logger log = LoggerFactory.getLogger(KeepAlive.class);
	private static final int SLEEP = 60_000;

	private final Connection con;

	public KeepAlive(Connection connection) {
		super("[TeamSpeak-3-Java-API] KeepAlive");
		con = connection;
	}

	@Override
	public void run() {
		try {
			while (!isInterrupted()) {
				final long idleTime = con.getIdleTime();
				if (idleTime >= SLEEP) {
					// Using the asynchronous API so we get InterruptedExceptions
					TS3ApiAsync asyncApi = con.getCommandQueue().getAsyncApi();
					asyncApi.whoAmI().await();
				} else {
					Thread.sleep(SLEEP - idleTime);
				}
			}
		} catch (InterruptedException ignored) {
			// Thread stopped properly, ignore
		} catch (Exception e) {
			log.warn("KeepAlive thread has stopped!", e);
			con.internalDisconnect();
		}
	}
}
