/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.api;

import com.github.theholywaffle.teamspeak3.api.exception.TS3Exception;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandFuture<V>
implements Future<V> {
    private static final Logger log = LoggerFactory.getLogger(CommandFuture.class);
    private final Object monitor = new Object();
    private volatile FutureState state = FutureState.WAITING;
    private V value = null;
    private TS3Exception exception = null;
    private SuccessListener<? super V> successListener = null;
    private FailureListener failureListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            while (this.state == FutureState.WAITING) {
                this.monitor.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Object object = this.monitor;
        synchronized (object) {
            long end = System.currentTimeMillis() + unit.toMillis(timeout);
            while (this.state == FutureState.WAITING && System.currentTimeMillis() < end) {
                this.monitor.wait(end - System.currentTimeMillis());
            }
            if (this.state == FutureState.WAITING) {
                throw new TimeoutException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        Object object = this.monitor;
        synchronized (object) {
            boolean interrupted = false;
            while (this.state == FutureState.WAITING) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        Object object = this.monitor;
        synchronized (object) {
            long end = System.currentTimeMillis() + unit.toMillis(timeout);
            boolean interrupted = false;
            while (this.state == FutureState.WAITING && System.currentTimeMillis() < end) {
                try {
                    this.monitor.wait(end - System.currentTimeMillis());
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.state == FutureState.WAITING) {
                throw new TimeoutException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            this.await();
            this.checkForFailure();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Object object = this.monitor;
        synchronized (object) {
            this.await(timeout, unit);
            this.checkForFailure();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getUninterruptibly() {
        Object object = this.monitor;
        synchronized (object) {
            this.awaitUninterruptibly();
            this.checkForFailure();
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        Object object = this.monitor;
        synchronized (object) {
            this.awaitUninterruptibly(timeout, unit);
            this.checkForFailure();
            return this.value;
        }
    }

    private void checkForFailure() {
        if (this.state == FutureState.CANCELLED) {
            throw new CancellationException();
        }
        if (this.state == FutureState.FAILED) {
            this.exception.fillInStackTrace();
            throw this.exception;
        }
    }

    @Override
    public boolean isDone() {
        return this.state != FutureState.WAITING;
    }

    public boolean isSuccessful() {
        return this.state == FutureState.SUCCEEDED;
    }

    @Override
    public boolean isCancelled() {
        return this.state == FutureState.CANCELLED;
    }

    public boolean hasFailed() {
        return this.state == FutureState.FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(V value) {
        SuccessListener<V> listener;
        Object object = this.monitor;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.state = FutureState.SUCCEEDED;
            this.value = value;
            listener = this.successListener;
            this.monitor.notifyAll();
        }
        if (listener != null) {
            try {
                listener.handleSuccess(value);
            }
            catch (Exception e) {
                log.error("SuccessListener threw an exception", (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fail(TS3Exception exception) {
        FailureListener listener;
        Object object = this.monitor;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.state = FutureState.FAILED;
            this.exception = exception;
            listener = this.failureListener;
            this.monitor.notifyAll();
        }
        if (listener != null) {
            try {
                listener.handleFailure(exception);
            }
            catch (Exception e) {
                log.error("FailureListener threw an exception", (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isDone()) {
                return false;
            }
            this.state = FutureState.CANCELLED;
            this.monitor.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandFuture<V> onSuccess(SuccessListener<? super V> listener) {
        V successValue;
        boolean runSuccessListener;
        Object object = this.monitor;
        synchronized (object) {
            if (this.successListener != null) {
                throw new IllegalStateException("Listener already set");
            }
            this.successListener = listener;
            runSuccessListener = this.isSuccessful();
            successValue = this.value;
        }
        if (runSuccessListener) {
            listener.handleSuccess(successValue);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandFuture<V> onFailure(FailureListener listener) {
        TS3Exception failureException;
        boolean runFailureListener;
        Object object = this.monitor;
        synchronized (object) {
            if (this.failureListener != null) {
                throw new IllegalStateException("Listener already set");
            }
            this.failureListener = listener;
            runFailureListener = this.hasFailed();
            failureException = this.exception;
        }
        if (runFailureListener) {
            listener.handleFailure(failureException);
        }
        return this;
    }

    public CommandFuture<V> forwardSuccess(CommandFuture<? super V> otherFuture) {
        return this.onSuccess(otherFuture::set);
    }

    public CommandFuture<V> forwardFailure(CommandFuture<?> otherFuture) {
        return this.onFailure(otherFuture::fail);
    }

    public void forwardResult(CommandFuture<V> otherFuture) {
        this.forwardSuccess(otherFuture).forwardFailure(otherFuture);
    }

    public <F> CommandFuture<F> map(Function<? super V, ? extends F> fn) {
        CommandFuture target = new CommandFuture();
        this.onSuccess(result -> {
            Object output;
            try {
                output = fn.apply((Object)result);
            }
            catch (Exception ex) {
                target.fail(new TS3Exception("CommandFuture 'map' function threw an exception", ex));
                return;
            }
            target.set(output);
        }).forwardFailure(target);
        return target;
    }

    public <F> CommandFuture<F> then(Function<? super V, CommandFuture<F>> fn) {
        CommandFuture target = new CommandFuture();
        this.onSuccess(result -> {
            CommandFuture nextFuture;
            try {
                nextFuture = (CommandFuture)fn.apply((Object)result);
            }
            catch (Exception ex) {
                target.fail(new TS3Exception("CommandFuture 'then' function threw an exception", ex));
                return;
            }
            if (nextFuture == null) {
                target.set(null);
            } else {
                nextFuture.forwardResult(target);
            }
        }).forwardFailure(target);
        return target;
    }

    public static <V> CommandFuture<V> immediate(V value) {
        CommandFuture<V> future = new CommandFuture<V>();
        future.set(value);
        return future;
    }

    @SafeVarargs
    public static <F> CommandFuture<List<F>> ofAll(CommandFuture<F> ... futures) {
        return CommandFuture.ofAll(Arrays.asList(futures));
    }

    public static <F> CommandFuture<List<F>> ofAll(Collection<CommandFuture<F>> futures) {
        if (futures.isEmpty()) {
            throw new IllegalArgumentException("Requires at least 1 future");
        }
        Object[] results = new Object[futures.size()];
        AtomicInteger successCounter = new AtomicInteger(futures.size());
        CommandFuture combined = new CommandFuture();
        Iterator<CommandFuture<F>> iterator = futures.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            int index = i++;
            CommandFuture<F> future = iterator.next();
            future.forwardFailure(combined).onSuccess(result -> {
                results[index] = result;
                if (successCounter.decrementAndGet() == 0) {
                    combined.set(Arrays.asList(results));
                }
            });
        }
        return combined;
    }

    @SafeVarargs
    public static <F> CommandFuture<F> ofAny(CommandFuture<F> ... futures) {
        return CommandFuture.ofAny(Arrays.asList(futures));
    }

    public static <F> CommandFuture<F> ofAny(Collection<CommandFuture<F>> futures) {
        if (futures.isEmpty()) {
            throw new IllegalArgumentException("Requires at least 1 future");
        }
        CommandFuture any = new CommandFuture();
        AtomicInteger failureCounter = new AtomicInteger(futures.size());
        for (CommandFuture<F> future : futures) {
            future.forwardSuccess(any).onFailure(exception -> {
                if (failureCounter.decrementAndGet() == 0) {
                    any.fail(exception);
                }
            });
        }
        return any;
    }

    @FunctionalInterface
    public static interface FailureListener {
        public void handleFailure(TS3Exception var1);
    }

    @FunctionalInterface
    public static interface SuccessListener<V> {
        public void handleSuccess(V var1);
    }

    private static enum FutureState {
        WAITING,
        CANCELLED,
        FAILED,
        SUCCEEDED;

    }
}

