/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.EventManager;
import com.github.theholywaffle.teamspeak3.FileTransferHelper;
import com.github.theholywaffle.teamspeak3.QueryIO;
import com.github.theholywaffle.teamspeak3.TS3Api;
import com.github.theholywaffle.teamspeak3.TS3ApiAsync;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.api.exception.TS3Exception;
import com.github.theholywaffle.teamspeak3.api.exception.TS3QueryShutDownException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.commands.Command;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TS3Query {
    private static final Logger log = LoggerFactory.getLogger(TS3Query.class);
    private final ConnectionHandler connectionHandler;
    private final EventManager eventManager;
    private final ExecutorService userThreadPool;
    private final FileTransferHelper fileTransferHelper;
    private final TS3Api api;
    private final TS3ApiAsync asyncApi;
    private final TS3Config config;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private QueryIO io;

    public TS3Query() {
        this(new TS3Config());
    }

    public TS3Query(TS3Config config) {
        this.config = config;
        this.eventManager = new EventManager(this);
        this.userThreadPool = Executors.newCachedThreadPool();
        this.fileTransferHelper = new FileTransferHelper(config.getHost());
        this.connectionHandler = config.getReconnectStrategy().create(config.getConnectionHandler());
        this.asyncApi = new TS3ApiAsync(this);
        this.api = new TS3Api(this.asyncApi);
    }

    private TS3Query(TS3Query query) {
        this.config = query.config;
        this.eventManager = query.eventManager;
        this.userThreadPool = query.userThreadPool;
        this.fileTransferHelper = query.fileTransferHelper;
        this.connectionHandler = null;
        this.asyncApi = new TS3ApiAsync(this);
        this.api = new TS3Api(this.asyncApi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        TS3Query tS3Query = this;
        synchronized (tS3Query) {
            if (this.userThreadPool.isShutdown()) {
                throw new IllegalStateException("The query has already been shut down");
            }
        }
        QueryIO newIO = new QueryIO(this, this.config);
        try {
            this.connectionHandler.onConnect(new ReconnectQuery(this, newIO));
        }
        catch (Exception e) {
            log.error("ConnectionHandler threw exception in connect handler", (Throwable)e);
        }
        TS3Query tS3Query2 = this;
        synchronized (tS3Query2) {
            QueryIO oldIO = this.io;
            this.io = newIO;
            if (oldIO != null) {
                oldIO.disconnect();
                newIO.continueFrom(oldIO);
            }
            this.connected.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (this.shuttingDown.compareAndSet(false, true)) {
            try {
                this.api.quit();
            }
            catch (TS3Exception e) {
                log.warn("Could not send a quit command to terminate the connection", (Throwable)e);
            }
            finally {
                this.shutDown();
            }
        } else {
            try {
                TS3Query e = this;
                synchronized (e) {
                    while (this.connected.get()) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private synchronized void shutDown() {
        if (this.userThreadPool.isShutdown()) {
            return;
        }
        if (this.io != null) {
            this.io.disconnect();
            this.io.failRemainingCommands();
        }
        this.userThreadPool.shutdown();
        this.connected.set(false);
        this.notifyAll();
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    public TS3Api getApi() {
        return this.api;
    }

    public TS3ApiAsync getAsyncApi() {
        return this.asyncApi;
    }

    synchronized void doCommandAsync(Command c) {
        if (this.userThreadPool.isShutdown()) {
            c.getFuture().fail(new TS3QueryShutDownException());
            return;
        }
        this.io.enqueueCommand(c);
    }

    void submitUserTask(String name, Runnable task) {
        this.userThreadPool.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                log.error(name + " threw an exception", throwable);
            }
        });
    }

    EventManager getEventManager() {
        return this.eventManager;
    }

    FileTransferHelper getFileTransferHelper() {
        return this.fileTransferHelper;
    }

    void fireDisconnect() {
        this.connected.set(false);
        this.submitUserTask("ConnectionHandler disconnect task", this::handleDisconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnect() {
        try {
            this.connectionHandler.onDisconnect(this);
        }
        finally {
            TS3Query tS3Query = this;
            synchronized (tS3Query) {
                if (!this.connected.get()) {
                    this.shuttingDown.set(true);
                    this.shutDown();
                }
            }
        }
    }

    private static class ReconnectQuery
    extends TS3Query {
        private final TS3Query parent;

        private ReconnectQuery(TS3Query query, QueryIO io) {
            super(query);
            ((TS3Query)this).io = io;
            this.parent = query;
        }

        @Override
        public void connect() {
            throw new UnsupportedOperationException("Can't call connect from onConnect handler");
        }

        @Override
        public void exit() {
            this.parent.exit();
        }

        @Override
        synchronized void fireDisconnect() {
            QueryIO io = ((TS3Query)this).io;
            io.disconnect();
            io.failRemainingCommands();
        }
    }

    public static class FloodRate {
        public static final FloodRate DEFAULT = new FloodRate(350);
        public static final FloodRate UNLIMITED = new FloodRate(0);
        private final int ms;

        public static FloodRate custom(int milliseconds) {
            if (milliseconds < 0) {
                throw new IllegalArgumentException("Timeout must be positive");
            }
            return new FloodRate(milliseconds);
        }

        private FloodRate(int ms) {
            this.ms = ms;
        }

        public int getMs() {
            return this.ms;
        }
    }
}

