/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3;

import com.github.theholywaffle.teamspeak3.KeepAliveThread;
import com.github.theholywaffle.teamspeak3.SocketReader;
import com.github.theholywaffle.teamspeak3.SocketWriter;
import com.github.theholywaffle.teamspeak3.TS3Config;
import com.github.theholywaffle.teamspeak3.TS3Query;
import com.github.theholywaffle.teamspeak3.api.exception.TS3ConnectionFailedException;
import com.github.theholywaffle.teamspeak3.api.exception.TS3QueryShutDownException;
import com.github.theholywaffle.teamspeak3.api.reconnect.ConnectionHandler;
import com.github.theholywaffle.teamspeak3.api.reconnect.DisconnectingConnectionHandler;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.response.ResponseBuilder;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueryIO {
    private final Socket socket;
    private final SocketReader socketReader;
    private final SocketWriter socketWriter;
    private final KeepAliveThread keepAlive;
    private final BlockingQueue<Command> sendQueue = new LinkedBlockingQueue<Command>();
    private final BlockingQueue<ResponseBuilder> receiveQueue;

    QueryIO(TS3Query query, TS3Config config) {
        ConnectionHandler handler = config.getReconnectStrategy().create(null);
        this.receiveQueue = config.getFloodRate() == TS3Query.FloodRate.UNLIMITED && handler instanceof DisconnectingConnectionHandler ? new LinkedBlockingQueue<ResponseBuilder>() : new ArrayBlockingQueue<ResponseBuilder>(1);
        Socket tmpSocket = null;
        try {
            this.socket = tmpSocket = new Socket(config.getHost(), config.getQueryPort());
            this.socket.setTcpNoDelay(true);
            this.socket.setSoTimeout(config.getCommandTimeout());
            this.socketWriter = new SocketWriter(this, config);
            this.socketReader = new SocketReader(this, this.socketWriter, query, config);
            this.keepAlive = new KeepAliveThread(this.socketWriter, query.getAsyncApi());
        }
        catch (IOException e) {
            if (tmpSocket != null) {
                try {
                    tmpSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new TS3ConnectionFailedException(e);
        }
        this.socketReader.start();
        this.socketWriter.start();
        this.keepAlive.start();
    }

    public void continueFrom(QueryIO io) {
        if (io == null) {
            return;
        }
        io.socketReader.drainCommandsTo(this.sendQueue);
        io.socketWriter.drainCommandsTo(this.sendQueue);
        io.receiveQueue.clear();
        io.sendQueue.clear();
    }

    public void disconnect() {
        this.keepAlive.interrupt();
        this.socketWriter.interrupt();
        this.socketReader.interrupt();
        try {
            this.keepAlive.join();
            this.socketWriter.join();
            this.socketReader.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void failRemainingCommands() {
        ArrayList<Command> commands = new ArrayList<Command>(this.receiveQueue.size() + this.sendQueue.size() + 1);
        this.socketReader.drainCommandsTo(commands);
        this.socketWriter.drainCommandsTo(commands);
        for (Command command : commands) {
            command.getFuture().fail(new TS3QueryShutDownException());
        }
    }

    public void enqueueCommand(Command command) {
        if (command == null) {
            throw new IllegalArgumentException("Command cannot be null!");
        }
        this.sendQueue.add(command);
    }

    Socket getSocket() {
        return this.socket;
    }

    BlockingQueue<Command> getSendQueue() {
        return this.sendQueue;
    }

    BlockingQueue<ResponseBuilder> getReceiveQueue() {
        return this.receiveQueue;
    }
}

