/*
 * Decompiled with CFR 0.152.
 */
package com.github.theholywaffle.teamspeak3.commands;

import com.github.theholywaffle.teamspeak3.api.ServerGroupType;
import com.github.theholywaffle.teamspeak3.commands.Command;
import com.github.theholywaffle.teamspeak3.commands.CommandBuilder;
import com.github.theholywaffle.teamspeak3.commands.parameter.ArrayParameter;
import com.github.theholywaffle.teamspeak3.commands.parameter.KeyValueParam;
import com.github.theholywaffle.teamspeak3.commands.parameter.OptionParam;

public final class PermissionCommands {
    private PermissionCommands() {
        throw new Error("No instances");
    }

    public static Command permFind(String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        return new CommandBuilder("permfind", 1).add(new KeyValueParam("permsid", permName)).build();
    }

    public static Command permGet(String ... permNames) {
        PermissionCommands.nonEmptyPermissionArray(permNames);
        CommandBuilder builder = new CommandBuilder("permget", 1);
        ArrayParameter permissions = new ArrayParameter(permNames.length);
        for (String permName : permNames) {
            PermissionCommands.nonEmptyPermissionName(permName);
            permissions.add(new KeyValueParam("permsid", permName));
        }
        builder.add(permissions);
        return builder.build();
    }

    public static Command permIdGetByName(String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        return new CommandBuilder("permidgetbyname", 1).add(new KeyValueParam("permsid", permName)).build();
    }

    public static Command permIdGetByName(String ... permNames) {
        PermissionCommands.nonEmptyPermissionArray(permNames);
        CommandBuilder builder = new CommandBuilder("permidgetbyname", 1);
        ArrayParameter permissions = new ArrayParameter(permNames.length);
        for (String permName : permNames) {
            PermissionCommands.nonEmptyPermissionName(permName);
            permissions.add(new KeyValueParam("permsid", permName));
        }
        builder.add(permissions);
        return builder.build();
    }

    public static Command permissionList() {
        return new CommandBuilder("permissionlist").build();
    }

    public static Command permOverview(int channelId, int clientDBId) {
        CommandBuilder builder = new CommandBuilder("permoverview", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new KeyValueParam("permid", 0));
        return builder.build();
    }

    public static Command permReset() {
        return new CommandBuilder("permreset").build();
    }

    public static Command clientAddPerm(int clientDBId, String permName, int permValue, boolean skip) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("clientaddperm", 4);
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        builder.add(new KeyValueParam("permskip", skip));
        return builder.build();
    }

    public static Command clientDelPerm(int clientDBId, String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("clientdelperm", 2);
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command clientPermList(int clientDBId) {
        CommandBuilder builder = new CommandBuilder("clientpermlist", 2);
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new OptionParam("permsid"));
        return builder.build();
    }

    public static Command channelAddPerm(int channelId, String permName, int permValue) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channeladdperm", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        return builder.build();
    }

    public static Command channelDelPerm(int channelId, String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channeldelperm", 2);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command channelPermList(int channelId) {
        CommandBuilder builder = new CommandBuilder("channelpermlist", 2);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new OptionParam("permsid"));
        return builder.build();
    }

    public static Command channelClientAddPerm(int channelId, int clientDBId, String permName, int permValue) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channelclientaddperm", 4);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        return builder.build();
    }

    public static Command channelClientDelPerm(int channelId, int clientDBId, String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channelclientdelperm", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command channelClientPermList(int channelId, int clientDBId) {
        CommandBuilder builder = new CommandBuilder("channelclientpermlist", 3);
        builder.add(new KeyValueParam("cid", channelId));
        builder.add(new KeyValueParam("cldbid", clientDBId));
        builder.add(new OptionParam("permsid"));
        return builder.build();
    }

    public static Command channelGroupAddPerm(int groupId, String permName, int permValue) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channelgroupaddperm", 3);
        builder.add(new KeyValueParam("cgid", groupId));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        return builder.build();
    }

    public static Command channelGroupDelPerm(int groupId, String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("channelgroupdelperm", 2);
        builder.add(new KeyValueParam("cgid", groupId));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command channelGroupPermList(int groupId) {
        CommandBuilder builder = new CommandBuilder("channelgrouppermlist", 2);
        builder.add(new KeyValueParam("cgid", groupId));
        builder.add(new OptionParam("permsid"));
        return builder.build();
    }

    public static Command serverGroupAddPerm(int groupId, String permName, int permValue, boolean negate, boolean skip) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("servergroupaddperm", 5);
        builder.add(new KeyValueParam("sgid", groupId));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        builder.add(new KeyValueParam("permnegated", negate));
        builder.add(new KeyValueParam("permskip", skip));
        return builder.build();
    }

    public static Command serverGroupAutoAddPerm(ServerGroupType type, String permName, int permValue, boolean negate, boolean skip) {
        PermissionCommands.nonNullServerGroupType(type);
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("servergroupautoaddperm", 5);
        builder.add(new KeyValueParam("sgtype", type.getIndex()));
        builder.add(new KeyValueParam("permsid", permName));
        builder.add(new KeyValueParam("permvalue", permValue));
        builder.add(new KeyValueParam("permnegated", negate));
        builder.add(new KeyValueParam("permskip", skip));
        return builder.build();
    }

    public static Command serverGroupDelPerm(int groupId, String permName) {
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("servergroupdelperm", 2);
        builder.add(new KeyValueParam("sgid", groupId));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command serverGroupAutoDelPerm(ServerGroupType type, String permName) {
        PermissionCommands.nonNullServerGroupType(type);
        PermissionCommands.nonEmptyPermissionName(permName);
        CommandBuilder builder = new CommandBuilder("servergroupautodelperm", 2);
        builder.add(new KeyValueParam("sgtype", type.getIndex()));
        builder.add(new KeyValueParam("permsid", permName));
        return builder.build();
    }

    public static Command serverGroupPermList(int groupId) {
        CommandBuilder builder = new CommandBuilder("servergrouppermlist", 2);
        builder.add(new KeyValueParam("sgid", groupId));
        builder.add(new OptionParam("permsid"));
        return builder.build();
    }

    private static void nonEmptyPermissionName(String permName) {
        if (permName == null || permName.isEmpty()) {
            throw new IllegalArgumentException("Permission name must be a non-empty string");
        }
    }

    private static void nonEmptyPermissionArray(String[] permNames) {
        if (permNames == null || permNames.length == 0) {
            throw new IllegalArgumentException("Permission name array cannot be null or empty");
        }
    }

    private static void nonNullServerGroupType(ServerGroupType type) {
        if (type == null) {
            throw new IllegalArgumentException("Server group type cannot be null");
        }
    }
}

