/*
 * Decompiled with CFR 0.152.
 */
package org.kathrynhuxtable.maven.wagon.gitsite;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.GitExeScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.kathrynhuxtable.maven.wagon.gitsite.git.GitSiteCheckInCommand;
import org.kathrynhuxtable.maven.wagon.gitsite.git.GitSiteCheckOutCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSiteWagon
extends AbstractWagon {
    private ScmManager scmManager;
    private String siteBranch;
    private File checkoutDirectory;

    public ScmManager getScmManager() {
        return this.scmManager;
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public String getSiteBranch() {
        return this.siteBranch;
    }

    public void setSiteBranch(String siteBranch) {
        this.siteBranch = siteBranch;
    }

    public File getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(File checkoutDirectory) {
        this.checkoutDirectory = checkoutDirectory;
    }

    public ScmProvider getScmProvider(String scmType) throws NoSuchScmProviderException {
        return this.getScmManager().getProviderByType(scmType);
    }

    public void openConnectionInternal() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            this.checkoutDirectory = this.createCheckoutDirectory();
        }
        if (this.checkoutDirectory.exists()) {
            this.removeCheckoutDirectory();
        }
        this.checkoutDirectory.mkdirs();
    }

    private File createCheckoutDirectory() {
        File checkoutDirectory;
        DecimalFormat fmt = new DecimalFormat("#####");
        Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
        while ((checkoutDirectory = new File(System.getProperty("java.io.tmpdir"), "wagon-scm" + fmt.format(Math.abs(rand.nextInt())) + ".checkout")).exists()) {
        }
        return checkoutDirectory;
    }

    private void removeCheckoutDirectory() throws ConnectionException {
        if (this.checkoutDirectory == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)this.checkoutDirectory);
        }
        catch (IOException e) {
            throw new ConnectionException("Unable to cleanup checkout directory", (Throwable)e);
        }
    }

    private ScmRepository getScmRepository(String url) throws ScmRepositoryException, NoSuchScmProviderException {
        String username = null;
        String password = null;
        String privateKey = null;
        String passphrase = null;
        if (this.authenticationInfo != null) {
            username = this.authenticationInfo.getUserName();
            password = this.authenticationInfo.getPassword();
            privateKey = this.authenticationInfo.getPrivateKey();
            passphrase = this.authenticationInfo.getPassphrase();
        }
        ScmRepository scmRepository = this.getScmManager().makeScmRepository(url);
        ScmProviderRepository providerRepository = scmRepository.getProviderRepository();
        if (StringUtils.isNotEmpty((String)username)) {
            providerRepository.setUser(username);
        }
        if (StringUtils.isNotEmpty((String)password)) {
            providerRepository.setPassword(password);
        }
        if (providerRepository instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost providerRepo = (ScmProviderRepositoryWithHost)providerRepository;
            if (StringUtils.isNotEmpty((String)privateKey)) {
                providerRepo.setPrivateKey(privateKey);
            }
            if (StringUtils.isNotEmpty((String)passphrase)) {
                providerRepo.setPassphrase(passphrase);
            }
        }
        return scmRepository;
    }

    private void checkIn(ScmProvider scmProvider, ScmRepository scmRepository, String msg) throws ScmException {
        CommandParameters parameters = new CommandParameters();
        parameters.setScmVersion(CommandParameter.SCM_VERSION, (ScmVersion)new ScmBranch(this.siteBranch));
        parameters.setString(CommandParameter.MESSAGE, msg);
        CheckInScmResult result = (CheckInScmResult)this.executeCommand((GitExeScmProvider)scmProvider, new GitSiteCheckInCommand(), scmRepository.getProviderRepository(), new ScmFileSet(this.checkoutDirectory), parameters);
        this.checkScmResult((ScmResult)result);
    }

    private String checkOut(ScmProvider scmProvider, ScmRepository scmRepository, String targetName, Resource resource) throws TransferFailedException {
        int iGitSuffix;
        this.checkoutDirectory = this.createCheckoutDirectory();
        Stack<String> stack = new Stack<String>();
        String target = targetName;
        try {
            while (target.length() > 0 && !scmProvider.list(scmRepository, new ScmFileSet(new File("."), new File(target)), false, (ScmVersion)null).isSuccess()) {
                stack.push(this.getFilename(target));
                target = this.getDirname(target);
            }
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error listing repository: " + e.getMessage(), (Throwable)e);
        }
        String url = this.getRepository().getUrl() + targetName;
        String relPath = "";
        if (!url.endsWith(".git") && (iGitSuffix = url.lastIndexOf(".git")) > 0) {
            relPath = url.substring(iGitSuffix + 5) + '/';
            url = url.substring(0, iGitSuffix + 4);
        }
        ScmLogger logger = ((GitExeScmProvider)scmProvider).getLogger();
        logger.debug("checkOut url: " + url);
        logger.debug("checkOut relPath: " + relPath);
        try {
            scmRepository = this.getScmRepository(url);
            CommandParameters parameters = new CommandParameters();
            parameters.setScmVersion(CommandParameter.SCM_VERSION, (ScmVersion)new ScmBranch(this.siteBranch));
            parameters.setString(CommandParameter.RECURSIVE, "false");
            CheckOutScmResult ret = (CheckOutScmResult)this.executeCommand((GitExeScmProvider)scmProvider, new GitSiteCheckOutCommand(), scmRepository.getProviderRepository(), new ScmFileSet(new File(this.checkoutDirectory, "")), parameters);
            this.checkScmResult((ScmResult)ret);
        }
        catch (ScmException e) {
            this.fireTransferError(resource, (Exception)((Object)e), 6);
            throw new TransferFailedException("Error checking out: " + e.getMessage(), (Throwable)e);
        }
        while (!stack.isEmpty()) {
            String p = (String)stack.pop();
            relPath = relPath + p + '/';
            logger.debug(" * checkOut relPath: " + relPath);
            File newDir = new File(this.checkoutDirectory, relPath);
            if (!newDir.mkdirs()) {
                throw new TransferFailedException("Failed to create directory " + newDir.getAbsolutePath() + "; parent should exist: " + this.checkoutDirectory);
            }
            try {
                this.addFiles(scmProvider, scmRepository, this.checkoutDirectory, relPath);
            }
            catch (ScmException e) {
                this.fireTransferError(resource, (Exception)((Object)e), 6);
                throw new TransferFailedException("Failed to add directory " + newDir + " to working copy", (Throwable)e);
            }
        }
        return relPath;
    }

    private int addFiles(ScmProvider scmProvider, ScmRepository scmRepository, File basedir, String scmFilePath) throws ScmException {
        int addedFiles = 0;
        File scmFile = new File(basedir, scmFilePath);
        if (scmFilePath.length() != 0) {
            AddScmResult result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)));
            if (!result.isSuccess()) {
                result = scmProvider.add(scmRepository, new ScmFileSet(basedir, new File(scmFilePath)));
            }
            addedFiles = result.getAddedFiles().size();
        }
        String reservedScmFile = scmProvider.getScmSpecificFilename();
        if (scmFile.isDirectory()) {
            File[] files = scmFile.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (reservedScmFile == null || reservedScmFile.equals(files[i].getName())) continue;
                addedFiles += this.addFiles(scmProvider, scmRepository, basedir, (scmFilePath.length() == 0 ? "" : scmFilePath + "/") + files[i].getName());
            }
        }
        return addedFiles;
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        String url = repository.getUrl();
        if (url.startsWith("gitsite:")) {
            int index = (url = url.substring(8)).indexOf(58);
            if (index > -1) {
                this.siteBranch = url.substring(index + 1);
                url = url.substring(0, index);
            } else {
                this.siteBranch = url.indexOf(".github.com.git") != -1 ? "master" : "gh-pages";
            }
            url = url.startsWith("file:///") ? "scm:git:" + url : "scm:git:ssh://" + url;
            repository.setUrl(url);
        }
        super.connect(repository, authenticationInfo, proxyInfoProvider);
    }

    public void put(File source, String destination) throws TransferFailedException {
        this.putResource(source, destination);
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalArgumentException("Source is not a directory: " + sourceDirectory);
        }
        this.putResource(sourceDirectory, destinationDirectory);
    }

    private void putResource(File sourceDirectory, String destinationDirectory) throws TransferFailedException {
        Resource target = new Resource(destinationDirectory);
        this.firePutInitiated(target, sourceDirectory);
        try {
            ScmRepository scmRepository = this.getScmRepository(this.getRepository().getUrl());
            target.setContentLength(sourceDirectory.length());
            target.setLastModified(sourceDirectory.lastModified());
            this.firePutStarted(target, sourceDirectory);
            String msg = "Wagon: Deploying " + sourceDirectory.getName() + " to repository";
            ScmProvider scmProvider = this.getScmProvider(scmRepository.getProvider());
            String checkoutTargetName = sourceDirectory.isDirectory() ? destinationDirectory : this.getDirname(destinationDirectory);
            String relPath = this.checkOut(scmProvider, scmRepository, checkoutTargetName, target);
            File newCheckoutDirectory = new File(this.checkoutDirectory, relPath);
            File scmFile = new File(newCheckoutDirectory, sourceDirectory.isDirectory() ? "" : this.getFilename(destinationDirectory));
            boolean fileAlreadyInScm = scmFile.exists();
            if (!scmFile.equals(sourceDirectory)) {
                if (sourceDirectory.isDirectory()) {
                    FileUtils.copyDirectoryStructure((File)sourceDirectory, (File)scmFile);
                } else {
                    FileUtils.copyFile((File)sourceDirectory, (File)scmFile);
                }
            }
            if (!fileAlreadyInScm || scmFile.isDirectory()) {
                int addedFiles = this.addFiles(scmProvider, scmRepository, newCheckoutDirectory, sourceDirectory.isDirectory() ? "" : scmFile.getName());
                if (!fileAlreadyInScm && addedFiles == 0) {
                    throw new ScmException("Unable to add file to SCM: " + scmFile + "; see error messages above for more information");
                }
            }
            this.checkIn(scmProvider, scmRepository, msg);
        }
        catch (ScmException e) {
            e.printStackTrace();
            this.fireTransferError(target, (Exception)((Object)e), 5);
            System.exit(1);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.fireTransferError(target, e, 5);
            throw new TransferFailedException("Error interacting with SCM: " + e.getMessage(), (Throwable)e);
        }
        if (sourceDirectory.isFile()) {
            this.postProcessListeners(target, sourceDirectory, 6);
        }
        this.firePutCompleted(target, sourceDirectory);
    }

    private void checkScmResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            throw new ScmException("Unable to commit file. " + result.getProviderMessage() + " " + (result.getCommandOutput() == null ? "" : result.getCommandOutput()));
        }
    }

    public void closeConnection() throws ConnectionException {
        this.removeCheckoutDirectory();
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("Not currently supported: getIfNewer");
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        throw new UnsupportedOperationException("Not currently supported: get");
    }

    public List<String> getFileList(String resourcePath) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            ScmRepository repository = this.getScmRepository(this.getRepository().getUrl());
            ScmProvider provider = this.getScmProvider(repository.getProvider());
            ListScmResult result = provider.list(repository, new ScmFileSet(new File("."), new File(resourcePath)), false, (ScmVersion)null);
            if (!result.isSuccess()) {
                throw new ResourceDoesNotExistException(result.getProviderMessage());
            }
            ArrayList<String> files = new ArrayList<String>();
            for (ScmFile f : this.getListScmResultFiles(result)) {
                files.add(f.getPath());
                System.out.println("LIST FILE: " + f + " (path=" + f.getPath() + ")");
            }
            return files;
        }
        catch (ScmException e) {
            throw new TransferFailedException("Error getting filelist from SCM", (Throwable)e);
        }
    }

    private List<ScmFile> getListScmResultFiles(ListScmResult result) {
        return result.getFiles();
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            this.getFileList(resourceName);
            return true;
        }
        catch (ResourceDoesNotExistException e) {
            return false;
        }
    }

    private String getFilename(String filename) {
        String fname = StringUtils.replace((String)filename, (String)"/", (String)File.separator);
        return FileUtils.filename((String)fname);
    }

    private String getDirname(String filename) {
        String fname = StringUtils.replace((String)filename, (String)"/", (String)File.separator);
        return FileUtils.dirname((String)fname);
    }

    protected ScmResult executeCommand(GitExeScmProvider scmProvider, GitCommand command, ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        command.setLogger(scmProvider.getLogger());
        return command.execute(repository, fileSet, parameters);
    }
}

