/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.events4j.core;

import com.github.philippheuer.events4j.api.IEventManager;
import com.github.philippheuer.events4j.api.domain.DisposableWrapper;
import com.github.philippheuer.events4j.api.domain.IDisposable;
import com.github.philippheuer.events4j.api.domain.IEvent;
import com.github.philippheuer.events4j.api.domain.IEventSubscription;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.api.service.IServiceMediator;
import com.github.philippheuer.events4j.core.services.ServiceMediator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager
implements IEventManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventManager.class);
    private final IServiceMediator serviceMediator;
    private final List<IEventHandler> eventHandlers = new ArrayList<IEventHandler>();
    private volatile boolean isStopped;
    private String defaultEventHandler;
    private final Map<String, IEventSubscription> activeSubscriptions = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger consumerSequence = new AtomicInteger(1);
    private final Map<String, Class<? extends IEventHandler>> eventHandlerCache = new HashMap<String, Class<? extends IEventHandler>>();

    public EventManager() {
        this.serviceMediator = new ServiceMediator(this);
    }

    public void registerEventHandler(IEventHandler eventHandler) {
        if (!this.eventHandlers.contains(eventHandler)) {
            this.eventHandlers.add(eventHandler);
            this.eventHandlerCache.put(eventHandler.getClass().getCanonicalName(), eventHandler.getClass());
        }
    }

    public List<IEventSubscription> getActiveSubscriptions() {
        return Collections.unmodifiableList(new ArrayList<IEventSubscription>(this.activeSubscriptions.values()));
    }

    public void autoDiscovery() {
        Class<?> handlerClass;
        try {
            handlerClass = Class.forName("com.github.philippheuer.events4j.simple.SimpleEventHandler");
            log.info("Auto Discovery: SimpleEventHandler registered!");
            this.registerEventHandler((IEventHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalStateException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.debug("Auto Discovery: SimpleEventHandler not available!");
        }
        try {
            handlerClass = Class.forName("com.github.philippheuer.events4j.reactor.ReactorEventHandler");
            log.info("Auto Discovery: ReactorEventHandler registered!");
            this.registerEventHandler((IEventHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalStateException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.debug("Auto Discovery: ReactorEventHandler not available!");
        }
    }

    public void publish(Object event) {
        if (this.isStopped) {
            log.warn("Tried to dispatch a event to a closed eventManager!");
            return;
        }
        if (event instanceof IEvent) {
            IEvent iEvent = (IEvent)event;
            if (iEvent.getServiceMediator() == null) {
                iEvent.setServiceMediator(this.getServiceMediator());
            }
            if (log.isDebugEnabled()) {
                log.debug("Dispatching event of type {} with id {}.", (Object)event.getClass().getSimpleName(), (Object)iEvent.getEventId());
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Dispatching event of type {}.", (Object)event.getClass().getSimpleName());
        }
        this.eventHandlers.forEach(eventHandler -> eventHandler.publish(event));
    }

    public boolean hasEventHandler(Class<? extends IEventHandler> eventHandlerClass) {
        return this.getEventHandlers().stream().anyMatch(h -> h.getClass().getName().equalsIgnoreCase(eventHandlerClass.getName()));
    }

    public <E extends IEventHandler> E getEventHandler(Class<E> eventHandlerClass) {
        Optional<IEventHandler> eventHandler = this.getEventHandlers().stream().filter(h -> h.getClass().getName().equalsIgnoreCase(eventHandlerClass.getName())).map(h -> h).findAny();
        return (E)eventHandler.orElseThrow(() -> new RuntimeException("No eventHandler of type " + eventHandlerClass.getName() + " is registered!"));
    }

    public <E> IEventSubscription onEvent(Class<E> eventClass, Consumer<E> consumer) {
        return this.onEvent(consumer.getClass().getCanonicalName() + "/" + this.consumerSequence.getAndAdd(1), eventClass, consumer);
    }

    public synchronized <E> IEventSubscription onEvent(String id, Class<E> eventClass, Consumer<E> consumer) {
        IDisposable disposable;
        Class<? extends IEventHandler> handlerClass;
        if (this.activeSubscriptions.containsKey(id)) {
            return null;
        }
        String eventHandler = this.defaultEventHandler;
        if (eventHandler == null) {
            if (this.eventHandlers.size() == 1) {
                eventHandler = this.defaultEventHandler = this.eventHandlers.get(0).getClass().getCanonicalName();
            } else {
                throw new RuntimeException("When more than one eventHandler has been registered you have to specify the defaultEventHandler using EventManager#setDefaultEventHandler!");
            }
        }
        if ((handlerClass = this.eventHandlerCache.get(eventHandler)) != null && (disposable = this.getEventHandler(handlerClass).onEvent(eventClass, consumer)) != null) {
            return new DisposableWrapper(disposable, id, eventClass, consumer, this.activeSubscriptions);
        }
        throw new RuntimeException("EventHandler " + eventHandler + " has not been registered for EventManager.onEvent!");
    }

    public void setDefaultEventHandler(Class eventHandler) {
        this.defaultEventHandler = eventHandler.getCanonicalName();
    }

    public void setDefaultEventHandler(String eventHandler) {
        this.defaultEventHandler = eventHandler;
    }

    public void close() {
        this.isStopped = true;
        this.getActiveSubscriptions().forEach(IDisposable::dispose);
        this.eventHandlers.forEach(eventHandler -> {
            try {
                eventHandler.close();
            }
            catch (Exception ex) {
                log.error("Failed to close event handler!", (Throwable)ex);
            }
        });
    }

    @Generated
    public IServiceMediator getServiceMediator() {
        return this.serviceMediator;
    }

    @Generated
    public List<IEventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    @Generated
    public boolean isStopped() {
        return this.isStopped;
    }

    @Generated
    public String getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    @Generated
    public AtomicInteger getConsumerSequence() {
        return this.consumerSequence;
    }

    @Generated
    public Map<String, Class<? extends IEventHandler>> getEventHandlerCache() {
        return this.eventHandlerCache;
    }
}

