/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.util;

import java.net.InetSocketAddress;
import java.net.Proxy;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ProxyHelper {
    @Nullable
    public static Proxy selectProxy() {
        if (!StringUtils.isEmpty((CharSequence)ProxyHelper.getSystemHttpsProxyHost()) && ProxyHelper.getSystemHttpsProxyPort() > 0) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyHelper.getSystemHttpsProxyHost(), (int)ProxyHelper.getSystemHttpsProxyPort()));
        }
        if (!StringUtils.isEmpty((CharSequence)ProxyHelper.getSystemHttpProxyHost()) && ProxyHelper.getSystemHttpProxyPort() > 0) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyHelper.getSystemHttpProxyHost(), (int)ProxyHelper.getSystemHttpProxyPort()));
        }
        return null;
    }

    public static String getSystemHttpProxyHost() {
        return ProxyHelper.getProxyHostByKey("http_proxy") != null ? ProxyHelper.getProxyHostByKey("http_proxy") : ProxyHelper.getProxyHostByKey("HTTP_PROXY");
    }

    public static Integer getSystemHttpProxyPort() {
        return ProxyHelper.getProxyPortByKey("http_proxy") != null ? ProxyHelper.getProxyPortByKey("http_proxy") : ProxyHelper.getProxyPortByKey("HTTP_PROXY");
    }

    public static String getSystemHttpsProxyHost() {
        return ProxyHelper.getProxyHostByKey("https_proxy") != null ? ProxyHelper.getProxyHostByKey("https_proxy") : ProxyHelper.getProxyHostByKey("HTTPS_PROXY");
    }

    public static Integer getSystemHttpsProxyPort() {
        return ProxyHelper.getProxyPortByKey("https_proxy") != null ? ProxyHelper.getProxyPortByKey("https_proxy") : ProxyHelper.getProxyPortByKey("HTTPS_PROXY");
    }

    private static String getProxyHostByKey(String propertyName) {
        String httpProxy = System.getenv(propertyName);
        if (httpProxy == null) {
            return null;
        }
        String[] proxyInfo = httpProxy.replace("http://", "").replace("https://", "").split(":");
        if (proxyInfo.length == 2) {
            return proxyInfo[0];
        }
        return null;
    }

    private static Integer getProxyPortByKey(String propertyName) {
        String httpProxy = System.getenv(propertyName);
        if (httpProxy == null) {
            return null;
        }
        String[] proxyInfo = httpProxy.replace("http://", "").replace("https://", "").split(":");
        if (proxyInfo.length == 2) {
            return Integer.parseInt(proxyInfo[1]);
        }
        return null;
    }
}

