/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.identityprovider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.IdentityProvider;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.util.ProxyHelper;
import java.net.Proxy;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OAuth2IdentityProvider
extends IdentityProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2IdentityProvider.class);
    protected static final ObjectMapper OBJECTMAPPER = new ObjectMapper();
    protected OkHttpClient httpClient = new OkHttpClient();
    protected String clientId;
    protected String clientSecret;
    protected String authUrl;
    protected String tokenUrl;
    protected String redirectUrl;
    protected String scopeSeperator = " ";
    protected String responseType = "code";
    protected String tokenEndpointPostType = "QUERY";

    public OAuth2IdentityProvider(String providerName, String providerType, String clientId, String clientSecret, String authUrl, String tokenUrl, String redirectUrl) {
        this(providerName, providerType, clientId, clientSecret, authUrl, tokenUrl, redirectUrl, ProxyHelper.selectProxy());
    }

    public OAuth2IdentityProvider(String providerName, String providerType, String clientId, String clientSecret, String authUrl, String tokenUrl, String redirectUrl, Proxy proxy) {
        this.providerName = providerName;
        this.providerType = providerType;
        this.clientId = clientId == null ? "" : clientId;
        this.clientSecret = clientSecret == null ? "" : clientSecret;
        this.authUrl = authUrl;
        this.tokenUrl = tokenUrl;
        this.redirectUrl = redirectUrl;
        if (proxy != null) {
            this.httpClient = this.httpClient.newBuilder().proxy(proxy).build();
        }
    }

    public void enableLoggingInterceptor() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.httpClient = this.httpClient.newBuilder().addInterceptor((Interceptor)logging).build();
    }

    public String getAuthenticationUrl(List<Object> scopes, String state) {
        return this.getAuthenticationUrl(this.redirectUrl, scopes, state);
    }

    public String getAuthenticationUrl(String redirectUrl, List<Object> scopes, String state) {
        if (state == null) {
            state = this.providerName + "|" + UUID.randomUUID();
        }
        return String.format("%s?response_type=%s&client_id=%s&redirect_uri=%s&scope=%s&state=%s", this.authUrl, URLEncoder.encode(this.responseType, "UTF-8"), URLEncoder.encode(this.clientId, "UTF-8"), URLEncoder.encode(redirectUrl, "UTF-8"), String.join((CharSequence)this.scopeSeperator, scopes.stream().map(s -> s.toString()).collect(Collectors.toList())), URLEncoder.encode(state, "UTF-8"));
    }

    public OAuth2Credential getCredentialByCode(String code) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", this.clientId);
        parameters.put("client_secret", this.clientSecret);
        parameters.put("grant_type", "authorization_code");
        parameters.put("code", code);
        parameters.put("redirect_uri", this.redirectUrl);
        try {
            Request request = this.getTokenRequest(parameters, Collections.emptyMap());
            Response response = this.httpClient.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)OBJECTMAPPER.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                return new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
            }
            throw new ContextedRuntimeException("getCredentialByCode request failed!").addContextValue("requestUrl", (Object)request.url()).addContextValue("requestHeaders", (Object)request.headers()).addContextValue("requestBody", (Object)request.body()).addContextValue("responseCode", (Object)response.code()).addContextValue("responseBody", (Object)responseBody);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public OAuth2Credential getCredentialByUsernameAndPassword(String username, String password) {
        return this.getScopedCredentialByUsernameAndPassword(username, password, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuth2Credential getScopedCredentialByUsernameAndPassword(String username, String password, String scope) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "password");
        parameters.put("username", username);
        parameters.put("password", password);
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            parameters.put("scope", scope);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes()));
        try {
            Request request = this.getTokenRequest(parameters, headers);
            try (Response response = this.httpClient.newCall(request).execute();){
                String responseBody = response.body().string();
                if (!response.isSuccessful()) throw new ContextedRuntimeException("get credential request failed!").addContextValue("requestUrl", (Object)request.url()).addContextValue("requestHeaders", (Object)request.headers()).addContextValue("requestBody", (Object)request.body()).addContextValue("responseCode", (Object)response.code()).addContextValue("responseBody", (Object)responseBody);
                Map resultMap = (Map)OBJECTMAPPER.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                OAuth2Credential oAuth2Credential = new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
                return oAuth2Credential;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<OAuth2Credential> refreshCredential(OAuth2Credential oldCredential) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", this.clientId);
        parameters.put("client_secret", this.clientSecret);
        parameters.put("grant_type", "refresh_token");
        parameters.put("refresh_token", oldCredential.getRefreshToken());
        try {
            if (oldCredential.getRefreshToken() == null) {
                throw new UnsupportedOperationException("Attempting to refresh a credential that has no refresh token.");
            }
            Request request = this.getTokenRequest(parameters, Collections.emptyMap());
            try (Response response = this.httpClient.newCall(request).execute();){
                String responseBody = response.body().string();
                if (!response.isSuccessful()) throw new RuntimeException("refreshCredential request failed! " + response.code() + ": " + responseBody);
                Map resultMap = (Map)OBJECTMAPPER.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                OAuth2Credential credential = new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
                Optional<OAuth2Credential> optional = Optional.of(credential);
                return optional;
            }
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public OAuth2Credential getAppAccessToken() {
        return this.getAppAccessToken(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuth2Credential getAppAccessToken(String scope) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_id", this.clientId);
        parameters.put("client_secret", this.clientSecret);
        parameters.put("grant_type", "client_credentials");
        if (StringUtils.isNotBlank((CharSequence)scope)) {
            parameters.put("scope", scope);
        }
        try {
            Request request = this.getTokenRequest(parameters, Collections.emptyMap());
            try (Response response = this.httpClient.newCall(request).execute();){
                String responseBody = response.body().string();
                if (!response.isSuccessful()) throw new RuntimeException("getCredentialByClientCredentials request failed! " + response.code() + ": " + responseBody);
                Map resultMap = (Map)OBJECTMAPPER.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                OAuth2Credential oAuth2Credential = new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
                return oAuth2Credential;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract Optional<OAuth2Credential> getAdditionalCredentialInformation(OAuth2Credential var1);

    private Request getTokenRequest(Map<String, String> parameters, Map<String, String> headers) {
        Request request;
        switch (this.tokenEndpointPostType.toUpperCase()) {
            case "QUERY": {
                HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                parameters.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
                request = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create((byte[])new byte[0], null)).headers(Headers.of(headers)).build();
                break;
            }
            case "BODY": {
                FormBody.Builder requestBody = new FormBody.Builder();
                parameters.forEach((arg_0, arg_1) -> ((FormBody.Builder)requestBody).add(arg_0, arg_1));
                request = new Request.Builder().url(this.tokenUrl).post((RequestBody)requestBody.build()).headers(Headers.of(headers)).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
        }
        return request;
    }

    @Override
    public boolean isValid(Credential credential) {
        OAuth2Credential oauthCred;
        if (credential instanceof OAuth2Credential && (oauthCred = (OAuth2Credential)credential).getReceivedAt() != null && oauthCred.getExpiresIn() != null) {
            return oauthCred.getReceivedAt().plusSeconds(oauthCred.getExpiresIn().intValue()).compareTo(Instant.now()) > 0;
        }
        return false;
    }

    @Override
    public boolean renew(Credential credential) {
        OAuth2Credential oauthCred;
        Optional<OAuth2Credential> updatedCredential;
        if (credential instanceof OAuth2Credential && (updatedCredential = this.refreshCredential(oauthCred = (OAuth2Credential)credential)).isPresent()) {
            oauthCred.updateCredential(updatedCredential.get());
            return true;
        }
        return false;
    }
}

