/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.domain;

import com.github.philippheuer.credentialmanager.domain.Credential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OAuth2Credential
extends Credential {
    private String accessToken;
    private String refreshToken;
    private String userName;
    private Integer expiresIn;
    private List<String> scopes;
    private Map<String, Object> context;

    public OAuth2Credential(String identityProvider, String accessToken) {
        this(identityProvider, accessToken, null, null, null, null, null);
    }

    public OAuth2Credential(String identityProvider, String accessToken, @NotNull Map<String, Object> context) {
        this(identityProvider, accessToken, null, null, null, null, null);
        this.context = context;
    }

    public OAuth2Credential(String identityProvider, String accessToken, String refreshToken, String userId, String userName, Integer expiresIn, List<String> scopes) {
        super(identityProvider, userId);
        this.accessToken = accessToken.startsWith("oauth:") ? accessToken.replace("oauth:", "") : accessToken;
        this.refreshToken = refreshToken;
        this.userName = userName;
        this.expiresIn = expiresIn;
        this.scopes = scopes != null ? scopes : new ArrayList(0);
        this.context = new HashMap<String, Object>();
    }

    public OAuth2Credential(String identityProvider, String accessToken, String refreshToken, String userId, String userName, Integer expiresIn, List<String> scopes, Map<String, Object> context) {
        super(identityProvider, userId);
        this.accessToken = accessToken.startsWith("oauth:") ? accessToken.replace("oauth:", "") : accessToken;
        this.refreshToken = refreshToken;
        this.userName = userName;
        this.expiresIn = expiresIn;
        this.scopes = scopes != null ? scopes : new ArrayList(0);
        this.context = context != null ? context : new HashMap(0);
    }

    public void updateCredential(OAuth2Credential newCredential) {
        if (newCredential.accessToken != null) {
            this.accessToken = newCredential.accessToken;
        }
        if (newCredential.refreshToken != null) {
            this.refreshToken = newCredential.refreshToken;
        }
        if (newCredential.expiresIn != null) {
            this.expiresIn = newCredential.expiresIn;
        }
        if (newCredential.userId != null) {
            this.userId = newCredential.userId;
        }
        if (newCredential.userName != null) {
            this.userName = newCredential.userName;
        }
        if (newCredential.scopes != null && !newCredential.scopes.isEmpty()) {
            this.scopes.clear();
            this.scopes.addAll(newCredential.scopes);
        }
        if (newCredential.context != null && !newCredential.context.isEmpty()) {
            this.context.clear();
            this.context.putAll(newCredential.context);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getUserName() {
        return this.userName;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public String toString() {
        return "OAuth2Credential(super=" + super.toString() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", userName=" + this.getUserName() + ", expiresIn=" + this.getExpiresIn() + ", scopes=" + this.getScopes() + ", context=" + this.getContext() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2Credential)) {
            return false;
        }
        OAuth2Credential other = (OAuth2Credential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiresIn = this.getExpiresIn();
        Integer other$expiresIn = other.getExpiresIn();
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        Map<String, Object> this$context = this.getContext();
        Map<String, Object> other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2Credential;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        Map<String, Object> $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }
}

