/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.util;

public class ProxyHelper {
    public static String getSystemHttpProxyHost() {
        return ProxyHelper.getProxyHostByKey("http_proxy") != null ? ProxyHelper.getProxyHostByKey("http_proxy") : ProxyHelper.getProxyHostByKey("HTTP_PROXY");
    }

    public static Integer getSystemHttpProxyPort() {
        return ProxyHelper.getProxyPortByKey("http_proxy") != null ? ProxyHelper.getProxyPortByKey("http_proxy") : ProxyHelper.getProxyPortByKey("HTTP_PROXY");
    }

    public static String getSystemHttpsProxyHost() {
        return ProxyHelper.getProxyHostByKey("https_proxy") != null ? ProxyHelper.getProxyHostByKey("https_proxy") : ProxyHelper.getProxyHostByKey("HTTPS_PROXY");
    }

    public static Integer getSystemHttpsProxyPort() {
        return ProxyHelper.getProxyPortByKey("https_proxy") != null ? ProxyHelper.getProxyPortByKey("https_proxy") : ProxyHelper.getProxyPortByKey("HTTPS_PROXY");
    }

    private static String getProxyHostByKey(String propertyName) {
        String httpProxy = System.getenv(propertyName);
        if (httpProxy == null) {
            return null;
        }
        String[] proxyInfo = httpProxy.replace("http://", "").replace("https://", "").split(":");
        if (proxyInfo.length == 2) {
            return proxyInfo[0];
        }
        return null;
    }

    private static Integer getProxyPortByKey(String propertyName) {
        String httpProxy = System.getenv(propertyName);
        if (httpProxy == null) {
            return null;
        }
        String[] proxyInfo = httpProxy.replace("http://", "").replace("https://", "").split(":");
        if (proxyInfo.length == 2) {
            return Integer.parseInt(proxyInfo[1]);
        }
        return null;
    }
}

