/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.identityprovider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TwitchIdentityProvider
extends OAuth2IdentityProvider {
    public TwitchIdentityProvider(String clientId, String clientSecret, String redirectUrl) {
        super("twitch", "oauth2", clientId, clientSecret, "https://id.twitch.tv/oauth2/authorize", "https://id.twitch.tv/oauth2/token", redirectUrl);
    }

    @Override
    public Optional<OAuth2Credential> getAdditionalCredentialInformation(OAuth2Credential credential) {
        try {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url("https://id.twitch.tv/oauth2/validate").header("Authorization", "OAuth " + credential.getAccessToken()).build();
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap tokenInfo = (HashMap)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                String userId = (String)tokenInfo.get("user_id");
                String userName = (String)tokenInfo.get("login");
                List scopes = (List)tokenInfo.get("scopes");
                OAuth2Credential newCredential = new OAuth2Credential(credential.getIdentityProvider(), credential.getAccessToken(), credential.getRefreshToken(), userId, userName, null, scopes);
                return Optional.ofNullable(newCredential);
            }
            throw new RuntimeException("Request Failed! Code: " + response.code() + " - " + responseBody);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

