/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager.identityprovider;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.philippheuer.credentialmanager.domain.IdentityProvider;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.util.ProxyHelper;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public abstract class OAuth2IdentityProvider
extends IdentityProvider {
    protected String clientId;
    protected String clientSecret;
    protected String authUrl;
    protected String tokenUrl;
    protected String redirectUrl;
    protected String scopeSeperator = " ";
    protected String responseType = "code";
    protected String tokenEndpointPostType = "QUERY";

    public OAuth2IdentityProvider(String providerName, String providerType, String clientId, String clientSecret, String authUrl, String tokenUrl, String redirectUrl) {
        this.providerName = providerName;
        this.providerType = providerType;
        this.clientId = clientId == null ? "" : clientId;
        this.clientSecret = clientSecret == null ? "" : clientSecret;
        this.authUrl = authUrl;
        this.tokenUrl = tokenUrl;
        this.redirectUrl = redirectUrl;
    }

    public String getAuthenticationUrl(List<Object> scopes, String state) {
        return this.getAuthenticationUrl(this.redirectUrl, scopes, state);
    }

    public String getAuthenticationUrl(String redirectUrl, List<Object> scopes, String state) {
        if (state == null) {
            state = this.providerName + "|" + UUID.randomUUID();
        }
        return String.format("%s?response_type=%s&client_id=%s&redirect_uri=%s&scope=%s&state=%s", this.authUrl, URLEncoder.encode(this.responseType, "UTF-8"), URLEncoder.encode(this.clientId, "UTF-8"), URLEncoder.encode(redirectUrl, "UTF-8"), String.join((CharSequence)this.scopeSeperator, scopes.stream().map(s -> s.toString()).collect(Collectors.toList())), URLEncoder.encode(state, "UTF-8"));
    }

    public OAuth2Credential getCredentialByCode(String code) {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper objectMapper = new ObjectMapper();
        if (ProxyHelper.getSystemHttpProxyPort() != null && ProxyHelper.getSystemHttpProxyPort() > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyHelper.getSystemHttpProxyHost(), (int)ProxyHelper.getSystemHttpProxyPort()));
            client = client.newBuilder().proxy(proxy).build();
        }
        try {
            Request request;
            if (this.tokenEndpointPostType.equalsIgnoreCase("QUERY")) {
                HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                urlBuilder.addQueryParameter("client_id", this.clientId);
                urlBuilder.addQueryParameter("client_secret", this.clientSecret);
                urlBuilder.addQueryParameter("code", code);
                urlBuilder.addQueryParameter("grant_type", "authorization_code");
                urlBuilder.addQueryParameter("redirect_uri", this.redirectUrl);
                request = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create(null, (byte[])new byte[0])).build();
            } else if (this.tokenEndpointPostType.equalsIgnoreCase("BODY")) {
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("client_id", this.clientId).addFormDataPart("client_secret", this.clientSecret).addFormDataPart("code", code).addFormDataPart("grant_type", "authorization_code").addFormDataPart("redirect_uri", this.redirectUrl).build();
                request = new Request.Builder().url(this.tokenUrl).post((RequestBody)requestBody).build();
            } else {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                return new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
            }
            throw new ContextedRuntimeException("getCredentialByCode request failed!").addContextValue("requestUrl", (Object)request.url()).addContextValue("requestHeaders", (Object)request.headers()).addContextValue("requestBody", (Object)request.body()).addContextValue("responseCode", (Object)response.code()).addContextValue("responseBody", (Object)responseBody);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public OAuth2Credential getCredentialByUsernameAndPassword(String username, String password) {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper objectMapper = new ObjectMapper();
        if (ProxyHelper.getSystemHttpProxyPort() != null && ProxyHelper.getSystemHttpProxyPort() > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyHelper.getSystemHttpProxyHost(), (int)ProxyHelper.getSystemHttpProxyPort()));
            client = client.newBuilder().proxy(proxy).build();
        }
        try {
            Request request;
            HttpUrl.Builder urlBuilder;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes()));
            if (this.tokenEndpointPostType.equalsIgnoreCase("QUERY")) {
                urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                urlBuilder.addQueryParameter("grant_type", "password");
                urlBuilder.addQueryParameter("username", username);
                urlBuilder.addQueryParameter("password", password);
                request = new Request.Builder().url(urlBuilder.build().toString()).headers(Headers.of(headers)).post(RequestBody.create(null, (byte[])new byte[0])).build();
            } else if (this.tokenEndpointPostType.equalsIgnoreCase("BODY")) {
                urlBuilder = HttpUrl.parse((String)"http://localhost").newBuilder();
                urlBuilder.addQueryParameter("grant_type", "password");
                urlBuilder.addQueryParameter("username", username);
                urlBuilder.addQueryParameter("password", password);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (byte[])urlBuilder.toString().replace("http://localhost/?", "").getBytes());
                request = new Request.Builder().url(this.tokenUrl).headers(Headers.of(headers)).post(requestBody).build();
            } else {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                return new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
            }
            throw new ContextedRuntimeException("getCredentialByUsernameAndPassword request failed!").addContextValue("requestUrl", (Object)request.url()).addContextValue("requestHeaders", (Object)request.headers()).addContextValue("requestBody", (Object)request.body()).addContextValue("responseCode", (Object)response.code()).addContextValue("responseBody", (Object)responseBody);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public OAuth2Credential getScopedCredentialByUsernameAndPassword(String username, String password, String scope) {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper objectMapper = new ObjectMapper();
        if (ProxyHelper.getSystemHttpProxyPort() != null && ProxyHelper.getSystemHttpProxyPort() > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxyHelper.getSystemHttpProxyHost(), (int)ProxyHelper.getSystemHttpProxyPort()));
            client = client.newBuilder().proxy(proxy).build();
        }
        try {
            Request request;
            HttpUrl.Builder urlBuilder;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes()));
            if (this.tokenEndpointPostType.equalsIgnoreCase("QUERY")) {
                urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                urlBuilder.addQueryParameter("grant_type", "password");
                urlBuilder.addQueryParameter("username", username);
                urlBuilder.addQueryParameter("password", password);
                urlBuilder.addQueryParameter("scope", scope);
                request = new Request.Builder().url(urlBuilder.build().toString()).headers(Headers.of(headers)).post(RequestBody.create(null, (byte[])new byte[0])).build();
            } else if (this.tokenEndpointPostType.equalsIgnoreCase("BODY")) {
                urlBuilder = HttpUrl.parse((String)"http://localhost").newBuilder();
                urlBuilder.addQueryParameter("grant_type", "password");
                urlBuilder.addQueryParameter("username", username);
                urlBuilder.addQueryParameter("password", password);
                urlBuilder.addQueryParameter("scope", scope);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (byte[])urlBuilder.toString().replace("http://localhost/?", "").getBytes());
                request = new Request.Builder().url(this.tokenUrl).headers(Headers.of(headers)).post(requestBody).build();
            } else {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                return new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
            }
            throw new ContextedRuntimeException("getScopedCredentialByUsernameAndPassword request failed!").addContextValue("requestUrl", (Object)request.url()).addContextValue("requestHeaders", (Object)request.headers()).addContextValue("requestBody", (Object)request.body()).addContextValue("responseCode", (Object)response.code()).addContextValue("responseBody", (Object)responseBody);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Optional<OAuth2Credential> refreshCredential(OAuth2Credential oldCredential) {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Request request;
            if (oldCredential.getRefreshToken() == null) {
                throw new UnsupportedOperationException("Attempting to refresh a credential that has no refresh token.");
            }
            if (this.tokenEndpointPostType.equalsIgnoreCase("QUERY")) {
                HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                urlBuilder.addQueryParameter("client_id", this.clientId);
                urlBuilder.addQueryParameter("client_secret", this.clientSecret);
                urlBuilder.addQueryParameter("refresh_token", oldCredential.getRefreshToken());
                urlBuilder.addQueryParameter("grant_type", "refresh_token");
                request = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create(null, (byte[])new byte[0])).build();
            } else if (this.tokenEndpointPostType.equalsIgnoreCase("BODY")) {
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("client_id", this.clientId).addFormDataPart("client_secret", this.clientSecret).addFormDataPart("refresh_token", oldCredential.getRefreshToken()).addFormDataPart("grant_type", "refresh_token").build();
                request = new Request.Builder().url(this.tokenUrl).post((RequestBody)requestBody).build();
            } else {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                OAuth2Credential credential = new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
                return Optional.of(credential);
            }
            throw new RuntimeException("refreshCredential request failed! " + response.code() + ": " + responseBody);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    public OAuth2Credential getAppAccessToken() {
        OkHttpClient client = new OkHttpClient();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Request request;
            if (this.tokenEndpointPostType.equalsIgnoreCase("QUERY")) {
                HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.tokenUrl).newBuilder();
                urlBuilder.addQueryParameter("client_id", this.clientId);
                urlBuilder.addQueryParameter("client_secret", this.clientSecret);
                urlBuilder.addQueryParameter("grant_type", "client_credentials");
                request = new Request.Builder().url(urlBuilder.build().toString()).post(RequestBody.create(null, (byte[])new byte[0])).build();
            } else if (this.tokenEndpointPostType.equalsIgnoreCase("BODY")) {
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("client_id", this.clientId).addFormDataPart("client_secret", this.clientSecret).addFormDataPart("grant_type", "client_credentials").build();
                request = new Request.Builder().url(this.tokenUrl).post((RequestBody)requestBody).build();
            } else {
                throw new UnsupportedOperationException("Unknown tokenEndpointPostType: " + this.tokenEndpointPostType);
            }
            Response response = client.newCall(request).execute();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                Map resultMap = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
                OAuth2Credential credential = new OAuth2Credential(this.providerName, (String)resultMap.get("access_token"), (String)resultMap.get("refresh_token"), null, null, (Integer)resultMap.get("expires_in"), null);
                return credential;
            }
            throw new RuntimeException("getCredentialByClientCredentials request failed! " + response.code() + ": " + responseBody);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract Optional<OAuth2Credential> getAdditionalCredentialInformation(OAuth2Credential var1);
}

