/*
 * Decompiled with CFR 0.152.
 */
package com.github.philippheuer.credentialmanager;

import com.github.philippheuer.credentialmanager.api.IStorageBackend;
import com.github.philippheuer.credentialmanager.domain.AuthenticationController;
import com.github.philippheuer.credentialmanager.domain.Credential;
import com.github.philippheuer.credentialmanager.domain.IdentityProvider;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.credentialmanager.identityprovider.OAuth2IdentityProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialManager {
    private static final Logger log = LoggerFactory.getLogger(CredentialManager.class);
    private final IStorageBackend storageBackend;
    private final AuthenticationController authenticationController;
    private final List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
    private List<Credential> credentials;

    public CredentialManager(IStorageBackend storageBackend, AuthenticationController authenticationController) {
        this.storageBackend = storageBackend;
        this.authenticationController = authenticationController;
        authenticationController.setCredentialManager(this);
        this.load();
    }

    public void registerIdentityProvider(IdentityProvider identityProvider) {
        log.debug("Trying to register IdentityProvider {} [Type: {}]", (Object)identityProvider.getProviderName(), (Object)identityProvider.getProviderType());
        Boolean exists = this.identityProviders.stream().filter(idp -> idp.getProviderName().equalsIgnoreCase(identityProvider.getProviderName())).count() > 0L;
        if (exists.booleanValue()) {
            throw new RuntimeException("Identity Provider " + identityProvider.getProviderName() + " was already registered!");
        }
        identityProvider.setCredentialManager(this);
        this.identityProviders.add(identityProvider);
        log.debug("Registered IdentityProvider {} [Type: {}]", (Object)identityProvider.getProviderName(), (Object)identityProvider.getProviderType());
        log.debug("A total of {} IdentityProviders have been registered!", (Object)this.identityProviders.size());
    }

    public Optional<IdentityProvider> getIdentityProviderByName(String identityProviderName) {
        return this.identityProviders.stream().filter(i -> i.getProviderName().equalsIgnoreCase(identityProviderName)).findFirst();
    }

    public Optional<OAuth2IdentityProvider> getOAuth2IdentityProviderByName(String identityProviderName) {
        return this.identityProviders.stream().filter(i -> i.getProviderName().equalsIgnoreCase(identityProviderName)).map(i -> (OAuth2IdentityProvider)i).findFirst();
    }

    public void addCredential(String providerName, Credential credential) {
        if (credential instanceof OAuth2Credential) {
            OAuth2Credential oAuth2Credential = (OAuth2Credential)credential;
            List oauth2IdentityProviders = this.identityProviders.stream().filter(idp -> idp.getProviderType().equalsIgnoreCase("oauth2") && idp.getProviderName().equalsIgnoreCase(providerName) && idp instanceof OAuth2IdentityProvider).collect(Collectors.toList());
            if (oauth2IdentityProviders.size() == 1) {
                OAuth2IdentityProvider oAuth2IdentityProvider = (OAuth2IdentityProvider)oauth2IdentityProviders.get(0);
                Optional<OAuth2Credential> enrichedCredential = oAuth2IdentityProvider.getAdditionalCredentialInformation(oAuth2Credential);
                if (enrichedCredential.isPresent()) {
                    credential = enrichedCredential.get();
                }
            } else {
                throw new RuntimeException("Can't find a unique identity provider for the specified credential!");
            }
        }
        this.credentials.add(credential);
    }

    public Optional<OAuth2Credential> getOAuth2CredentialByUserId(String userId) {
        for (Credential entry : this.credentials) {
            OAuth2Credential credential;
            if (!(entry instanceof OAuth2Credential) || !(credential = (OAuth2Credential)entry).getUserId().equalsIgnoreCase(userId)) continue;
            return Optional.ofNullable(credential);
        }
        return Optional.empty();
    }

    public void load() {
        this.credentials = this.storageBackend.loadCredentials();
    }

    public void save() {
        this.storageBackend.saveCredentials(this.credentials);
    }

    public IStorageBackend getStorageBackend() {
        return this.storageBackend;
    }

    public AuthenticationController getAuthenticationController() {
        return this.authenticationController;
    }

    public List<IdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    public List<Credential> getCredentials() {
        return this.credentials;
    }
}

