/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class ProxyAuthenticator
extends Authenticator {
    private static final Map<String, URI> credentials;

    public static void register(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        credentials.put("%s:%s".formatted(uri.getHost(), uri.getPort()), uri);
    }

    public static void unregister(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        credentials.remove("%s:%s".formatted(uri.getHost(), uri.getPort()));
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String host = "%s:%s".formatted(this.getRequestingHost(), this.getRequestingPort());
        URI info = credentials.get(host);
        if (info == null) {
            return super.getPasswordAuthentication();
        }
        String[] userInfo = info.getUserInfo().split(":", 2);
        return new PasswordAuthentication(userInfo[0], userInfo[1].toCharArray());
    }

    static {
        System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        credentials = new ConcurrentHashMap<String, URI>();
    }
}

