/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public final class Clock {
    public static long nowSeconds() {
        return Instant.now().getEpochSecond();
    }

    public static long nowMilliseconds() {
        return Instant.now().toEpochMilli();
    }

    public static ZonedDateTime parseSeconds(Integer input) {
        return Clock.parseSeconds(input.longValue());
    }

    public static ZonedDateTime parseSeconds(long input) {
        return input <= 0L ? ZonedDateTime.now() : ZonedDateTime.ofInstant(Instant.ofEpochSecond(input), ZoneId.systemDefault());
    }

    public static ZonedDateTime parseMilliseconds(long input) {
        return input <= 0L ? ZonedDateTime.now() : ZonedDateTime.ofInstant(Instant.ofEpochMilli(input), ZoneId.systemDefault());
    }

    private Clock() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

