/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.socket;

import io.netty.buffer.ByteBuf;
import it.auties.whatsapp.socket.SocketListener;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.ProxyAuthenticator;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class SocketSession {
    private final URI proxy;
    private final Executor executor;
    private Socket socket;
    private SocketListener listener;
    private boolean closed;

    CompletableFuture<Void> connect(SocketListener listener) {
        if (this.socket != null && this.isOpen()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this.listener = listener;
                this.closed = false;
                this.socket = new Socket(this.getProxy());
                this.socket.setKeepAlive(true);
                this.socket.connect(new InetSocketAddress("g.whatsapp.net", 443));
                this.executor.execute(this::readMessages);
                listener.onOpen(this);
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot connect to host", exception);
            }
        }, this.executor);
    }

    private Proxy getProxy() {
        if (this.proxy == null) {
            return Proxy.NO_PROXY;
        }
        String scheme = Objects.requireNonNull(this.proxy.getScheme(), "Invalid proxy, expected a scheme: %s".formatted(this.proxy));
        String host = Objects.requireNonNull(this.proxy.getHost(), "Invalid proxy, expected a host: %s".formatted(this.proxy));
        int port = this.getProxyPort(scheme).orElseThrow(() -> new NullPointerException("Invalid proxy, expected a port: %s".formatted(this.proxy)));
        return switch (scheme) {
            case "http", "https" -> new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            case "socks4", "socks5" -> new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port));
            default -> throw new IllegalStateException("Unexpected scheme: " + scheme);
        };
    }

    private OptionalInt getProxyPort(String scheme) {
        OptionalInt optionalInt;
        if (this.proxy.getPort() != -1) {
            optionalInt = OptionalInt.of(this.proxy.getPort());
        } else {
            switch (scheme) {
                case "http": {
                    optionalInt = OptionalInt.of(80);
                    break;
                }
                case "https": {
                    optionalInt = OptionalInt.of(443);
                    break;
                }
                default: {
                    optionalInt = OptionalInt.empty();
                }
            }
        }
        return optionalInt;
    }

    CompletableFuture<Void> close() {
        if (this.socket == null || !this.isOpen()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this.closed = true;
                this.socket.close();
                this.closeResources();
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot close connection to host", exception);
            }
        }, this.executor);
    }

    public boolean isOpen() {
        return this.socket != null && this.socket.isConnected();
    }

    public CompletableFuture<Void> sendBinary(byte[] bytes) {
        return CompletableFuture.runAsync(() -> {
            try {
                if (this.socket == null) {
                    return;
                }
                OutputStream stream = this.socket.getOutputStream();
                stream.write(bytes);
                stream.flush();
            }
            catch (IOException exception) {
                throw new UncheckedIOException("Cannot send message", exception);
            }
        }, this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessages() {
        try (DataInputStream input = new DataInputStream(this.socket.getInputStream());){
            while (this.isOpen()) {
                int length = this.decodeLength(input);
                if (length < 0) {
                    break;
                }
                byte[] message = new byte[length];
                if (!this.isOpen()) continue;
                input.readFully(message);
                this.listener.onMessage(message);
            }
        }
        catch (Throwable throwable) {
            this.listener.onError(throwable);
        }
        finally {
            if (!this.closed) {
                this.closeResources();
            }
        }
    }

    private int decodeLength(DataInputStream input) {
        try {
            byte[] lengthBytes = new byte[3];
            input.readFully(lengthBytes);
            return this.decodeLength(lengthBytes);
        }
        catch (IOException exception) {
            return -1;
        }
    }

    private int decodeLength(byte[] input) {
        ByteBuf buffer = BytesHelper.newBuffer(input);
        return buffer.readByte() << 16 | buffer.readUnsignedShort();
    }

    private void closeResources() {
        this.socket = null;
        Executor executor = this.executor;
        if (executor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)executor;
            service.shutdownNow();
        }
        this.listener.onClose();
    }

    SocketSession(URI proxy, Executor executor) {
        this.proxy = proxy;
        this.executor = executor;
    }

    static {
        Authenticator.setDefault(new ProxyAuthenticator());
    }
}

