/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.sender;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.whatsapp.model.signal.keypair.SignalKeyPair;
import it.auties.whatsapp.model.signal.sender.SenderKeyState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

@JsonDeserialize(builder=SenderKeyRecordBuilder.class)
public class SenderKeyRecord
implements ProtobufMessage {
    private final LinkedHashMap<Integer, List<SenderKeyState>> states;

    public SenderKeyRecord() {
        this.states = new LinkedHashMap();
    }

    public SenderKeyState findState() {
        return (SenderKeyState)this.states.values().stream().flatMap(Collection::stream).findFirst().orElseThrow(() -> new NoSuchElementException("Cannot get head state for empty record"));
    }

    public List<SenderKeyState> findStateById(int keyId) {
        return Objects.requireNonNull(this.states.get(keyId), "Cannot find state with id %s".formatted(keyId));
    }

    public void addState(int id, int iteration, byte[] seed, byte[] signatureKey) {
        this.addState(id, iteration, seed, SignalKeyPair.of(signatureKey));
    }

    public void addState(int id, int iteration, byte[] seed, SignalKeyPair signingKey) {
        SenderKeyState state = new SenderKeyState(id, iteration, seed, signingKey);
        List oldList = this.states.getOrDefault(id, new ArrayList());
        oldList.add(state);
        this.states.put(id, oldList);
    }

    public boolean isEmpty() {
        return this.states.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(this.states);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SenderKeyRecord)) return false;
        SenderKeyRecord that = (SenderKeyRecord)object;
        if (!Objects.equals(this.states, that.states)) return false;
        return true;
    }

    public static SenderKeyRecordBuilder builder() {
        return new SenderKeyRecordBuilder();
    }

    public SenderKeyRecord(LinkedHashMap<Integer, List<SenderKeyState>> states) {
        this.states = states;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        return protobufOutputStream.toByteArray();
    }

    public static SenderKeyRecord ofProtobuf(byte[] byArray) {
        int n;
        SenderKeyRecordBuilder senderKeyRecordBuilder = SenderKeyRecord.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                default: 
            }
            protobufInputStream.readBytes();
        }
        return senderKeyRecordBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SenderKeyRecordBuilder {
        private LinkedHashMap<Integer, List<SenderKeyState>> states;

        SenderKeyRecordBuilder() {
        }

        public SenderKeyRecordBuilder states(LinkedHashMap<Integer, List<SenderKeyState>> states) {
            this.states = states;
            return this;
        }

        public SenderKeyRecord build() {
            return new SenderKeyRecord(this.states);
        }

        public String toString() {
            return "SenderKeyRecord.SenderKeyRecordBuilder(states=" + this.states + ")";
        }
    }
}

