/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.signal.message;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.curve25519.Curve25519;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.signal.message.SignalProtocolMessage;
import it.auties.whatsapp.util.BytesHelper;
import it.auties.whatsapp.util.Protobuf;
import java.util.Arrays;
import lombok.NonNull;

@JsonDeserialize(builder=SenderKeyMessageBuilder.class)
public final class SenderKeyMessage
implements SignalProtocolMessage {
    private int version;
    @ProtobufProperty(index=1, type=ProtobufType.UINT32)
    private Integer id;
    @ProtobufProperty(index=2, type=ProtobufType.UINT32)
    private Integer iteration;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte @NonNull [] cipherText;
    private byte[] signingKey;
    private byte[] signature;
    private byte[] serialized;

    public SenderKeyMessage(int id, int iteration, byte @NonNull [] cipherText, byte @NonNull [] signingKey) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        if (signingKey == null) {
            throw new NullPointerException("signingKey is marked non-null but is null");
        }
        this.version = 3;
        this.id = id;
        this.iteration = iteration;
        this.cipherText = cipherText;
        this.signingKey = signingKey;
        byte[] serialized = BytesHelper.concat(this.serializedVersion(), Protobuf.writeMessage(this));
        this.signature = Curve25519.sign((byte[])signingKey, (byte[])serialized, (boolean)true);
        this.serialized = BytesHelper.concat(serialized, this.signature);
    }

    public static SenderKeyMessage ofSerialized(byte[] serialized) {
        byte[] data = Arrays.copyOfRange(serialized, 1, serialized.length - 64);
        byte[] signature = Arrays.copyOfRange(serialized, serialized.length - 64, serialized.length);
        return Protobuf.readMessage(data, SenderKeyMessage.class).version(BytesHelper.bytesToVersion(serialized[0])).signature(signature).serialized(serialized);
    }

    public static SenderKeyMessageBuilder builder() {
        return new SenderKeyMessageBuilder();
    }

    public SenderKeyMessage(int version, Integer id, Integer iteration, byte @NonNull [] cipherText, byte[] signingKey, byte[] signature, byte[] serialized) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        this.version = version;
        this.id = id;
        this.iteration = iteration;
        this.cipherText = cipherText;
        this.signingKey = signingKey;
        this.signature = signature;
        this.serialized = serialized;
    }

    @Override
    public int version() {
        return this.version;
    }

    public Integer id() {
        return this.id;
    }

    public Integer iteration() {
        return this.iteration;
    }

    public byte @NonNull [] cipherText() {
        return this.cipherText;
    }

    public byte[] signingKey() {
        return this.signingKey;
    }

    public byte[] signature() {
        return this.signature;
    }

    @Override
    public byte[] serialized() {
        return this.serialized;
    }

    public SenderKeyMessage version(int version) {
        this.version = version;
        return this;
    }

    public SenderKeyMessage id(Integer id) {
        this.id = id;
        return this;
    }

    public SenderKeyMessage iteration(Integer iteration) {
        this.iteration = iteration;
        return this;
    }

    public SenderKeyMessage cipherText(byte @NonNull [] cipherText) {
        if (cipherText == null) {
            throw new NullPointerException("cipherText is marked non-null but is null");
        }
        this.cipherText = cipherText;
        return this;
    }

    public SenderKeyMessage signingKey(byte[] signingKey) {
        this.signingKey = signingKey;
        return this;
    }

    public SenderKeyMessage signature(byte[] signature) {
        this.signature = signature;
        return this;
    }

    public SenderKeyMessage serialized(byte[] serialized) {
        this.serialized = serialized;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SenderKeyMessage)) {
            return false;
        }
        SenderKeyMessage other = (SenderKeyMessage)o;
        if (this.version() != other.version()) {
            return false;
        }
        Integer this$id = this.id();
        Integer other$id = other.id();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$iteration = this.iteration();
        Integer other$iteration = other.iteration();
        if (this$iteration == null ? other$iteration != null : !((Object)this$iteration).equals(other$iteration)) {
            return false;
        }
        if (!Arrays.equals(this.cipherText(), other.cipherText())) {
            return false;
        }
        if (!Arrays.equals(this.signingKey(), other.signingKey())) {
            return false;
        }
        if (!Arrays.equals(this.signature(), other.signature())) {
            return false;
        }
        return Arrays.equals(this.serialized(), other.serialized());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.version();
        Integer $id = this.id();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $iteration = this.iteration();
        result = result * 59 + ($iteration == null ? 43 : ((Object)$iteration).hashCode());
        result = result * 59 + Arrays.hashCode(this.cipherText());
        result = result * 59 + Arrays.hashCode(this.signingKey());
        result = result * 59 + Arrays.hashCode(this.signature());
        result = result * 59 + Arrays.hashCode(this.serialized());
        return result;
    }

    public String toString() {
        return "SenderKeyMessage(version=" + this.version() + ", id=" + this.id() + ", iteration=" + this.iteration() + ", cipherText=" + this.cipherText() + ", signingKey=" + Arrays.toString(this.signingKey()) + ", signature=" + Arrays.toString(this.signature()) + ", serialized=" + Arrays.toString(this.serialized()) + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.id != null) {
            protobufOutputStream.writeUInt32(1, this.id);
        }
        if (this.cipherText != null) {
            protobufOutputStream.writeBytes(3, this.cipherText);
        }
        if (this.iteration != null) {
            protobufOutputStream.writeUInt32(2, this.iteration);
        }
        return protobufOutputStream.toByteArray();
    }

    public static SenderKeyMessage ofProtobuf(byte[] byArray) {
        int n;
        SenderKeyMessageBuilder senderKeyMessageBuilder = SenderKeyMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block5: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    senderKeyMessageBuilder.id(protobufInputStream.readInt32());
                    continue block5;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    senderKeyMessageBuilder.cipherText(protobufInputStream.readBytes());
                    continue block5;
                }
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    senderKeyMessageBuilder.iteration(protobufInputStream.readInt32());
                    continue block5;
                }
            }
            protobufInputStream.readBytes();
        }
        return senderKeyMessageBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class SenderKeyMessageBuilder {
        private int version;
        private Integer id;
        private Integer iteration;
        private byte @NonNull [] cipherText;
        private byte[] signingKey;
        private byte[] signature;
        private byte[] serialized;

        SenderKeyMessageBuilder() {
        }

        public SenderKeyMessageBuilder version(int version) {
            this.version = version;
            return this;
        }

        public SenderKeyMessageBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public SenderKeyMessageBuilder iteration(Integer iteration) {
            this.iteration = iteration;
            return this;
        }

        public SenderKeyMessageBuilder cipherText(byte @NonNull [] cipherText) {
            if (cipherText == null) {
                throw new NullPointerException("cipherText is marked non-null but is null");
            }
            this.cipherText = cipherText;
            return this;
        }

        public SenderKeyMessageBuilder signingKey(byte[] signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public SenderKeyMessageBuilder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public SenderKeyMessageBuilder serialized(byte[] serialized) {
            this.serialized = serialized;
            return this;
        }

        public SenderKeyMessage build() {
            return new SenderKeyMessage(this.version, this.id, this.iteration, this.cipherText, this.signingKey, this.signature, this.serialized);
        }

        public String toString() {
            return "SenderKeyMessage.SenderKeyMessageBuilder(version=" + this.version + ", id=" + this.id + ", iteration=" + this.iteration + ", cipherText=" + this.cipherText + ", signingKey=" + Arrays.toString(this.signingKey) + ", signature=" + Arrays.toString(this.signature) + ", serialized=" + Arrays.toString(this.serialized) + ")";
        }
    }
}

