/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.request;

import com.fasterxml.jackson.annotation.JsonValue;
import it.auties.whatsapp.model.contact.ContactJid;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import lombok.NonNull;

public record Attributes(@JsonValue @NonNull ConcurrentHashMap<String, Object> toMap) {
    public Attributes(@NonNull ConcurrentHashMap<String, Object> toMap) {
        if (toMap == null) {
            throw new NullPointerException("toMap is marked non-null but is null");
        }
    }

    @SafeVarargs
    public static Attributes of(Map.Entry<String, Object> ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return Attributes.ofNullable(Map.ofEntries(entries));
    }

    public static Attributes ofNullable(Map<String, Object> map) {
        ConcurrentHashMap modifiableMap = Optional.ofNullable(map).map(ConcurrentHashMap::new).orElseGet(ConcurrentHashMap::new);
        return new Attributes(modifiableMap);
    }

    public static Attributes of(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return Attributes.ofNullable(map);
    }

    public boolean hasKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.toMap.containsKey(key);
    }

    public boolean hasKey(@NonNull String key, String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Objects.equals(this.toMap.get(key), value);
    }

    @SafeVarargs
    public final <T> Attributes put(@NonNull String key, T value, Function<T, Boolean> ... conditions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        BooleanSupplier[] translated = (BooleanSupplier[])Arrays.stream(conditions).map(condition -> () -> (Boolean)condition.apply(value)).toArray(BooleanSupplier[]::new);
        return this.put(key, value, translated);
    }

    public Attributes put(@NonNull String key, Object value, BooleanSupplier ... conditions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (conditions == null) {
            throw new NullPointerException("conditions is marked non-null but is null");
        }
        return this.put(key, value, Arrays.stream(conditions).allMatch(BooleanSupplier::getAsBoolean));
    }

    public Attributes put(@NonNull String key, Object value, boolean condition) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (condition) {
            this.toMap.put(key, value);
        }
        return this;
    }

    public Attributes put(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.toMap.put(key, value);
        return this;
    }

    public <T> T get(@NonNull String key, @NonNull T defaultValue, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return this.get(key, clazz).orElse(defaultValue);
    }

    public <T> Optional<T> get(@NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return Optional.ofNullable(this.toMap.get(key)).map(clazz::cast);
    }

    public int getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getOptionalInt(key).orElse(0);
    }

    public Optional<Integer> getOptionalInt(String key) {
        return this.get(key, Object.class).map(this::parseInt);
    }

    private int parseInt(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Integer.parseInt(string);
        }
        throw new IllegalStateException("Unexpected value: " + value);
    }

    public long getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getOptionalLong(key).orElse(0L);
    }

    public Optional<Long> getOptionalLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.get(key, Object.class).map(this::parseLong);
    }

    private long parseLong(Object value) {
        Object object = Objects.requireNonNull(value);
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.longValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            return Long.parseLong(string);
        }
        throw new IllegalStateException("Unexpected value: " + value);
    }

    public String getString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key, "unknown");
    }

    public String getString(@NonNull String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.get(key, Object.class).map(Object::toString).orElse(defaultValue);
    }

    public String getNullableString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.getString(key, null);
    }

    public String getRequiredString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Objects.requireNonNull(this.getString(key, null), "Missing required attribute %s".formatted(key));
    }

    public Optional<String> getOptionalString(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Optional.ofNullable(this.getString(key, null));
    }

    public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.get(key, Object.class).map(this::parseBool).orElse(false);
    }

    private boolean parseBool(Object value) {
        Object object = Objects.requireNonNull(value);
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Boolean.parseBoolean(string);
        }
        throw new IllegalStateException("Unexpected value: " + value);
    }

    public Optional<ContactJid> getJid(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.get(key, Object.class).map(this::parseJid);
    }

    private ContactJid parseJid(Object value) {
        if (value instanceof ContactJid) {
            ContactJid jid = (ContactJid)value;
            return jid;
        }
        if (value instanceof String) {
            String encodedJid = (String)value;
            return ContactJid.of(encodedJid);
        }
        throw new IllegalStateException("Unexpected value: " + value);
    }

    public Attributes copy() {
        return new Attributes(this.toMap);
    }

    public boolean isEmpty() {
        return this.toMap.isEmpty();
    }
}

