/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.message.standard;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.info.ContextInfo;
import it.auties.whatsapp.model.message.model.ContextualMessage;
import it.auties.whatsapp.model.message.model.MediaMessage;
import it.auties.whatsapp.model.message.model.MediaMessageType;
import it.auties.whatsapp.util.Clock;
import it.auties.whatsapp.util.Medias;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

@JsonDeserialize(builder=StickerMessageBuilderImpl.class)
public final class StickerMessage
extends MediaMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String mediaUrl;
    @ProtobufProperty(index=2, type=ProtobufType.BYTES)
    private byte[] mediaSha256;
    @ProtobufProperty(index=3, type=ProtobufType.BYTES)
    private byte[] mediaEncryptedSha256;
    @ProtobufProperty(index=4, type=ProtobufType.BYTES)
    private byte[] mediaKey;
    @ProtobufProperty(index=5, type=ProtobufType.STRING)
    private String mimetype;
    @ProtobufProperty(index=6, type=ProtobufType.UINT32)
    private Integer height;
    @ProtobufProperty(index=7, type=ProtobufType.UINT32)
    private Integer width;
    @ProtobufProperty(index=8, type=ProtobufType.STRING)
    private String mediaDirectPath;
    @ProtobufProperty(index=9, type=ProtobufType.UINT64)
    private long mediaSize;
    @ProtobufProperty(index=10, type=ProtobufType.UINT64)
    private long mediaKeyTimestamp;
    @ProtobufProperty(index=11, type=ProtobufType.UINT32)
    private Integer firstFrameLength;
    @ProtobufProperty(index=12, type=ProtobufType.BYTES)
    private byte[] firstFrameSidecar;
    @ProtobufProperty(index=13, type=ProtobufType.BOOL)
    private boolean animated;
    @ProtobufProperty(index=16, type=ProtobufType.BYTES)
    private byte[] thumbnail;
    @ProtobufProperty(index=18, name="stickerSentTs", type=ProtobufType.INT64)
    private long stickerSentTimestamp;
    @ProtobufProperty(index=19, name="isAvatar", type=ProtobufType.BOOL)
    private boolean isAvatar;

    private static StickerMessage customBuilder(byte[] media, String mimeType, byte[] thumbnail, boolean animated, ContextInfo contextInfo) {
        return ((StickerMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)StickerMessage.builder().decodedMedia(media)).mediaKeyTimestamp(Clock.nowSeconds())).mimetype(Objects.requireNonNullElse(mimeType, MediaMessageType.STICKER.defaultMimeType()))).thumbnail(thumbnail != null ? thumbnail : (byte[])Medias.getThumbnail(media, Medias.Format.PNG).orElse(null))).animated(animated)).contextInfo(Objects.requireNonNullElseGet(contextInfo, ContextInfo::new))).build();
    }

    @Override
    public MediaMessageType mediaType() {
        return MediaMessageType.STICKER;
    }

    protected StickerMessage(StickerMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.mediaUrl = b.mediaUrl;
        this.mediaSha256 = b.mediaSha256;
        this.mediaEncryptedSha256 = b.mediaEncryptedSha256;
        this.mediaKey = b.mediaKey;
        this.mimetype = b.mimetype;
        this.height = b.height;
        this.width = b.width;
        this.mediaDirectPath = b.mediaDirectPath;
        this.mediaSize = b.mediaSize;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.firstFrameLength = b.firstFrameLength;
        this.firstFrameSidecar = b.firstFrameSidecar;
        this.animated = b.animated;
        this.thumbnail = b.thumbnail;
        this.stickerSentTimestamp = b.stickerSentTimestamp;
        this.isAvatar = b.isAvatar;
    }

    public static StickerMessageBuilder<?, ?> builder() {
        return new StickerMessageBuilderImpl();
    }

    public static SimpleStickerMessageBuilder simpleBuilder() {
        return new SimpleStickerMessageBuilder();
    }

    public StickerMessage(String mediaUrl, byte[] mediaSha256, byte[] mediaEncryptedSha256, byte[] mediaKey, String mimetype, Integer height, Integer width, String mediaDirectPath, long mediaSize, long mediaKeyTimestamp, Integer firstFrameLength, byte[] firstFrameSidecar, boolean animated, byte[] thumbnail, long stickerSentTimestamp, boolean isAvatar) {
        this.mediaUrl = mediaUrl;
        this.mediaSha256 = mediaSha256;
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        this.mediaKey = mediaKey;
        this.mimetype = mimetype;
        this.height = height;
        this.width = width;
        this.mediaDirectPath = mediaDirectPath;
        this.mediaSize = mediaSize;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.firstFrameLength = firstFrameLength;
        this.firstFrameSidecar = firstFrameSidecar;
        this.animated = animated;
        this.thumbnail = thumbnail;
        this.stickerSentTimestamp = stickerSentTimestamp;
        this.isAvatar = isAvatar;
    }

    public StickerMessage() {
    }

    @Override
    public String mediaUrl() {
        return this.mediaUrl;
    }

    @Override
    public byte[] mediaSha256() {
        return this.mediaSha256;
    }

    @Override
    public byte[] mediaEncryptedSha256() {
        return this.mediaEncryptedSha256;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public String mimetype() {
        return this.mimetype;
    }

    public Integer height() {
        return this.height;
    }

    public Integer width() {
        return this.width;
    }

    @Override
    public String mediaDirectPath() {
        return this.mediaDirectPath;
    }

    @Override
    public long mediaSize() {
        return this.mediaSize;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    public Integer firstFrameLength() {
        return this.firstFrameLength;
    }

    public byte[] firstFrameSidecar() {
        return this.firstFrameSidecar;
    }

    public boolean animated() {
        return this.animated;
    }

    public byte[] thumbnail() {
        return this.thumbnail;
    }

    public long stickerSentTimestamp() {
        return this.stickerSentTimestamp;
    }

    public boolean isAvatar() {
        return this.isAvatar;
    }

    @Override
    public StickerMessage mediaUrl(String mediaUrl) {
        this.mediaUrl = mediaUrl;
        return this;
    }

    @Override
    public StickerMessage mediaSha256(byte[] mediaSha256) {
        this.mediaSha256 = mediaSha256;
        return this;
    }

    @Override
    public StickerMessage mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
        this.mediaEncryptedSha256 = mediaEncryptedSha256;
        return this;
    }

    @Override
    public StickerMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    public StickerMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    public StickerMessage height(Integer height) {
        this.height = height;
        return this;
    }

    public StickerMessage width(Integer width) {
        this.width = width;
        return this;
    }

    @Override
    public StickerMessage mediaDirectPath(String mediaDirectPath) {
        this.mediaDirectPath = mediaDirectPath;
        return this;
    }

    @Override
    public StickerMessage mediaSize(long mediaSize) {
        this.mediaSize = mediaSize;
        return this;
    }

    public StickerMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    public StickerMessage firstFrameLength(Integer firstFrameLength) {
        this.firstFrameLength = firstFrameLength;
        return this;
    }

    public StickerMessage firstFrameSidecar(byte[] firstFrameSidecar) {
        this.firstFrameSidecar = firstFrameSidecar;
        return this;
    }

    public StickerMessage animated(boolean animated) {
        this.animated = animated;
        return this;
    }

    public StickerMessage thumbnail(byte[] thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public StickerMessage stickerSentTimestamp(long stickerSentTimestamp) {
        this.stickerSentTimestamp = stickerSentTimestamp;
        return this;
    }

    public StickerMessage isAvatar(boolean isAvatar) {
        this.isAvatar = isAvatar;
        return this;
    }

    @Override
    public String toString() {
        return "StickerMessage(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl() + ", mediaSha256=" + Arrays.toString(this.mediaSha256()) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256()) + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", mimetype=" + this.mimetype() + ", height=" + this.height() + ", width=" + this.width() + ", mediaDirectPath=" + this.mediaDirectPath() + ", mediaSize=" + this.mediaSize() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", firstFrameLength=" + this.firstFrameLength() + ", firstFrameSidecar=" + Arrays.toString(this.firstFrameSidecar()) + ", animated=" + this.animated() + ", thumbnail=" + Arrays.toString(this.thumbnail()) + ", stickerSentTimestamp=" + this.stickerSentTimestamp() + ", isAvatar=" + this.isAvatar() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StickerMessage)) {
            return false;
        }
        StickerMessage other = (StickerMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaSize() != other.mediaSize()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.animated() != other.animated()) {
            return false;
        }
        if (this.stickerSentTimestamp() != other.stickerSentTimestamp()) {
            return false;
        }
        if (this.isAvatar() != other.isAvatar()) {
            return false;
        }
        Integer this$height = this.height();
        Integer other$height = other.height();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$width = this.width();
        Integer other$width = other.width();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$firstFrameLength = this.firstFrameLength();
        Integer other$firstFrameLength = other.firstFrameLength();
        if (this$firstFrameLength == null ? other$firstFrameLength != null : !((Object)this$firstFrameLength).equals(other$firstFrameLength)) {
            return false;
        }
        String this$mediaUrl = this.mediaUrl();
        String other$mediaUrl = other.mediaUrl();
        if (this$mediaUrl == null ? other$mediaUrl != null : !this$mediaUrl.equals(other$mediaUrl)) {
            return false;
        }
        if (!Arrays.equals(this.mediaSha256(), other.mediaSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaEncryptedSha256(), other.mediaEncryptedSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$mediaDirectPath = this.mediaDirectPath();
        String other$mediaDirectPath = other.mediaDirectPath();
        if (this$mediaDirectPath == null ? other$mediaDirectPath != null : !this$mediaDirectPath.equals(other$mediaDirectPath)) {
            return false;
        }
        if (!Arrays.equals(this.firstFrameSidecar(), other.firstFrameSidecar())) {
            return false;
        }
        return Arrays.equals(this.thumbnail(), other.thumbnail());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StickerMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaSize = this.mediaSize();
        result = result * 59 + (int)($mediaSize >>> 32 ^ $mediaSize);
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + (this.animated() ? 79 : 97);
        long $stickerSentTimestamp = this.stickerSentTimestamp();
        result = result * 59 + (int)($stickerSentTimestamp >>> 32 ^ $stickerSentTimestamp);
        result = result * 59 + (this.isAvatar() ? 79 : 97);
        Integer $height = this.height();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $width = this.width();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $firstFrameLength = this.firstFrameLength();
        result = result * 59 + ($firstFrameLength == null ? 43 : ((Object)$firstFrameLength).hashCode());
        String $mediaUrl = this.mediaUrl();
        result = result * 59 + ($mediaUrl == null ? 43 : $mediaUrl.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaSha256());
        result = result * 59 + Arrays.hashCode(this.mediaEncryptedSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $mediaDirectPath = this.mediaDirectPath();
        result = result * 59 + ($mediaDirectPath == null ? 43 : $mediaDirectPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.firstFrameSidecar());
        result = result * 59 + Arrays.hashCode(this.thumbnail());
        return result;
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        protobufOutputStream.writeUInt64(10, this.mediaKeyTimestamp);
        if (this.mediaKey != null) {
            protobufOutputStream.writeBytes(4, this.mediaKey);
        }
        if (this.firstFrameLength != null) {
            protobufOutputStream.writeUInt32(11, this.firstFrameLength);
        }
        if (this.thumbnail != null) {
            protobufOutputStream.writeBytes(16, this.thumbnail);
        }
        if (this.mediaSha256 != null) {
            protobufOutputStream.writeBytes(2, this.mediaSha256);
        }
        if (this.mediaUrl != null) {
            protobufOutputStream.writeString(1, this.mediaUrl);
        }
        if (this.firstFrameSidecar != null) {
            protobufOutputStream.writeBytes(12, this.firstFrameSidecar);
        }
        protobufOutputStream.writeBool(19, this.isAvatar);
        if (this.width != null) {
            protobufOutputStream.writeUInt32(7, this.width);
        }
        if (this.height != null) {
            protobufOutputStream.writeUInt32(6, this.height);
        }
        protobufOutputStream.writeUInt64(9, this.mediaSize);
        if (this.contextInfo != null) {
            protobufOutputStream.writeBytes(17, this.contextInfo.toEncodedProtobuf());
        }
        if (this.mediaDirectPath != null) {
            protobufOutputStream.writeString(8, this.mediaDirectPath);
        }
        protobufOutputStream.writeInt64(18, this.stickerSentTimestamp);
        protobufOutputStream.writeBool(13, this.animated);
        if (this.mediaEncryptedSha256 != null) {
            protobufOutputStream.writeBytes(3, this.mediaEncryptedSha256);
        }
        if (this.mimetype != null) {
            protobufOutputStream.writeString(5, this.mimetype);
        }
        return protobufOutputStream.toByteArray();
    }

    public static StickerMessage ofProtobuf(byte[] byArray) {
        int n;
        StickerMessageBuilder<?, ?> stickerMessageBuilder = StickerMessage.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block19: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 10: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaKeyTimestamp(protobufInputStream.readInt64());
                    continue block19;
                }
                case 4: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaKey(protobufInputStream.readBytes());
                    continue block19;
                }
                case 11: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.firstFrameLength(protobufInputStream.readInt32());
                    continue block19;
                }
                case 16: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.thumbnail(protobufInputStream.readBytes());
                    continue block19;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaSha256(protobufInputStream.readBytes());
                    continue block19;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaUrl(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block19;
                }
                case 12: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.firstFrameSidecar(protobufInputStream.readBytes());
                    continue block19;
                }
                case 19: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.isAvatar(protobufInputStream.readBool());
                    continue block19;
                }
                case 7: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.width(protobufInputStream.readInt32());
                    continue block19;
                }
                case 6: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.height(protobufInputStream.readInt32());
                    continue block19;
                }
                case 9: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaSize(protobufInputStream.readInt64());
                    continue block19;
                }
                case 17: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.contextInfo(ContextInfo.ofProtobuf(protobufInputStream.readBytes()));
                    continue block19;
                }
                case 8: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaDirectPath(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block19;
                }
                case 18: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.stickerSentTimestamp(protobufInputStream.readInt64());
                    continue block19;
                }
                case 13: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.animated(protobufInputStream.readBool());
                    continue block19;
                }
                case 3: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mediaEncryptedSha256(protobufInputStream.readBytes());
                    continue block19;
                }
                case 5: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    stickerMessageBuilder.mimetype(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block19;
                }
            }
            protobufInputStream.readBytes();
        }
        return stickerMessageBuilder.build();
    }

    public static abstract class StickerMessageBuilder<C extends StickerMessage, B extends StickerMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private String mediaUrl;
        private byte[] mediaSha256;
        private byte[] mediaEncryptedSha256;
        private byte[] mediaKey;
        private String mimetype;
        private Integer height;
        private Integer width;
        private String mediaDirectPath;
        private long mediaSize;
        private long mediaKeyTimestamp;
        private Integer firstFrameLength;
        private byte[] firstFrameSidecar;
        private boolean animated;
        private byte[] thumbnail;
        private long stickerSentTimestamp;
        private boolean isAvatar;

        public B mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return (B)this.self();
        }

        public B mediaSha256(byte[] mediaSha256) {
            this.mediaSha256 = mediaSha256;
            return (B)this.self();
        }

        public B mediaEncryptedSha256(byte[] mediaEncryptedSha256) {
            this.mediaEncryptedSha256 = mediaEncryptedSha256;
            return (B)this.self();
        }

        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        public B height(Integer height) {
            this.height = height;
            return (B)this.self();
        }

        public B width(Integer width) {
            this.width = width;
            return (B)this.self();
        }

        public B mediaDirectPath(String mediaDirectPath) {
            this.mediaDirectPath = mediaDirectPath;
            return (B)this.self();
        }

        public B mediaSize(long mediaSize) {
            this.mediaSize = mediaSize;
            return (B)this.self();
        }

        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        public B firstFrameLength(Integer firstFrameLength) {
            this.firstFrameLength = firstFrameLength;
            return (B)this.self();
        }

        public B firstFrameSidecar(byte[] firstFrameSidecar) {
            this.firstFrameSidecar = firstFrameSidecar;
            return (B)this.self();
        }

        public B animated(boolean animated) {
            this.animated = animated;
            return (B)this.self();
        }

        public B thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return (B)this.self();
        }

        public B stickerSentTimestamp(long stickerSentTimestamp) {
            this.stickerSentTimestamp = stickerSentTimestamp;
            return (B)this.self();
        }

        public B isAvatar(boolean isAvatar) {
            this.isAvatar = isAvatar;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "StickerMessage.StickerMessageBuilder(super=" + super.toString() + ", mediaUrl=" + this.mediaUrl + ", mediaSha256=" + Arrays.toString(this.mediaSha256) + ", mediaEncryptedSha256=" + Arrays.toString(this.mediaEncryptedSha256) + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", mimetype=" + this.mimetype + ", height=" + this.height + ", width=" + this.width + ", mediaDirectPath=" + this.mediaDirectPath + ", mediaSize=" + this.mediaSize + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", firstFrameLength=" + this.firstFrameLength + ", firstFrameSidecar=" + Arrays.toString(this.firstFrameSidecar) + ", animated=" + this.animated + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", stickerSentTimestamp=" + this.stickerSentTimestamp + ", isAvatar=" + this.isAvatar + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class StickerMessageBuilderImpl
    extends StickerMessageBuilder<StickerMessage, StickerMessageBuilderImpl> {
        private StickerMessageBuilderImpl() {
        }

        @Override
        protected StickerMessageBuilderImpl self() {
            return this;
        }

        @Override
        public StickerMessage build() {
            return new StickerMessage(this);
        }
    }

    public static class SimpleStickerMessageBuilder {
        private byte[] media;
        private String mimeType;
        private byte[] thumbnail;
        private boolean animated;
        private ContextInfo contextInfo;

        SimpleStickerMessageBuilder() {
        }

        public SimpleStickerMessageBuilder media(byte[] media) {
            this.media = media;
            return this;
        }

        public SimpleStickerMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public SimpleStickerMessageBuilder thumbnail(byte[] thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public SimpleStickerMessageBuilder animated(boolean animated) {
            this.animated = animated;
            return this;
        }

        public SimpleStickerMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public StickerMessage build() {
            return StickerMessage.customBuilder(this.media, this.mimeType, this.thumbnail, this.animated, this.contextInfo);
        }

        public String toString() {
            return "StickerMessage.SimpleStickerMessageBuilder(media=" + Arrays.toString(this.media) + ", mimeType=" + this.mimeType + ", thumbnail=" + Arrays.toString(this.thumbnail) + ", animated=" + this.animated + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

