/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.media;

import it.auties.whatsapp.model.request.Node;
import java.util.List;
import lombok.NonNull;

public record MediaConnection(@NonNull String auth, int ttl, int maxBuckets, long timestamp, @NonNull @NonNull List<@NonNull String> hosts) {
    public MediaConnection(@NonNull String auth, int ttl, int maxBuckets, long timestamp, @NonNull @NonNull List<@NonNull String> hosts) {
        if (auth == null) {
            throw new NullPointerException("auth is marked non-null but is null");
        }
        if (hosts == null) {
            throw new NullPointerException("hosts is marked non-null but is null");
        }
    }

    public static MediaConnection of(Node node) {
        Node mediaConnection = node.findNode("media_conn").orElse(node);
        String auth = mediaConnection.attributes().getString("auth");
        int ttl = mediaConnection.attributes().getInt("ttl");
        int maxBuckets = mediaConnection.attributes().getInt("max_buckets");
        long timestamp = System.currentTimeMillis();
        List<String> hosts = mediaConnection.findNodes("host").stream().map(Node::attributes).map(attributes -> attributes.getString("hostname")).toList();
        return new MediaConnection(auth, ttl, maxBuckets, timestamp, hosts);
    }
}

