/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.interactive;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufMessage;
import it.auties.protobuf.base.ProtobufName;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.model.interactive.InteractiveHeaderAttachment;
import it.auties.whatsapp.model.interactive.InteractiveHeaderThumbnail;
import it.auties.whatsapp.model.message.standard.DocumentMessage;
import it.auties.whatsapp.model.message.standard.ImageMessage;
import it.auties.whatsapp.model.message.standard.VideoMessage;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;

@ProtobufName(value="Header")
@JsonDeserialize(builder=InteractiveHeaderBuilder.class)
public class InteractiveHeader
implements ProtobufMessage {
    @ProtobufProperty(index=1, type=ProtobufType.STRING)
    private String title;
    @ProtobufProperty(index=2, type=ProtobufType.STRING)
    private String subtitle;
    @ProtobufProperty(index=5, type=ProtobufType.BOOL)
    private boolean mediaAttachment;
    @ProtobufProperty(index=3, type=ProtobufType.MESSAGE, implementation=DocumentMessage.class)
    private DocumentMessage attachmentDocument;
    @ProtobufProperty(index=4, type=ProtobufType.MESSAGE, implementation=ImageMessage.class)
    private ImageMessage attachmentImage;
    @ProtobufProperty(index=6, type=ProtobufType.BYTES)
    private byte[] attachmentThumbnail;
    @ProtobufProperty(index=7, type=ProtobufType.MESSAGE, implementation=VideoMessage.class)
    private VideoMessage attachmentVideo;

    private static InteractiveHeader customBuilder(String title, String subtitle, InteractiveHeaderAttachment attachment) {
        InteractiveHeaderBuilder builder = InteractiveHeader.builder().title(title).subtitle(subtitle);
        if (attachment instanceof DocumentMessage) {
            DocumentMessage documentMessage = (DocumentMessage)attachment;
            builder.attachmentDocument(documentMessage).mediaAttachment(true);
        } else if (attachment instanceof ImageMessage) {
            ImageMessage imageMessage = (ImageMessage)attachment;
            builder.attachmentImage(imageMessage).mediaAttachment(true);
        } else if (attachment instanceof InteractiveHeaderThumbnail) {
            InteractiveHeaderThumbnail productHeaderThumbnail = (InteractiveHeaderThumbnail)attachment;
            builder.attachmentThumbnail(productHeaderThumbnail.thumbnail()).mediaAttachment(true);
        } else if (attachment instanceof VideoMessage) {
            VideoMessage videoMessage = (VideoMessage)attachment;
            builder.attachmentVideo(videoMessage).mediaAttachment(true);
        }
        return builder.build();
    }

    public AttachmentType attachmentType() {
        if (this.attachmentDocument != null) {
            return AttachmentType.DOCUMENT;
        }
        if (this.attachmentImage != null) {
            return AttachmentType.IMAGE;
        }
        if (this.attachmentThumbnail != null) {
            return AttachmentType.THUMBNAIL;
        }
        if (this.attachmentVideo != null) {
            return AttachmentType.VIDEO;
        }
        return AttachmentType.NONE;
    }

    public Optional<InteractiveHeaderAttachment> attachment() {
        if (this.attachmentDocument != null) {
            return Optional.of(this.attachmentDocument);
        }
        if (this.attachmentImage != null) {
            return Optional.of(this.attachmentImage);
        }
        if (this.attachmentThumbnail != null) {
            return Optional.of(InteractiveHeaderThumbnail.of(this.attachmentThumbnail));
        }
        if (this.attachmentVideo != null) {
            return Optional.of(this.attachmentVideo);
        }
        return Optional.empty();
    }

    public Optional<DocumentMessage> attachmentDocument() {
        return Optional.ofNullable(this.attachmentDocument);
    }

    public Optional<ImageMessage> attachmentImage() {
        return Optional.ofNullable(this.attachmentImage);
    }

    public Optional<byte[]> attachmentThumbnail() {
        return Optional.ofNullable(this.attachmentThumbnail);
    }

    public Optional<VideoMessage> attachmentVideo() {
        return Optional.ofNullable(this.attachmentVideo);
    }

    public static InteractiveHeaderBuilder builder() {
        return new InteractiveHeaderBuilder();
    }

    public static ProductHeaderSimpleBuilder simpleBuilder() {
        return new ProductHeaderSimpleBuilder();
    }

    public InteractiveHeader(String title, String subtitle, boolean mediaAttachment, DocumentMessage attachmentDocument, ImageMessage attachmentImage, byte[] attachmentThumbnail, VideoMessage attachmentVideo) {
        this.title = title;
        this.subtitle = subtitle;
        this.mediaAttachment = mediaAttachment;
        this.attachmentDocument = attachmentDocument;
        this.attachmentImage = attachmentImage;
        this.attachmentThumbnail = attachmentThumbnail;
        this.attachmentVideo = attachmentVideo;
    }

    public String title() {
        return this.title;
    }

    public String subtitle() {
        return this.subtitle;
    }

    public boolean mediaAttachment() {
        return this.mediaAttachment;
    }

    public InteractiveHeader title(String title) {
        this.title = title;
        return this;
    }

    public InteractiveHeader subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public InteractiveHeader mediaAttachment(boolean mediaAttachment) {
        this.mediaAttachment = mediaAttachment;
        return this;
    }

    public InteractiveHeader attachmentDocument(DocumentMessage attachmentDocument) {
        this.attachmentDocument = attachmentDocument;
        return this;
    }

    public InteractiveHeader attachmentImage(ImageMessage attachmentImage) {
        this.attachmentImage = attachmentImage;
        return this;
    }

    public InteractiveHeader attachmentThumbnail(byte[] attachmentThumbnail) {
        this.attachmentThumbnail = attachmentThumbnail;
        return this;
    }

    public InteractiveHeader attachmentVideo(VideoMessage attachmentVideo) {
        this.attachmentVideo = attachmentVideo;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InteractiveHeader)) {
            return false;
        }
        InteractiveHeader other = (InteractiveHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.mediaAttachment() != other.mediaAttachment()) {
            return false;
        }
        String this$title = this.title();
        String other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subtitle = this.subtitle();
        String other$subtitle = other.subtitle();
        if (this$subtitle == null ? other$subtitle != null : !this$subtitle.equals(other$subtitle)) {
            return false;
        }
        Optional<DocumentMessage> this$attachmentDocument = this.attachmentDocument();
        Optional<DocumentMessage> other$attachmentDocument = other.attachmentDocument();
        if (this$attachmentDocument == null ? other$attachmentDocument != null : !((Object)this$attachmentDocument).equals(other$attachmentDocument)) {
            return false;
        }
        Optional<ImageMessage> this$attachmentImage = this.attachmentImage();
        Optional<ImageMessage> other$attachmentImage = other.attachmentImage();
        if (this$attachmentImage == null ? other$attachmentImage != null : !((Object)this$attachmentImage).equals(other$attachmentImage)) {
            return false;
        }
        Optional<byte[]> this$attachmentThumbnail = this.attachmentThumbnail();
        Optional<byte[]> other$attachmentThumbnail = other.attachmentThumbnail();
        if (this$attachmentThumbnail == null ? other$attachmentThumbnail != null : !((Object)this$attachmentThumbnail).equals(other$attachmentThumbnail)) {
            return false;
        }
        Optional<VideoMessage> this$attachmentVideo = this.attachmentVideo();
        Optional<VideoMessage> other$attachmentVideo = other.attachmentVideo();
        return !(this$attachmentVideo == null ? other$attachmentVideo != null : !((Object)this$attachmentVideo).equals(other$attachmentVideo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InteractiveHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mediaAttachment() ? 79 : 97);
        String $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subtitle = this.subtitle();
        result = result * 59 + ($subtitle == null ? 43 : $subtitle.hashCode());
        Optional<DocumentMessage> $attachmentDocument = this.attachmentDocument();
        result = result * 59 + ($attachmentDocument == null ? 43 : ((Object)$attachmentDocument).hashCode());
        Optional<ImageMessage> $attachmentImage = this.attachmentImage();
        result = result * 59 + ($attachmentImage == null ? 43 : ((Object)$attachmentImage).hashCode());
        Optional<byte[]> $attachmentThumbnail = this.attachmentThumbnail();
        result = result * 59 + ($attachmentThumbnail == null ? 43 : ((Object)$attachmentThumbnail).hashCode());
        Optional<VideoMessage> $attachmentVideo = this.attachmentVideo();
        result = result * 59 + ($attachmentVideo == null ? 43 : ((Object)$attachmentVideo).hashCode());
        return result;
    }

    public String toString() {
        return "InteractiveHeader(title=" + this.title() + ", subtitle=" + this.subtitle() + ", mediaAttachment=" + this.mediaAttachment() + ", attachmentDocument=" + this.attachmentDocument() + ", attachmentImage=" + this.attachmentImage() + ", attachmentThumbnail=" + this.attachmentThumbnail() + ", attachmentVideo=" + this.attachmentVideo() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.attachmentImage != null) {
            protobufOutputStream.writeBytes(4, this.attachmentImage.toEncodedProtobuf());
        }
        if (this.attachmentThumbnail != null) {
            protobufOutputStream.writeBytes(6, this.attachmentThumbnail);
        }
        if (this.attachmentVideo != null) {
            protobufOutputStream.writeBytes(7, this.attachmentVideo.toEncodedProtobuf());
        }
        if (this.title != null) {
            protobufOutputStream.writeString(1, this.title);
        }
        if (this.subtitle != null) {
            protobufOutputStream.writeString(2, this.subtitle);
        }
        if (this.attachmentDocument != null) {
            protobufOutputStream.writeBytes(3, this.attachmentDocument.toEncodedProtobuf());
        }
        protobufOutputStream.writeBool(5, this.mediaAttachment);
        return protobufOutputStream.toByteArray();
    }

    public static InteractiveHeader ofProtobuf(byte[] byArray) {
        int n;
        InteractiveHeaderBuilder interactiveHeaderBuilder = InteractiveHeader.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block9: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 4: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.attachmentImage(ImageMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block9;
                }
                case 6: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.attachmentThumbnail(protobufInputStream.readBytes());
                    continue block9;
                }
                case 7: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.attachmentVideo(VideoMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block9;
                }
                case 1: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.title(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block9;
                }
                case 2: {
                    if (n3 != 2) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.subtitle(new String(protobufInputStream.readBytes(), StandardCharsets.UTF_8));
                    continue block9;
                }
                case 3: {
                    if (n3 != 2 && n3 != 3) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.attachmentDocument(DocumentMessage.ofProtobuf(protobufInputStream.readBytes()));
                    continue block9;
                }
                case 5: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    interactiveHeaderBuilder.mediaAttachment(protobufInputStream.readBool());
                    continue block9;
                }
            }
            protobufInputStream.readBytes();
        }
        return interactiveHeaderBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class InteractiveHeaderBuilder {
        private String title;
        private String subtitle;
        private boolean mediaAttachment;
        private DocumentMessage attachmentDocument;
        private ImageMessage attachmentImage;
        private byte[] attachmentThumbnail;
        private VideoMessage attachmentVideo;

        InteractiveHeaderBuilder() {
        }

        public InteractiveHeaderBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InteractiveHeaderBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public InteractiveHeaderBuilder mediaAttachment(boolean mediaAttachment) {
            this.mediaAttachment = mediaAttachment;
            return this;
        }

        public InteractiveHeaderBuilder attachmentDocument(DocumentMessage attachmentDocument) {
            this.attachmentDocument = attachmentDocument;
            return this;
        }

        public InteractiveHeaderBuilder attachmentImage(ImageMessage attachmentImage) {
            this.attachmentImage = attachmentImage;
            return this;
        }

        public InteractiveHeaderBuilder attachmentThumbnail(byte[] attachmentThumbnail) {
            this.attachmentThumbnail = attachmentThumbnail;
            return this;
        }

        public InteractiveHeaderBuilder attachmentVideo(VideoMessage attachmentVideo) {
            this.attachmentVideo = attachmentVideo;
            return this;
        }

        public InteractiveHeader build() {
            return new InteractiveHeader(this.title, this.subtitle, this.mediaAttachment, this.attachmentDocument, this.attachmentImage, this.attachmentThumbnail, this.attachmentVideo);
        }

        public String toString() {
            return "InteractiveHeader.InteractiveHeaderBuilder(title=" + this.title + ", subtitle=" + this.subtitle + ", mediaAttachment=" + this.mediaAttachment + ", attachmentDocument=" + this.attachmentDocument + ", attachmentImage=" + this.attachmentImage + ", attachmentThumbnail=" + Arrays.toString(this.attachmentThumbnail) + ", attachmentVideo=" + this.attachmentVideo + ")";
        }
    }

    public static enum AttachmentType implements ProtobufMessage
    {
        NONE(0),
        DOCUMENT(3),
        IMAGE(4),
        THUMBNAIL(6),
        VIDEO(7);

        private final int index;

        private AttachmentType(int index) {
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        private static /* synthetic */ boolean lambda$of$0(int index, AttachmentType entry) {
            return entry.index() == index;
        }

        public byte[] toEncodedProtobuf() {
            ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
            return protobufOutputStream.toByteArray();
        }

        public static AttachmentType of(int n) {
            Iterator iterator = Arrays.stream(AttachmentType.values()).iterator();
            while (iterator.hasNext()) {
                AttachmentType attachmentType = (AttachmentType)((Object)iterator.next());
                if (attachmentType.index() != n) continue;
                return attachmentType;
            }
            return null;
        }
    }

    public static class ProductHeaderSimpleBuilder {
        private String title;
        private String subtitle;
        private InteractiveHeaderAttachment attachment;

        ProductHeaderSimpleBuilder() {
        }

        public ProductHeaderSimpleBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ProductHeaderSimpleBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public ProductHeaderSimpleBuilder attachment(InteractiveHeaderAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public InteractiveHeader build() {
            return InteractiveHeader.customBuilder(this.title, this.subtitle, this.attachment);
        }

        public String toString() {
            return "InteractiveHeader.ProductHeaderSimpleBuilder(title=" + this.title + ", subtitle=" + this.subtitle + ", attachment=" + this.attachment + ")";
        }
    }
}

