/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.info;

import com.fasterxml.jackson.core.type.TypeReference;
import it.auties.whatsapp.model.contact.ContactJid;
import it.auties.whatsapp.model.info.Info;
import it.auties.whatsapp.util.Json;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.NonNull;

public record MessageIndexInfo(@NonNull String type, @NonNull Optional<ContactJid> chatJid, @NonNull Optional<String> messageId, boolean fromMe) implements Info
{
    public MessageIndexInfo(@NonNull String type, @NonNull Optional<ContactJid> chatJid, @NonNull Optional<String> messageId, boolean fromMe) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (chatJid == null) {
            throw new NullPointerException("chatJid is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
    }

    public static MessageIndexInfo of(@NonNull String type, ContactJid chatJid, String messageId, boolean fromMe) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return new MessageIndexInfo(type, Optional.ofNullable(chatJid), Optional.ofNullable(messageId), fromMe);
    }

    public static MessageIndexInfo ofJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        List<String> array = Json.readValue(json, new TypeReference<List<String>>(){});
        String type = MessageIndexInfo.getProperty(array, 0).orElseThrow(() -> new NoSuchElementException("Cannot parse MessageSync: missing type"));
        Optional<ContactJid> chatJid = MessageIndexInfo.getProperty(array, 1).map(ContactJid::of);
        Optional<String> messageId = MessageIndexInfo.getProperty(array, 2);
        Boolean fromMe = MessageIndexInfo.getProperty(array, 3).map(Boolean::parseBoolean).orElse(false);
        return new MessageIndexInfo(type, chatJid, messageId, fromMe);
    }

    private static Optional<String> getProperty(List<String> list, int index) {
        return list.size() > index ? Optional.ofNullable(list.get(index)) : Optional.empty();
    }

    public static MessageIndexInfoBuilder builder() {
        return new MessageIndexInfoBuilder();
    }

    public static class MessageIndexInfoBuilder {
        private String type;
        private Optional<ContactJid> chatJid;
        private Optional<String> messageId;
        private boolean fromMe;

        MessageIndexInfoBuilder() {
        }

        public MessageIndexInfoBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public MessageIndexInfoBuilder chatJid(@NonNull Optional<ContactJid> chatJid) {
            if (chatJid == null) {
                throw new NullPointerException("chatJid is marked non-null but is null");
            }
            this.chatJid = chatJid;
            return this;
        }

        public MessageIndexInfoBuilder messageId(@NonNull Optional<String> messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        public MessageIndexInfoBuilder fromMe(boolean fromMe) {
            this.fromMe = fromMe;
            return this;
        }

        public MessageIndexInfo build() {
            return new MessageIndexInfo(this.type, this.chatJid, this.messageId, this.fromMe);
        }

        public String toString() {
            return "MessageIndexInfo.MessageIndexInfoBuilder(type=" + this.type + ", chatJid=" + this.chatJid + ", messageId=" + this.messageId + ", fromMe=" + this.fromMe + ")";
        }
    }
}

