/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.contact;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import ezvcard.Ezvcard;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.property.RawProperty;
import ezvcard.property.Telephone;
import it.auties.protobuf.base.ProtobufConverter;
import it.auties.whatsapp.model.contact.ContactJid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

@JsonDeserialize(builder=ContactCardBuilder.class)
public final class ContactCard {
    private static final String BUSINESS_NAME_PROPERTY = "X-WA-BIZ-NAME";
    private static final String PHONE_NUMBER_PROPERTY = "WAID";
    private static final String DEFAULT_NUMBER_TYPE = "CELL";
    private final String version;
    private final String name;
    @NonNull
    private final Map<String, List<ContactJid>> phoneNumbers;
    private final String businessName;

    @ProtobufConverter
    public static ContactCard ofProtobuf(String vcard) {
        return vcard == null ? null : ContactCard.of(vcard);
    }

    public static ContactCard of(@NonNull String vcard) {
        if (vcard == null) {
            throw new NullPointerException("vcard is marked non-null but is null");
        }
        VCard parsed = Ezvcard.parse((String)vcard).first();
        String version = parsed.getVersion().getVersion();
        String name = (String)parsed.getFormattedName().getValue();
        Map<String, List<ContactJid>> phoneNumbers = parsed.getTelephoneNumbers().stream().filter(ContactCard::isValidPhoneNumber).collect(Collectors.toUnmodifiableMap(ContactCard::getPhoneType, ContactCard::getPhoneValue, ContactCard::joinPhoneNumbers));
        RawProperty businessName = parsed.getExtendedProperty(BUSINESS_NAME_PROPERTY);
        return new ContactCard(version, name, phoneNumbers, businessName != null ? (String)businessName.getValue() : null);
    }

    private static boolean isValidPhoneNumber(Telephone entry) {
        return ContactCard.getPhoneType(entry) != null && entry.getParameter(PHONE_NUMBER_PROPERTY) != null;
    }

    private static String getPhoneType(Telephone entry) {
        return entry.getParameters().getType();
    }

    private static List<ContactJid> getPhoneValue(Telephone entry) {
        return List.of(ContactJid.of(entry.getParameter(PHONE_NUMBER_PROPERTY)));
    }

    private static List<ContactJid> joinPhoneNumbers(List<ContactJid> first, List<ContactJid> second) {
        return Stream.of(first, second).flatMap(Collection::stream).toList();
    }

    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> businessName() {
        return Optional.ofNullable(this.businessName);
    }

    @ProtobufConverter
    public String toValue() {
        return this.toString();
    }

    public String toString() {
        return this.toVcard();
    }

    public String toVcard() {
        VCard vcard = new VCard();
        vcard.setVersion(this.version().map(VCardVersion::valueOfByStr).orElse(VCardVersion.V3_0));
        vcard.setFormattedName(this.name);
        this.phoneNumbers().forEach((type, contacts) -> contacts.forEach(contact -> this.addPhoneNumber(vcard, (String)type, (ContactJid)contact)));
        if (this.businessName != null) {
            vcard.addExtendedProperty(BUSINESS_NAME_PROPERTY, this.businessName);
        }
        return Ezvcard.write((VCard[])new VCard[]{vcard}).go();
    }

    private void addPhoneNumber(VCard vcard, String type, ContactJid contact) {
        Telephone telephone = new Telephone(contact.toPhoneNumber());
        telephone.getParameters().setType(type);
        telephone.getParameters().put((Object)PHONE_NUMBER_PROPERTY, (Object)contact.user());
        vcard.addTelephoneNumber(telephone);
    }

    public Optional<String> version() {
        return Optional.ofNullable(this.version);
    }

    public static ContactCardBuilder builder() {
        return new ContactCardBuilder();
    }

    @NonNull
    public Map<String, List<ContactJid>> phoneNumbers() {
        return this.phoneNumbers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactCard)) {
            return false;
        }
        ContactCard other = (ContactCard)o;
        Optional<String> this$version = this.version();
        Optional<String> other$version = other.version();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Optional<String> this$name = this.name();
        Optional<String> other$name = other.name();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        Map<String, List<ContactJid>> this$phoneNumbers = this.phoneNumbers();
        Map<String, List<ContactJid>> other$phoneNumbers = other.phoneNumbers();
        if (this$phoneNumbers == null ? other$phoneNumbers != null : !((Object)this$phoneNumbers).equals(other$phoneNumbers)) {
            return false;
        }
        Optional<String> this$businessName = this.businessName();
        Optional<String> other$businessName = other.businessName();
        return !(this$businessName == null ? other$businessName != null : !((Object)this$businessName).equals(other$businessName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $version = this.version();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Optional<String> $name = this.name();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        Map<String, List<ContactJid>> $phoneNumbers = this.phoneNumbers();
        result = result * 59 + ($phoneNumbers == null ? 43 : ((Object)$phoneNumbers).hashCode());
        Optional<String> $businessName = this.businessName();
        result = result * 59 + ($businessName == null ? 43 : ((Object)$businessName).hashCode());
        return result;
    }

    public ContactCard(String version, String name, @NonNull Map<String, List<ContactJid>> phoneNumbers, String businessName) {
        if (phoneNumbers == null) {
            throw new NullPointerException("phoneNumbers is marked non-null but is null");
        }
        this.version = version;
        this.name = name;
        this.phoneNumbers = phoneNumbers;
        this.businessName = businessName;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ContactCardBuilder {
        private String version;
        private String name;
        private Map<String, List<ContactJid>> phoneNumbers;
        private String businessName;

        public ContactCardBuilder phoneNumber(@NonNull ContactJid contact) {
            if (contact == null) {
                throw new NullPointerException("contact is marked non-null but is null");
            }
            return this.phoneNumber(ContactCard.DEFAULT_NUMBER_TYPE, contact);
        }

        public ContactCardBuilder phoneNumber(@NonNull String category, @NonNull ContactJid contact) {
            List<ContactJid> oldValue;
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            if (contact == null) {
                throw new NullPointerException("contact is marked non-null but is null");
            }
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new HashMap<String, List<ContactJid>>();
            }
            if ((oldValue = this.phoneNumbers.get(category)) == null) {
                this.phoneNumbers.put(category, List.of(contact));
                return this;
            }
            ArrayList<ContactJid> values = new ArrayList<ContactJid>(oldValue);
            values.add(contact);
            this.phoneNumbers.put(category, Collections.unmodifiableList(values));
            return this;
        }

        ContactCardBuilder() {
        }

        public ContactCardBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ContactCardBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ContactCardBuilder phoneNumbers(@NonNull Map<String, List<ContactJid>> phoneNumbers) {
            if (phoneNumbers == null) {
                throw new NullPointerException("phoneNumbers is marked non-null but is null");
            }
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public ContactCardBuilder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public ContactCard build() {
            return new ContactCard(this.version, this.name, this.phoneNumbers, this.businessName);
        }

        public String toString() {
            return "ContactCard.ContactCardBuilder(version=" + this.version + ", name=" + this.name + ", phoneNumbers=" + this.phoneNumbers + ", businessName=" + this.businessName + ")";
        }
    }
}

