/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.model.action;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import it.auties.protobuf.base.ProtobufDeserializationException;
import it.auties.protobuf.base.ProtobufInputStream;
import it.auties.protobuf.base.ProtobufOutputStream;
import it.auties.protobuf.base.ProtobufProperty;
import it.auties.protobuf.base.ProtobufType;
import it.auties.whatsapp.binary.BinaryPatchType;
import it.auties.whatsapp.model.action.Action;
import it.auties.whatsapp.util.Clock;
import java.time.ZonedDateTime;

@JsonDeserialize(builder=MuteActionBuilder.class)
public final class MuteAction
implements Action {
    @ProtobufProperty(index=1, type=ProtobufType.BOOL)
    private boolean muted;
    @ProtobufProperty(index=2, type=ProtobufType.INT64)
    private Long muteEndTimestampSeconds;
    @ProtobufProperty(index=3, name="autoMuted", type=ProtobufType.BOOL)
    private boolean autoMuted;

    public ZonedDateTime muteEnd() {
        return Clock.parseSeconds(this.muteEndTimestampSeconds);
    }

    public long muteEndTimestampSeconds() {
        return this.muteEndTimestampSeconds == null ? 0L : this.muteEndTimestampSeconds;
    }

    @Override
    public String indexName() {
        return "mute";
    }

    @Override
    public int actionVersion() {
        return 2;
    }

    @Override
    public BinaryPatchType actionType() {
        return null;
    }

    public static MuteActionBuilder builder() {
        return new MuteActionBuilder();
    }

    public MuteAction(boolean muted, Long muteEndTimestampSeconds, boolean autoMuted) {
        this.muted = muted;
        this.muteEndTimestampSeconds = muteEndTimestampSeconds;
        this.autoMuted = autoMuted;
    }

    public boolean muted() {
        return this.muted;
    }

    public boolean autoMuted() {
        return this.autoMuted;
    }

    public MuteAction muted(boolean muted) {
        this.muted = muted;
        return this;
    }

    public MuteAction muteEndTimestampSeconds(Long muteEndTimestampSeconds) {
        this.muteEndTimestampSeconds = muteEndTimestampSeconds;
        return this;
    }

    public MuteAction autoMuted(boolean autoMuted) {
        this.autoMuted = autoMuted;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MuteAction)) {
            return false;
        }
        MuteAction other = (MuteAction)o;
        if (this.muted() != other.muted()) {
            return false;
        }
        if (this.autoMuted() != other.autoMuted()) {
            return false;
        }
        return this.muteEndTimestampSeconds() == other.muteEndTimestampSeconds();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.muted() ? 79 : 97);
        result = result * 59 + (this.autoMuted() ? 79 : 97);
        long $muteEndTimestampSeconds = this.muteEndTimestampSeconds();
        result = result * 59 + (int)($muteEndTimestampSeconds >>> 32 ^ $muteEndTimestampSeconds);
        return result;
    }

    public String toString() {
        return "MuteAction(muted=" + this.muted() + ", muteEndTimestampSeconds=" + this.muteEndTimestampSeconds() + ", autoMuted=" + this.autoMuted() + ")";
    }

    public byte[] toEncodedProtobuf() {
        ProtobufOutputStream protobufOutputStream = new ProtobufOutputStream();
        if (this.muteEndTimestampSeconds != null) {
            protobufOutputStream.writeInt64(2, this.muteEndTimestampSeconds);
        }
        protobufOutputStream.writeBool(1, this.muted);
        protobufOutputStream.writeBool(3, this.autoMuted);
        return protobufOutputStream.toByteArray();
    }

    public static MuteAction ofProtobuf(byte[] byArray) {
        int n;
        MuteActionBuilder muteActionBuilder = MuteAction.builder();
        ProtobufInputStream protobufInputStream = new ProtobufInputStream(byArray);
        block5: while ((n = protobufInputStream.readTag()) != 0) {
            int n2 = n >>> 3;
            int n3 = n & 7;
            switch (n2) {
                case 2: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    muteActionBuilder.muteEndTimestampSeconds(protobufInputStream.readInt64());
                    continue block5;
                }
                case 1: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    muteActionBuilder.muted(protobufInputStream.readBool());
                    continue block5;
                }
                case 3: {
                    if (n3 != 0) {
                        throw ProtobufDeserializationException.invalidTag((int)n3);
                    }
                    muteActionBuilder.autoMuted(protobufInputStream.readBool());
                    continue block5;
                }
            }
            protobufInputStream.readBytes();
        }
        return muteActionBuilder.build();
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class MuteActionBuilder {
        private boolean muted;
        private Long muteEndTimestampSeconds;
        private boolean autoMuted;

        MuteActionBuilder() {
        }

        public MuteActionBuilder muted(boolean muted) {
            this.muted = muted;
            return this;
        }

        public MuteActionBuilder muteEndTimestampSeconds(Long muteEndTimestampSeconds) {
            this.muteEndTimestampSeconds = muteEndTimestampSeconds;
            return this;
        }

        public MuteActionBuilder autoMuted(boolean autoMuted) {
            this.autoMuted = autoMuted;
            return this;
        }

        public MuteAction build() {
            return new MuteAction(this.muted, this.muteEndTimestampSeconds, this.autoMuted);
        }

        public String toString() {
            return "MuteAction.MuteActionBuilder(muted=" + this.muted + ", muteEndTimestampSeconds=" + this.muteEndTimestampSeconds + ", autoMuted=" + this.autoMuted + ")";
        }
    }
}

