/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionType;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.TextPreviewSetting;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.signal.auth.UserAgent;
import it.auties.whatsapp.model.signal.auth.Version;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class OptionsBuilder<T extends OptionsBuilder<T>> {
    protected Store store;
    protected Keys keys;
    protected ErrorHandler errorHandler;
    protected Executor socketExecutor;

    protected OptionsBuilder(Store store, Keys keys) {
        this.store = store;
        this.keys = keys;
    }

    protected static UUID getCorrectUuid(UUID uuid, ControllerSerializer serializer, ConnectionType connectionType, ClientType clientType) {
        return switch (connectionType) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionType.NEW -> Objects.requireNonNullElseGet(uuid, UUID::randomUUID);
            case ConnectionType.FIRST -> Objects.requireNonNullElseGet(serializer.listIds(clientType).peekFirst(), () -> Objects.requireNonNullElseGet(uuid, UUID::randomUUID));
            case ConnectionType.LAST -> Objects.requireNonNullElseGet(serializer.listIds(clientType).peekLast(), () -> Objects.requireNonNullElseGet(uuid, UUID::randomUUID));
        };
    }

    public T name(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (this.store != null) {
            this.store.name(name);
        }
        return (T)this;
    }

    public T version(@NonNull Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (this.store != null) {
            this.store.version(version);
        }
        return (T)this;
    }

    public T autodetectListeners(boolean autodetectListeners) {
        if (this.store != null) {
            this.store.autodetectListeners(autodetectListeners);
        }
        return (T)this;
    }

    public T textPreviewSetting(@NonNull TextPreviewSetting textPreviewSetting) {
        if (textPreviewSetting == null) {
            throw new NullPointerException("textPreviewSetting is marked non-null but is null");
        }
        if (this.store != null) {
            this.store.textPreviewSetting(textPreviewSetting);
        }
        return (T)this;
    }

    public T errorHandler(@NonNull ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        this.errorHandler = errorHandler;
        return (T)this;
    }

    public T socketExecutor(@NonNull Executor socketExecutor) {
        if (socketExecutor == null) {
            throw new NullPointerException("socketExecutor is marked non-null but is null");
        }
        this.socketExecutor = socketExecutor;
        return (T)this;
    }

    public T releaseChannel(@NonNull UserAgent.UserAgentReleaseChannel releaseChannel) {
        if (releaseChannel == null) {
            throw new NullPointerException("releaseChannel is marked non-null but is null");
        }
        if (this.store != null) {
            this.store.releaseChannel(releaseChannel);
        }
        return (T)this;
    }

    public T proxy(URI proxy) {
        if (this.store != null) {
            this.store.proxy(proxy);
        }
        return (T)this;
    }

    public T acknowledgeMessages(boolean acknowledgeMessages) {
        if (this.store != null) {
            this.store.automaticPresenceUpdates(acknowledgeMessages);
        }
        return (T)this;
    }

    public T checkPatchMacks(boolean checkPatchMacs) {
        this.store.checkPatchMacs(checkPatchMacs);
        return (T)this;
    }
}

