/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.AsyncCaptchaCodeSupplier;
import it.auties.whatsapp.api.AsyncVerificationCodeSupplier;
import it.auties.whatsapp.api.ErrorHandler;
import it.auties.whatsapp.api.Whatsapp;
import it.auties.whatsapp.controller.Keys;
import it.auties.whatsapp.controller.Store;
import it.auties.whatsapp.model.mobile.PhoneNumber;
import it.auties.whatsapp.model.mobile.VerificationCodeMethod;
import it.auties.whatsapp.model.mobile.VerificationCodeResponse;
import it.auties.whatsapp.util.RegistrationHelper;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MobileRegistrationBuilder<T extends MobileRegistrationBuilder<T>> {
    protected Whatsapp whatsapp;
    protected final Store store;
    protected final Keys keys;
    protected final ErrorHandler errorHandler;
    protected final Executor socketExecutor;
    protected AsyncVerificationCodeSupplier verificationCodeSupplier;
    protected AsyncCaptchaCodeSupplier verificationCaptchaSupplier;

    public T verificationCodeSupplier(@NonNull Supplier<String> verificationCodeSupplier) {
        if (verificationCodeSupplier == null) {
            throw new NullPointerException("verificationCodeSupplier is marked non-null but is null");
        }
        this.verificationCodeSupplier = AsyncVerificationCodeSupplier.of(verificationCodeSupplier);
        return (T)this;
    }

    public T verificationCaptchaSupplier(@NonNull Function<VerificationCodeResponse, String> verificationCaptchaSupplier) {
        if (verificationCaptchaSupplier == null) {
            throw new NullPointerException("verificationCaptchaSupplier is marked non-null but is null");
        }
        this.verificationCaptchaSupplier = AsyncCaptchaCodeSupplier.of(verificationCaptchaSupplier);
        return (T)this;
    }

    public T verificationCodeSupplier(@NonNull AsyncVerificationCodeSupplier verificationCodeSupplier) {
        if (verificationCodeSupplier == null) {
            throw new NullPointerException("verificationCodeSupplier is marked non-null but is null");
        }
        this.verificationCodeSupplier = verificationCodeSupplier;
        return (T)this;
    }

    public T verificationCaptchaSupplier(@NonNull AsyncCaptchaCodeSupplier verificationCaptchaSupplier) {
        if (verificationCaptchaSupplier == null) {
            throw new NullPointerException("verificationCaptchaSupplier is marked non-null but is null");
        }
        this.verificationCaptchaSupplier = verificationCaptchaSupplier;
        return (T)this;
    }

    protected Whatsapp buildWhatsapp() {
        this.whatsapp = Whatsapp.customBuilder().store(this.store).keys(this.keys).errorHandler(this.errorHandler).socketExecutor(this.socketExecutor).build();
        return this.whatsapp;
    }

    public MobileRegistrationBuilder(Store store, Keys keys, ErrorHandler errorHandler, Executor socketExecutor) {
        this.store = store;
        this.keys = keys;
        this.errorHandler = errorHandler;
        this.socketExecutor = socketExecutor;
    }

    public static final class Unverified
    extends MobileRegistrationBuilder<Unverified> {
        public Unverified(Store store, Keys keys, ErrorHandler errorHandler, Executor socketExecutor) {
            super(store, keys, errorHandler, socketExecutor);
        }

        public CompletableFuture<Whatsapp> verify(long phoneNumber) {
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.phoneNumber(number);
            this.store.phoneNumber(number);
            return this.verify();
        }

        public CompletableFuture<Whatsapp> verify() {
            Objects.requireNonNull(this.store.phoneNumber(), "Missing phone number: please specify it");
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            return RegistrationHelper.sendVerificationCode(this.store, this.keys, this.verificationCodeSupplier, this.verificationCaptchaSupplier).thenApply(ignored -> this.buildWhatsapp());
        }
    }

    public static final class Unregistered
    extends MobileRegistrationBuilder<Unregistered> {
        private VerificationCodeMethod verificationCodeMethod = VerificationCodeMethod.SMS;

        public Unregistered(Store store, Keys keys, ErrorHandler errorHandler, Executor socketExecutor) {
            super(store, keys, errorHandler, socketExecutor);
        }

        public Unregistered verificationCodeMethod(@NonNull VerificationCodeMethod verificationCodeMethod) {
            if (verificationCodeMethod == null) {
                throw new NullPointerException("verificationCodeMethod is marked non-null but is null");
            }
            this.verificationCodeMethod = verificationCodeMethod;
            return this;
        }

        public CompletableFuture<Whatsapp> register(long phoneNumber) {
            if (this.whatsapp != null) {
                return CompletableFuture.completedFuture(this.whatsapp);
            }
            Objects.requireNonNull(this.verificationCodeSupplier, "Expected a valid verification code supplier");
            Objects.requireNonNull(this.verificationCodeMethod, "Expected a valid verification method");
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.phoneNumber(number);
            this.store.phoneNumber(number);
            if (!this.keys.registered()) {
                return RegistrationHelper.registerPhoneNumber(this.store, this.keys, this.verificationCodeSupplier, this.verificationCaptchaSupplier, this.verificationCodeMethod).thenApply(ignored -> this.buildWhatsapp());
            }
            return CompletableFuture.completedFuture(this.buildWhatsapp());
        }

        public CompletableFuture<Unverified> requestVerificationCode(long phoneNumber) {
            PhoneNumber number = PhoneNumber.of(phoneNumber);
            this.keys.phoneNumber(number);
            this.store.phoneNumber(number);
            if (!this.keys.registered()) {
                return RegistrationHelper.requestVerificationCode(this.store, this.keys, this.verificationCodeMethod).thenApply(ignored -> new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor));
            }
            return CompletableFuture.completedFuture(new Unverified(this.store, this.keys, this.errorHandler, this.socketExecutor));
        }
    }
}

