/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp.api;

import it.auties.whatsapp.api.ClientType;
import it.auties.whatsapp.api.ConnectionType;
import it.auties.whatsapp.api.MobileOptionsBuilder;
import it.auties.whatsapp.api.OptionsBuilder;
import it.auties.whatsapp.api.WebOptionsBuilder;
import it.auties.whatsapp.controller.ControllerSerializer;
import it.auties.whatsapp.controller.DefaultControllerSerializer;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;

public final class ConnectionBuilder<T extends OptionsBuilder<T>> {
    private final ClientType clientType;
    private ControllerSerializer serializer;

    ConnectionBuilder(@NonNull ClientType clientType) {
        if (clientType == null) {
            throw new NullPointerException("clientType is marked non-null but is null");
        }
        this.clientType = clientType;
        this.serializer = DefaultControllerSerializer.instance();
    }

    public ConnectionBuilder<T> serializer(@NonNull ControllerSerializer serializer) {
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        this.serializer = serializer;
        return this;
    }

    public T newConnection() {
        return this.newConnection((UUID)null);
    }

    public T newConnection(UUID uuid) {
        return this.createConnection(uuid, ConnectionType.NEW);
    }

    public T newConnection(long phoneNumber) {
        return this.createConnection(phoneNumber);
    }

    public T newConnection(String alias) {
        return this.createConnection(alias);
    }

    public Optional<T> newOptionalConnection(UUID uuid) {
        return this.createOptionalConnection(uuid, ConnectionType.NEW);
    }

    public Optional<T> newOptionalConnection(Long phoneNumber) {
        return this.createOptionalConnection(phoneNumber);
    }

    public Optional<T> newOptionalConnection(String alias) {
        return this.createOptionalConnection(alias);
    }

    public T firstConnection() {
        return this.createConnection(null, ConnectionType.FIRST);
    }

    public Optional<T> firstOptionalConnection() {
        return this.createOptionalConnection(null, ConnectionType.FIRST);
    }

    public T lastConnection() {
        return this.createConnection(null, ConnectionType.LAST);
    }

    public Optional<T> lastOptionalConnection() {
        return this.createOptionalConnection(null, ConnectionType.LAST);
    }

    private T createConnection(UUID uuid, ConnectionType connectionType) {
        return (T)(switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.of(uuid, this.serializer, connectionType);
            case ClientType.MOBILE -> MobileOptionsBuilder.of(uuid, this.serializer, connectionType);
        });
    }

    private T createConnection(long phoneNumber) {
        return (T)(switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.of(phoneNumber, this.serializer);
            case ClientType.MOBILE -> MobileOptionsBuilder.of(phoneNumber, this.serializer);
        });
    }

    private T createConnection(String alias) {
        return (T)(switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.of(alias, this.serializer);
            case ClientType.MOBILE -> MobileOptionsBuilder.of(alias, this.serializer);
        });
    }

    private Optional<T> createOptionalConnection(UUID uuid, ConnectionType connectionType) {
        return switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.ofNullable(uuid, this.serializer, connectionType);
            case ClientType.MOBILE -> MobileOptionsBuilder.ofNullable(uuid, this.serializer, connectionType);
        };
    }

    private Optional<T> createOptionalConnection(long phoneNumber) {
        return switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.ofNullable(phoneNumber, this.serializer);
            case ClientType.MOBILE -> MobileOptionsBuilder.ofNullable(phoneNumber, this.serializer);
        };
    }

    private Optional<T> createOptionalConnection(String alias) {
        return switch (this.clientType) {
            default -> throw new IncompatibleClassChangeError();
            case ClientType.WEB -> WebOptionsBuilder.ofNullable(alias, this.serializer);
            case ClientType.MOBILE -> MobileOptionsBuilder.ofNullable(alias, this.serializer);
        };
    }
}

