/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public final class ProtobufOutputStream {
    private final ByteArrayOutputStream buffer;

    public ProtobufOutputStream(ByteArrayOutputStream buffer) {
        this.buffer = buffer;
    }

    public ProtobufOutputStream() {
        this(new ByteArrayOutputStream());
    }

    static int makeTag(int fieldNumber, int wireType) {
        return fieldNumber << 3 | wireType;
    }

    public void writeTag(int fieldNumber, int wireType) {
        this.writeUInt32NoTag(ProtobufOutputStream.makeTag(fieldNumber, wireType));
    }

    public void writeInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeInt32NoTag(value);
    }

    public void writeUInt32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeUInt32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeUInt32NoTag(value);
    }

    public void writeFloat(int fieldNumber, float value) {
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value));
    }

    public void writeFloat(int fieldNumber, Float value) {
        if (value == null) {
            return;
        }
        this.writeFixed32(fieldNumber, Float.floatToRawIntBits(value.floatValue()));
    }

    public void writeFixed32(int fieldNumber, int value) {
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeFixed32(int fieldNumber, Integer value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 5);
        this.writeFixed32NoTag(value);
    }

    public void writeInt64(int fieldNumber, long value) {
        this.writeUInt64(fieldNumber, value);
    }

    public void writeInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeUInt64(fieldNumber, value);
    }

    public void writeUInt64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeUInt64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeUInt64NoTag(value);
    }

    public void writeDouble(int fieldNumber, double value) {
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value));
    }

    public void writeDouble(int fieldNumber, Double value) {
        if (value == null) {
            return;
        }
        this.writeFixed64(fieldNumber, Double.doubleToRawLongBits(value));
    }

    public void writeFixed64(int fieldNumber, long value) {
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeFixed64(int fieldNumber, Long value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 1);
        this.writeFixed64NoTag(value);
    }

    public void writeBool(int fieldNumber, boolean value) {
        this.writeTag(fieldNumber, 0);
        this.writeRaw((byte)(value ? 1 : 0));
    }

    public void writeBool(int fieldNumber, Boolean value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 0);
        this.writeRaw((byte)(value != false ? 1 : 0));
    }

    public void writeString(int fieldNumber, String value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        this.writeStringNoTag(value);
    }

    public void writeBytes(int fieldNumber, byte[] value) {
        if (value == null) {
            return;
        }
        this.writeTag(fieldNumber, 2);
        this.writeBytesNoTag(value);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    private void writeBytesNoTag(byte[] value) {
        this.writeUInt32NoTag(value.length);
        this.writeRawBytes(value);
    }

    private void writeInt32NoTag(int value) {
        if (value >= 0) {
            this.writeUInt32NoTag(value);
        } else {
            this.writeUInt64NoTag(value);
        }
    }

    private void writeUInt32NoTag(int value) {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRaw((byte)value);
                return;
            }
            this.writeRaw((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private void writeFixed32NoTag(int value) {
        this.writeRaw((byte)(value & 0xFF));
        this.writeRaw((byte)(value >> 8 & 0xFF));
        this.writeRaw((byte)(value >> 16 & 0xFF));
        this.writeRaw((byte)(value >> 24 & 0xFF));
    }

    private void writeUInt64NoTag(long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRaw((byte)value);
                return;
            }
            this.writeRaw((byte)((int)value & 0x7F | 0x80));
            value >>>= 7;
        }
    }

    private void writeFixed64NoTag(long value) {
        this.writeRaw((byte)((int)value & 0xFF));
        this.writeRaw((byte)((int)(value >> 8) & 0xFF));
        this.writeRaw((byte)((int)(value >> 16) & 0xFF));
        this.writeRaw((byte)((int)(value >> 24) & 0xFF));
        this.writeRaw((byte)((int)(value >> 32) & 0xFF));
        this.writeRaw((byte)((int)(value >> 40) & 0xFF));
        this.writeRaw((byte)((int)(value >> 48) & 0xFF));
        this.writeRaw((byte)((int)(value >> 56) & 0xFF));
    }

    private void writeStringNoTag(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeUInt32NoTag(bytes.length);
        this.writeRawBytes(bytes);
    }

    private void writeRaw(byte value) {
        this.buffer.write(value);
    }

    private void writeRawBytes(byte[] value) {
        try {
            this.buffer.write(value);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Cannot write bytes to stream", exception);
        }
    }
}

