/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network;

import com.flowpowered.network.BasicChannelInitializer;
import com.flowpowered.network.ConnectionManager;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public abstract class NetworkClient
implements ConnectionManager {
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();

    public NetworkClient() {
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new BasicChannelInitializer(this));
    }

    public ChannelFuture connect(final SocketAddress address) {
        return this.bootstrap.connect(address).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> f) throws Exception {
                if (f.isSuccess()) {
                    NetworkClient.this.onConnectSuccess(address);
                } else {
                    NetworkClient.this.onConnectFailure(address, f.cause());
                }
            }
        });
    }

    public <T> void preConnectOption(ChannelOption<T> option, T value) {
        this.bootstrap.option(option, value);
    }

    public void onConnectSuccess(SocketAddress address) {
    }

    public void onConnectFailure(SocketAddress address, Throwable t) {
    }

    @Override
    public void shutdown() {
        this.workerGroup.shutdownGracefully();
    }
}

