/*
 * Decompiled with CFR 0.152.
 */
package discord4j.store.api.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class LongObjTuple2<T>
implements Iterable<Object>,
Comparable<LongObjTuple2<T>> {
    private static final long serialVersionUID = 6977984978741213834L;
    final long t1;
    @NonNull
    final T t2;

    public static <T> LongObjTuple2<T> of(long t1, T t2) {
        return new LongObjTuple2<T>(t1, t2);
    }

    public static <T> LongObjTuple2<T> from(Tuple2<Long, T> tuple2) {
        return LongObjTuple2.of((Long)tuple2.getT1(), tuple2.getT2());
    }

    public static <T> Tuple2<Long, T> convert(LongObjTuple2<T> tuple) {
        return Tuples.of((Object)tuple.getT1(), tuple.getT2());
    }

    @JsonCreator
    LongObjTuple2(@JsonProperty(value="t1") long t1, @JsonProperty(value="t2") T t2) {
        this.t1 = t1;
        this.t2 = Objects.requireNonNull(t2, "t2");
    }

    public long getT1() {
        return this.t1;
    }

    public T getT2() {
        return this.t2;
    }

    @Nullable
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.t1;
            }
            case 1: {
                return this.t2;
            }
        }
        return null;
    }

    public List<Object> toList() {
        return Arrays.asList(this.toArray());
    }

    public Object[] toArray() {
        return new Object[]{this.t1, this.t2};
    }

    @Override
    public Iterator<Object> iterator() {
        return Collections.unmodifiableList(this.toList()).iterator();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && !o.getClass().equals(Tuple2.class)) {
            return false;
        }
        if (o.getClass().equals(Tuple2.class)) {
            Tuple2 tuple2 = (Tuple2)o;
            return tuple2.getT1().equals(this.t1) && this.t2.equals(tuple2.getT2());
        }
        LongObjTuple2 tuple2 = (LongObjTuple2)o;
        return tuple2.t1 == this.t1 && this.t2.equals(tuple2.getT2());
    }

    public int hashCode() {
        int result = this.size();
        result = 31 * result + Long.hashCode(this.t1);
        result = 31 * result + this.t2.hashCode();
        return result;
    }

    public int size() {
        return 2;
    }

    public final String toString() {
        return LongObjTuple2.tupleStringRepresentation(this.toArray()).insert(0, '[').append(']').toString();
    }

    static StringBuilder tupleStringRepresentation(Object ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            Object t = values[i];
            if (i != 0) {
                sb.append(',');
            }
            if (t == null) continue;
            sb.append(t);
        }
        return sb;
    }

    @Override
    public int compareTo(LongObjTuple2<T> o) {
        if (o.t1 != this.t1) {
            return this.t1 < o.t1 ? -1 : 1;
        }
        if (this.t2 instanceof Comparable) {
            return ((Comparable)this.t2).compareTo(o.t2);
        }
        return 0;
    }
}

