/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.common.ReactorResources;
import reactor.core.scheduler.Scheduler;
import reactor.netty.http.client.HttpClient;
import reactor.netty.udp.UdpClient;

public class VoiceReactorResources
extends ReactorResources {
    private final UdpClient udpClient;
    private final Scheduler sendTaskScheduler;
    private final Scheduler receiveTaskScheduler;

    public VoiceReactorResources(ReactorResources parent) {
        super(parent.getHttpClient(), parent.getTimerTaskScheduler(), parent.getBlockingTaskScheduler());
        this.udpClient = UdpClient.create();
        this.sendTaskScheduler = parent.getTimerTaskScheduler();
        this.receiveTaskScheduler = parent.getTimerTaskScheduler();
    }

    public VoiceReactorResources(ReactorResources parent, UdpClient udpClient, Scheduler sendTaskScheduler, Scheduler receiveTaskScheduler) {
        super(parent.getHttpClient(), parent.getTimerTaskScheduler(), parent.getBlockingTaskScheduler());
        this.udpClient = udpClient;
        this.sendTaskScheduler = sendTaskScheduler;
        this.receiveTaskScheduler = receiveTaskScheduler;
    }

    public VoiceReactorResources(HttpClient httpClient, Scheduler timerTaskScheduler, Scheduler blockingTaskScheduler, UdpClient udpClient, Scheduler sendTaskScheduler, Scheduler receiveTaskScheduler) {
        super(httpClient, timerTaskScheduler, blockingTaskScheduler);
        this.udpClient = udpClient;
        this.sendTaskScheduler = sendTaskScheduler;
        this.receiveTaskScheduler = receiveTaskScheduler;
    }

    protected VoiceReactorResources(Builder builder) {
        super((ReactorResources.Builder)builder);
        this.udpClient = builder.udpClient == null ? UdpClient.create() : builder.udpClient;
        this.sendTaskScheduler = builder.sendTaskScheduler == null ? (Scheduler)DEFAULT_TIMER_TASK_SCHEDULER.get() : builder.sendTaskScheduler;
        this.receiveTaskScheduler = builder.receiveTaskScheduler == null ? (Scheduler)DEFAULT_TIMER_TASK_SCHEDULER.get() : builder.receiveTaskScheduler;
    }

    public static VoiceReactorResources create() {
        return new VoiceReactorResources(new ReactorResources());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReactorResources reactorResources) {
        return VoiceReactorResources.builder().httpClient(reactorResources.getHttpClient()).timerTaskScheduler(reactorResources.getTimerTaskScheduler()).blockingTaskScheduler(reactorResources.getBlockingTaskScheduler());
    }

    public Builder mutate() {
        return new Builder().httpClient(this.getHttpClient()).timerTaskScheduler(this.getTimerTaskScheduler()).blockingTaskScheduler(this.getBlockingTaskScheduler()).udpClient(this.getUdpClient()).sendTaskScheduler(this.getSendTaskScheduler()).receiveTaskScheduler(this.getReceiveTaskScheduler());
    }

    public UdpClient getUdpClient() {
        return this.udpClient;
    }

    public Scheduler getSendTaskScheduler() {
        return this.sendTaskScheduler;
    }

    public Scheduler getReceiveTaskScheduler() {
        return this.receiveTaskScheduler;
    }

    public static class Builder
    extends ReactorResources.Builder {
        private UdpClient udpClient;
        private Scheduler sendTaskScheduler;
        private Scheduler receiveTaskScheduler;

        protected Builder() {
        }

        public Builder udpClient(UdpClient udpClient) {
            this.udpClient = udpClient;
            return this;
        }

        public Builder sendTaskScheduler(Scheduler sendTaskScheduler) {
            this.sendTaskScheduler = sendTaskScheduler;
            return this;
        }

        public Builder receiveTaskScheduler(Scheduler receiveTaskScheduler) {
            this.receiveTaskScheduler = receiveTaskScheduler;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            super.httpClient(httpClient);
            return this;
        }

        public Builder timerTaskScheduler(Scheduler timerTaskScheduler) {
            super.timerTaskScheduler(timerTaskScheduler);
            return this;
        }

        public Builder blockingTaskScheduler(Scheduler blockingTaskScheduler) {
            super.blockingTaskScheduler(blockingTaskScheduler);
            return this;
        }

        public VoiceReactorResources build() {
            return new VoiceReactorResources(this);
        }
    }
}

