/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.core.spec.legacy.LegacyEmbedCreateSpec;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class LegacyWebhookExecuteSpec
implements LegacySpec<MultipartRequest<WebhookExecuteRequest>> {
    private Possible<String> content = Possible.absent();
    private Possible<String> username = Possible.absent();
    private Possible<String> avatarUrl = Possible.absent();
    private Possible<Boolean> tts = Possible.absent();
    private List<Tuple2<String, InputStream>> files = null;
    private List<EmbedData> embeds = null;
    private Possible<AllowedMentionsData> allowedMentions = Possible.absent();

    public LegacyWebhookExecuteSpec setContent(String content) {
        this.content = Possible.of((Object)content);
        return this;
    }

    public LegacyWebhookExecuteSpec setUsername(String username) {
        this.username = Possible.of((Object)username);
        return this;
    }

    public LegacyWebhookExecuteSpec setAvatarUrl(String avatarUrl) {
        this.avatarUrl = Possible.of((Object)avatarUrl);
        return this;
    }

    public LegacyWebhookExecuteSpec setTts(boolean tts) {
        this.tts = Possible.of((Object)tts);
        return this;
    }

    public LegacyWebhookExecuteSpec addFile(String fileName, InputStream file) {
        if (this.files == null) {
            this.files = new ArrayList<Tuple2<String, InputStream>>(1);
        }
        this.files.add((Tuple2<String, InputStream>)Tuples.of((Object)fileName, (Object)file));
        return this;
    }

    public LegacyWebhookExecuteSpec addFileSpoiler(String fileName, InputStream file) {
        return this.addFile("SPOILER_" + fileName, file);
    }

    public LegacyWebhookExecuteSpec addEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        LegacyEmbedCreateSpec mutatedSpec = new LegacyEmbedCreateSpec();
        spec.accept(mutatedSpec);
        if (this.embeds == null) {
            this.embeds = new ArrayList<EmbedData>(1);
        }
        this.embeds.add(mutatedSpec.asRequest());
        return this;
    }

    public LegacyWebhookExecuteSpec setAllowedMentions(AllowedMentions allowedMentions) {
        this.allowedMentions = Possible.of((Object)allowedMentions.toData());
        return this;
    }

    @Override
    public MultipartRequest<WebhookExecuteRequest> asRequest() {
        return MultipartRequest.ofRequestAndFiles((Object)WebhookExecuteRequest.builder().content(this.content).username(this.username).avatarUrl(this.avatarUrl).tts(this.tts).embeds(this.embeds == null ? Possible.absent() : Possible.of(this.embeds)).allowedMentions(this.allowedMentions).build(), this.files == null ? Collections.emptyList() : this.files);
    }
}

