/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.LogUtil;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.VoiceServerUpdateEvent;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.LocalVoiceReceiveTaskFactory;
import discord4j.voice.LocalVoiceSendTaskFactory;
import discord4j.voice.VoiceChannelRetrieveTask;
import discord4j.voice.VoiceConnection;
import discord4j.voice.VoiceDisconnectTask;
import discord4j.voice.VoiceGatewayOptions;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import discord4j.voice.VoiceServerOptions;
import discord4j.voice.VoiceServerUpdateTask;
import discord4j.voice.VoiceStateUpdateTask;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.ContextView;
import reactor.util.retry.RetrySpec;

public class LegacyVoiceChannelJoinSpec
implements LegacySpec<Mono<VoiceConnection>> {
    private static final Logger log = Loggers.getLogger(LegacyVoiceChannelJoinSpec.class);
    private static final int DEFAULT_TIMEOUT = 10;
    private static final int DEFAULT_DISCOVERY_TIMEOUT = 5;
    private Duration timeout = Duration.ofSeconds(10L);
    private AudioProvider provider = AudioProvider.NO_OP;
    private AudioReceiver receiver = AudioReceiver.NO_OP;
    private VoiceSendTaskFactory sendTaskFactory = new LocalVoiceSendTaskFactory();
    private VoiceReceiveTaskFactory receiveTaskFactory = new LocalVoiceReceiveTaskFactory();
    private boolean selfDeaf;
    private boolean selfMute;
    private Duration ipDiscoveryTimeout = Duration.ofSeconds(5L);
    private RetrySpec LegacyipDiscoveryRetrySpec = RetrySpec.maxInARow((long)1L);
    private final GatewayDiscordClient gateway;
    private final VoiceChannel voiceChannel;

    public LegacyVoiceChannelJoinSpec(GatewayDiscordClient gateway, VoiceChannel voiceChannel) {
        this.gateway = Objects.requireNonNull(gateway);
        this.voiceChannel = voiceChannel;
    }

    public LegacyVoiceChannelJoinSpec setProvider(AudioProvider provider) {
        this.provider = provider;
        return this;
    }

    @Deprecated
    public LegacyVoiceChannelJoinSpec setReceiver(AudioReceiver receiver) {
        this.receiver = receiver;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
        this.sendTaskFactory = sendTaskFactory;
        return this;
    }

    @Deprecated
    public LegacyVoiceChannelJoinSpec setReceiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
        this.receiveTaskFactory = receiveTaskFactory;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSelfDeaf(boolean selfDeaf) {
        this.selfDeaf = selfDeaf;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setSelfMute(boolean selfMute) {
        this.selfMute = selfMute;
        return this;
    }

    public LegacyVoiceChannelJoinSpec setTimeout(Duration timeout) {
        this.timeout = Objects.requireNonNull(timeout);
        return this;
    }

    public LegacyVoiceChannelJoinSpec setIpDiscoveryTimeout(Duration ipDiscoveryTimeout) {
        this.ipDiscoveryTimeout = Objects.requireNonNull(ipDiscoveryTimeout);
        return this;
    }

    public LegacyVoiceChannelJoinSpec LegacysetIpDiscoveryRetrySpec(RetrySpec LegacyipDiscoveryRetrySpec) {
        this.LegacyipDiscoveryRetrySpec = Objects.requireNonNull(LegacyipDiscoveryRetrySpec);
        return this;
    }

    @Override
    public Mono<VoiceConnection> asRequest() {
        if (!this.gateway.getGatewayResources().getIntents().contains((Object)Intent.GUILD_VOICE_STATES)) {
            return Mono.error((Throwable)new IllegalArgumentException("GUILD_VOICE_STATES intent is required to establish a voice connection"));
        }
        Snowflake guildId = this.voiceChannel.getGuildId();
        Snowflake channelId = this.voiceChannel.getId();
        GatewayClientGroup clientGroup = this.voiceChannel.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(guildId);
        Mono sendVoiceStateUpdate = clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate((VoiceStateUpdate)VoiceStateUpdate.builder().guildId(guildId.asString()).channelId(channelId.asString()).selfMute(this.selfMute).selfDeaf(this.selfDeaf).build(), (int)shardId));
        Mono waitForVoiceStateUpdate = LegacyVoiceChannelJoinSpec.onVoiceStateUpdates(this.gateway, guildId).next();
        Mono<VoiceServerUpdateEvent> waitForVoiceServerUpdate = LegacyVoiceChannelJoinSpec.onVoiceServerUpdate(this.gateway, guildId);
        VoiceDisconnectTask disconnectTask = id -> this.voiceChannel.sendDisconnectVoiceState().then(this.gateway.getVoiceConnectionRegistry().disconnect(id));
        VoiceServerUpdateTask serverUpdateTask = id -> LegacyVoiceChannelJoinSpec.onVoiceServerUpdate(this.gateway, id).map(vsu -> new VoiceServerOptions(vsu.getToken(), vsu.getEndpoint()));
        VoiceStateUpdateTask stateUpdateTask = id -> LegacyVoiceChannelJoinSpec.onVoiceStateUpdates(this.gateway, id).map(stateUpdateEvent -> stateUpdateEvent.getCurrent().getSessionId());
        VoiceChannelRetrieveTask channelRetrieveTask = () -> this.gateway.getMemberById(this.voiceChannel.getGuildId(), this.gateway.getSelfId()).flatMap(PartialMember::getVoiceState).flatMap(voiceState -> Mono.justOrEmpty(voiceState.getChannelId()));
        Mono newConnection = sendVoiceStateUpdate.then(Mono.zip((Mono)waitForVoiceStateUpdate, waitForVoiceServerUpdate)).flatMap(TupleUtils.function((voiceState, voiceServer) -> {
            String session = voiceState.getCurrent().getSessionId();
            VoiceServerOptions voiceServerOptions = new VoiceServerOptions(voiceServer.getToken(), voiceServer.getEndpoint());
            VoiceGatewayOptions voiceGatewayOptions = new VoiceGatewayOptions(guildId, this.gateway.getSelfId(), session, voiceServerOptions, this.gateway.getCoreResources().getJacksonResources(), this.gateway.getGatewayResources().getVoiceReactorResources(), this.gateway.getGatewayResources().getVoiceReconnectOptions(), this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, disconnectTask, serverUpdateTask, stateUpdateTask, channelRetrieveTask, this.ipDiscoveryTimeout, this.LegacyipDiscoveryRetrySpec);
            return this.gateway.getVoiceConnectionFactory().create(voiceGatewayOptions).flatMap(vc -> this.gateway.getVoiceConnectionRegistry().registerVoiceConnection(guildId, vc).thenReturn(vc)).doOnEach(signal -> {
                if (signal.isOnSubscribe()) {
                    log.debug(LogUtil.format((ContextView)signal.getContextView(), (String)"Creating voice connection"));
                }
            }).contextWrite(ctx -> ctx.put((Object)"discord4j.gateway", (Object)Integer.toHexString(this.gateway.hashCode())).put((Object)"discord4j.shard", (Object)shardId).put((Object)"discord4j.guild", (Object)guildId.asLong()));
        })).timeout(this.timeout).doFinally(signal -> log.debug("Voice connection handshake to guild {} done after {}", new Object[]{guildId.asLong(), signal})).onErrorResume(TimeoutException.class, t -> this.gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).switchIfEmpty(this.voiceChannel.sendDisconnectVoiceState().then(Mono.error((Throwable)t))));
        return this.gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).flatMap(existing -> sendVoiceStateUpdate.then(waitForVoiceStateUpdate).thenReturn(existing)).switchIfEmpty(newConnection);
    }

    static Flux<VoiceStateUpdateEvent> onVoiceStateUpdates(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceStateUpdateEvent.class).filter(vsu -> {
            Snowflake vsuUser = vsu.getCurrent().getUserId();
            Snowflake vsuGuild = vsu.getCurrent().getGuildId();
            return vsuUser.equals((Object)gateway.getSelfId()) && vsuGuild.equals((Object)guildId);
        });
    }

    static Mono<VoiceServerUpdateEvent> onVoiceServerUpdate(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceServerUpdateEvent.class).filter(vsu -> vsu.getGuildId().equals((Object)guildId) && vsu.getEndpoint() != null).next();
    }
}

