/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.legacy.LegacyEmbedCreateSpec;
import discord4j.core.spec.legacy.LegacyMessageReferenceSpec;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.ImmutableMessageCreateRequest;
import discord4j.discordjson.json.MessageCreateRequest;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class LegacyMessageCreateSpec
implements LegacySpec<MultipartRequest<MessageCreateRequest>> {
    @Nullable
    private String content;
    @Nullable
    private String nonce;
    private boolean tts;
    private List<EmbedData> embeds;
    private List<Tuple2<String, InputStream>> files;
    private AllowedMentionsData allowedMentionsData;
    private MessageReferenceData messageReferenceData;
    private List<LayoutComponent> components;

    public LegacyMessageCreateSpec setContent(String content) {
        this.content = content;
        return this;
    }

    public LegacyMessageCreateSpec setNonce(Snowflake nonce) {
        this.nonce = nonce.asString();
        return this;
    }

    public LegacyMessageCreateSpec setTts(boolean tts) {
        this.tts = tts;
        return this;
    }

    @Deprecated
    public LegacyMessageCreateSpec setEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        LegacyEmbedCreateSpec mutatedSpec = new LegacyEmbedCreateSpec();
        spec.accept(mutatedSpec);
        this.embeds = Collections.singletonList(mutatedSpec.asRequest());
        return this;
    }

    public LegacyMessageCreateSpec addEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        LegacyEmbedCreateSpec mutatedSpec = new LegacyEmbedCreateSpec();
        spec.accept(mutatedSpec);
        if (this.embeds == null) {
            this.embeds = new ArrayList<EmbedData>(1);
        }
        this.embeds.add(mutatedSpec.asRequest());
        return this;
    }

    public LegacyMessageCreateSpec addFile(String fileName, InputStream file) {
        if (this.files == null) {
            this.files = new ArrayList<Tuple2<String, InputStream>>(1);
        }
        this.files.add((Tuple2<String, InputStream>)Tuples.of((Object)fileName, (Object)file));
        return this;
    }

    public LegacyMessageCreateSpec addFileSpoiler(String fileName, InputStream file) {
        return this.addFile("SPOILER_" + fileName, file);
    }

    public LegacyMessageCreateSpec setAllowedMentions(@Nullable AllowedMentions allowedMentions) {
        this.allowedMentionsData = allowedMentions != null ? allowedMentions.toData() : null;
        return this;
    }

    public LegacyMessageCreateSpec setMessageReference(Snowflake messageId) {
        LegacyMessageReferenceSpec spec = new LegacyMessageReferenceSpec();
        spec.setMessageId(messageId);
        this.messageReferenceData = spec.asRequest();
        return this;
    }

    public LegacyMessageCreateSpec setComponents(LayoutComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    public LegacyMessageCreateSpec setComponents(List<LayoutComponent> components) {
        this.components = components;
        return this;
    }

    @Override
    public MultipartRequest<MessageCreateRequest> asRequest() {
        ImmutableMessageCreateRequest json = MessageCreateRequest.builder().content(this.content == null ? Possible.absent() : Possible.of((Object)this.content)).nonce(this.nonce == null ? Possible.absent() : Possible.of((Object)this.nonce)).tts(Boolean.valueOf(this.tts)).embeds(this.embeds == null ? Possible.absent() : Possible.of(this.embeds)).allowedMentions(this.allowedMentionsData == null ? Possible.absent() : Possible.of((Object)this.allowedMentionsData)).messageReference(this.messageReferenceData == null ? Possible.absent() : Possible.of((Object)this.messageReferenceData)).components(this.components == null ? Possible.absent() : Possible.of(this.components.stream().map(MessageComponent::getData).collect(Collectors.toList()))).build();
        return MultipartRequest.ofRequestAndFiles((Object)json, this.files == null ? Collections.emptyList() : this.files);
    }
}

