/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.ImmutableWebhookExecuteRequest;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface WebhookExecuteSpecGenerator
extends Spec<MultipartRequest<WebhookExecuteRequest>> {
    public Possible<String> content();

    public Possible<String> username();

    public Possible<String> avatarUrl();

    @Value.Default
    default public boolean tts() {
        return false;
    }

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<EmbedCreateSpec> embeds() {
        return Collections.emptyList();
    }

    public Possible<AllowedMentions> allowedMentions();

    public Possible<List<LayoutComponent>> components();

    @Override
    default public MultipartRequest<WebhookExecuteRequest> asRequest() {
        ImmutableWebhookExecuteRequest request = WebhookExecuteRequest.builder().content(this.content()).username(this.username()).avatarUrl(this.avatarUrl()).tts(Boolean.valueOf(this.tts())).embeds(this.embeds().stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList())).allowedMentions(InternalSpecUtils.mapPossible(this.allowedMentions(), AllowedMentions::toData)).components(InternalSpecUtils.mapPossible(this.components(), components -> components.stream().map(MessageComponent::getData).collect(Collectors.toList()))).build();
        return MultipartRequest.ofRequestAndFiles((Object)request, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

