/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.WebhookExecuteSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="WebhookExecuteSpecGenerator", generator="Immutables")
public final class WebhookExecuteSpec
implements WebhookExecuteSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String username_value;
    private final boolean username_absent;
    private final String avatarUrl_value;
    private final boolean avatarUrl_absent;
    private final boolean tts;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final List<EmbedCreateSpec> embeds;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final WebhookExecuteSpec INSTANCE = WebhookExecuteSpec.validate(new WebhookExecuteSpec());

    private WebhookExecuteSpec() {
        Possible content$impl = Possible.absent();
        Possible username$impl = Possible.absent();
        Possible avatarUrl$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookExecuteSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible username$impl = builder.username_build();
        Possible avatarUrl$impl = builder.avatarUrl_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible components$impl = builder.components_build();
        if (builder.ttsIsSet()) {
            this.initShim.tts(builder.tts);
        }
        if (builder.filesIsSet()) {
            this.initShim.files(WebhookExecuteSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(WebhookExecuteSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        if (builder.embedsIsSet()) {
            this.initShim.embeds(WebhookExecuteSpec.createUnmodifiableList(true, builder.embeds));
        }
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookExecuteSpec(Possible<String> content, Possible<String> username, Possible<String> avatarUrl, boolean tts, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, List<EmbedCreateSpec> embeds, Possible<AllowedMentions> allowedMentions, Possible<List<LayoutComponent>> components) {
        Possible<String> content$impl = content;
        Possible<String> username$impl = username;
        Possible<String> avatarUrl$impl = avatarUrl;
        this.initShim.tts(tts);
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        this.initShim.embeds(embeds);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<LayoutComponent>> components$impl = components;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private boolean ttsInitialize() {
        return WebhookExecuteSpecGenerator.super.tts();
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return WebhookExecuteSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return WebhookExecuteSpecGenerator.super.fileSpoilers();
    }

    private List<EmbedCreateSpec> embedsInitialize() {
        return WebhookExecuteSpecGenerator.super.embeds();
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> username() {
        return this.username_absent ? Possible.absent() : Possible.of((Object)this.username_value);
    }

    @Override
    public Possible<String> avatarUrl() {
        return this.avatarUrl_absent ? Possible.absent() : Possible.of((Object)this.avatarUrl_value);
    }

    @Override
    public boolean tts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tts() : this.tts;
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public List<EmbedCreateSpec> embeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeds() : this.embeds;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public WebhookExecuteSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec((Possible<String>)newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withUsername(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withUsername(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), (Possible<String>)newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withAvatarUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withAvatarUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), (Possible<String>)newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withTts(boolean value) {
        if (this.tts == value) {
            return this;
        }
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), value, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withEmbeds(EmbedCreateSpec ... elements) {
        List<EmbedCreateSpec> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components()));
    }

    public final WebhookExecuteSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedCreateSpec> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components()));
    }

    public WebhookExecuteSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
    }

    public WebhookExecuteSpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, (Possible<AllowedMentions>)newValue, this.components()));
    }

    public WebhookExecuteSpec withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
    }

    public WebhookExecuteSpec withComponents(Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue));
    }

    @SafeVarargs
    public final WebhookExecuteSpec withComponents(LayoutComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookExecuteSpec && this.equalTo(0, (WebhookExecuteSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookExecuteSpec another) {
        return this.content().equals(another.content()) && this.username().equals(another.username()) && this.avatarUrl().equals(another.avatarUrl()) && this.tts == another.tts && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.embeds.equals(another.embeds) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.username().hashCode();
        h += (h << 5) + this.avatarUrl().hashCode();
        h += (h << 5) + Boolean.hashCode(this.tts);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.embeds.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        return h;
    }

    public String toString() {
        return "WebhookExecuteSpec{content=" + this.content().toString() + ", username=" + this.username().toString() + ", avatarUrl=" + this.avatarUrl().toString() + ", tts=" + this.tts + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", embeds=" + this.embeds + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static WebhookExecuteSpec create() {
        return INSTANCE;
    }

    private static WebhookExecuteSpec validate(WebhookExecuteSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static WebhookExecuteSpec copyOf(WebhookExecuteSpecGenerator instance) {
        if (instance instanceof WebhookExecuteSpec) {
            return (WebhookExecuteSpec)instance;
        }
        return WebhookExecuteSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isUsernamePresent() {
        return !this.username_absent;
    }

    public String usernameOrElse(String defaultValue) {
        return !this.username_absent ? this.username_value : defaultValue;
    }

    public boolean isAvatarUrlPresent() {
        return !this.avatarUrl_absent;
    }

    public String avatarUrlOrElse(String defaultValue) {
        return !this.avatarUrl_absent ? this.avatarUrl_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WebhookExecuteSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_TTS = 1L;
        private static final long OPT_BIT_FILES = 2L;
        private static final long OPT_BIT_FILE_SPOILERS = 4L;
        private static final long OPT_BIT_EMBEDS = 8L;
        private long optBits;
        private Possible<String> content_possible = Possible.absent();
        private Possible<String> username_possible = Possible.absent();
        private Possible<String> avatarUrl_possible = Possible.absent();
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;
        private boolean tts;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();
        private List<EmbedCreateSpec> embeds = new ArrayList<EmbedCreateSpec>();

        private Builder() {
        }

        public final Builder from(WebhookExecuteSpec instance) {
            return this.from((WebhookExecuteSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(WebhookExecuteSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.username(instance.username());
            this.avatarUrl(instance.avatarUrl());
            this.tts(instance.tts());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.addAllEmbeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder username(Possible<String> value) {
            this.username_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder username(String value) {
            this.username_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatarUrl(Possible<String> value) {
            this.avatarUrl_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatarUrl(String value) {
            this.avatarUrl_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tts(boolean tts) {
            this.tts = tts;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        @CanIgnoreReturnValue
        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbed(EmbedCreateSpec element) {
            this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEmbeds(EmbedCreateSpec ... elements) {
            for (EmbedCreateSpec element : elements) {
                this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            }
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
            this.embeds.clear();
            return this.addAllEmbeds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
            for (EmbedCreateSpec embedCreateSpec : elements) {
                this.embeds.add(Objects.requireNonNull(embedCreateSpec, "embeds element"));
            }
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<List<LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public WebhookExecuteSpec build() {
            return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this));
        }

        private boolean ttsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean filesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean embedsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<String> username_build() {
            return this.username_possible;
        }

        private Possible<String> avatarUrl_build() {
            return this.avatarUrl_possible;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }

    @Generated(from="WebhookExecuteSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte ttsBuildStage = 0;
        private boolean tts;
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;
        private byte embedsBuildStage = 0;
        private List<EmbedCreateSpec> embeds;

        private InitShim() {
        }

        boolean tts() {
            if (this.ttsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ttsBuildStage == 0) {
                this.ttsBuildStage = (byte)-1;
                this.tts = WebhookExecuteSpec.this.ttsInitialize();
                this.ttsBuildStage = 1;
            }
            return this.tts;
        }

        void tts(boolean tts) {
            this.tts = tts;
            this.ttsBuildStage = 1;
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        List<EmbedCreateSpec> embeds() {
            if (this.embedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embedsBuildStage == 0) {
                this.embedsBuildStage = (byte)-1;
                this.embeds = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.embedsInitialize(), true, false));
                this.embedsBuildStage = 1;
            }
            return this.embeds;
        }

        void embeds(List<EmbedCreateSpec> embeds) {
            this.embeds = embeds;
            this.embedsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ttsBuildStage == -1) {
                attributes.add("tts");
            }
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            if (this.embedsBuildStage == -1) {
                attributes.add("embeds");
            }
            return "Cannot build WebhookExecuteSpec, attribute initializers form cycle " + attributes;
        }
    }
}

