/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.VoiceChannelJoinSpecGenerator;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.retry.RetrySpec;

@Generated(from="VoiceChannelJoinSpecGenerator", generator="Immutables")
public final class VoiceChannelJoinSpec
implements VoiceChannelJoinSpecGenerator {
    private final Duration timeout;
    private final AudioProvider provider;
    private final AudioReceiver receiver;
    private final VoiceSendTaskFactory sendTaskFactory;
    private final VoiceReceiveTaskFactory receiveTaskFactory;
    private final boolean selfDeaf;
    private final boolean selfMute;
    private final Duration ipDiscoveryTimeout;
    private final RetrySpec ipDiscoveryRetrySpec;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final VoiceChannelJoinSpec INSTANCE = VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec());

    private VoiceChannelJoinSpec() {
        this.timeout = this.initShim.timeout();
        this.provider = this.initShim.provider();
        this.receiver = this.initShim.receiver();
        this.sendTaskFactory = this.initShim.sendTaskFactory();
        this.receiveTaskFactory = this.initShim.receiveTaskFactory();
        this.selfDeaf = this.initShim.selfDeaf();
        this.selfMute = this.initShim.selfMute();
        this.ipDiscoveryTimeout = this.initShim.ipDiscoveryTimeout();
        this.ipDiscoveryRetrySpec = this.initShim.ipDiscoveryRetrySpec();
        this.initShim = null;
    }

    private VoiceChannelJoinSpec(Builder builder) {
        if (builder.timeout != null) {
            this.initShim.timeout(builder.timeout);
        }
        if (builder.provider != null) {
            this.initShim.provider(builder.provider);
        }
        if (builder.receiver != null) {
            this.initShim.receiver(builder.receiver);
        }
        if (builder.sendTaskFactory != null) {
            this.initShim.sendTaskFactory(builder.sendTaskFactory);
        }
        if (builder.receiveTaskFactory != null) {
            this.initShim.receiveTaskFactory(builder.receiveTaskFactory);
        }
        if (builder.selfDeafIsSet()) {
            this.initShim.selfDeaf(builder.selfDeaf);
        }
        if (builder.selfMuteIsSet()) {
            this.initShim.selfMute(builder.selfMute);
        }
        if (builder.ipDiscoveryTimeout != null) {
            this.initShim.ipDiscoveryTimeout(builder.ipDiscoveryTimeout);
        }
        if (builder.ipDiscoveryRetrySpec != null) {
            this.initShim.ipDiscoveryRetrySpec(builder.ipDiscoveryRetrySpec);
        }
        this.timeout = this.initShim.timeout();
        this.provider = this.initShim.provider();
        this.receiver = this.initShim.receiver();
        this.sendTaskFactory = this.initShim.sendTaskFactory();
        this.receiveTaskFactory = this.initShim.receiveTaskFactory();
        this.selfDeaf = this.initShim.selfDeaf();
        this.selfMute = this.initShim.selfMute();
        this.ipDiscoveryTimeout = this.initShim.ipDiscoveryTimeout();
        this.ipDiscoveryRetrySpec = this.initShim.ipDiscoveryRetrySpec();
        this.initShim = null;
    }

    private VoiceChannelJoinSpec(Duration timeout, AudioProvider provider, AudioReceiver receiver, VoiceSendTaskFactory sendTaskFactory, VoiceReceiveTaskFactory receiveTaskFactory, boolean selfDeaf, boolean selfMute, Duration ipDiscoveryTimeout, RetrySpec ipDiscoveryRetrySpec) {
        this.timeout = timeout;
        this.provider = provider;
        this.receiver = receiver;
        this.sendTaskFactory = sendTaskFactory;
        this.receiveTaskFactory = receiveTaskFactory;
        this.selfDeaf = selfDeaf;
        this.selfMute = selfMute;
        this.ipDiscoveryTimeout = ipDiscoveryTimeout;
        this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
        this.initShim = null;
    }

    private Duration timeoutInitialize() {
        return VoiceChannelJoinSpecGenerator.super.timeout();
    }

    private AudioProvider providerInitialize() {
        return VoiceChannelJoinSpecGenerator.super.provider();
    }

    private AudioReceiver receiverInitialize() {
        return VoiceChannelJoinSpecGenerator.super.receiver();
    }

    private VoiceSendTaskFactory sendTaskFactoryInitialize() {
        return VoiceChannelJoinSpecGenerator.super.sendTaskFactory();
    }

    private VoiceReceiveTaskFactory receiveTaskFactoryInitialize() {
        return VoiceChannelJoinSpecGenerator.super.receiveTaskFactory();
    }

    private boolean selfDeafInitialize() {
        return VoiceChannelJoinSpecGenerator.super.selfDeaf();
    }

    private boolean selfMuteInitialize() {
        return VoiceChannelJoinSpecGenerator.super.selfMute();
    }

    private Duration ipDiscoveryTimeoutInitialize() {
        return VoiceChannelJoinSpecGenerator.super.ipDiscoveryTimeout();
    }

    private RetrySpec ipDiscoveryRetrySpecInitialize() {
        return VoiceChannelJoinSpecGenerator.super.ipDiscoveryRetrySpec();
    }

    @Override
    public Duration timeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.timeout() : this.timeout;
    }

    @Override
    public AudioProvider provider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.provider() : this.provider;
    }

    @Override
    @Deprecated
    public AudioReceiver receiver() {
        InitShim shim = this.initShim;
        return shim != null ? shim.receiver() : this.receiver;
    }

    @Override
    public VoiceSendTaskFactory sendTaskFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sendTaskFactory() : this.sendTaskFactory;
    }

    @Override
    @Deprecated
    public VoiceReceiveTaskFactory receiveTaskFactory() {
        InitShim shim = this.initShim;
        return shim != null ? shim.receiveTaskFactory() : this.receiveTaskFactory;
    }

    @Override
    public boolean selfDeaf() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selfDeaf() : this.selfDeaf;
    }

    @Override
    public boolean selfMute() {
        InitShim shim = this.initShim;
        return shim != null ? shim.selfMute() : this.selfMute;
    }

    @Override
    public Duration ipDiscoveryTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ipDiscoveryTimeout() : this.ipDiscoveryTimeout;
    }

    @Override
    public RetrySpec ipDiscoveryRetrySpec() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ipDiscoveryRetrySpec() : this.ipDiscoveryRetrySpec;
    }

    public final VoiceChannelJoinSpec withTimeout(Duration value) {
        if (this.timeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "timeout");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(newValue, this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withProvider(AudioProvider value) {
        if (this.provider == value) {
            return this;
        }
        AudioProvider newValue = Objects.requireNonNull(value, "provider");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, newValue, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    @Deprecated
    public final VoiceChannelJoinSpec withReceiver(AudioReceiver value) {
        if (this.receiver == value) {
            return this;
        }
        AudioReceiver newValue = Objects.requireNonNull(value, "receiver");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, newValue, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withSendTaskFactory(VoiceSendTaskFactory value) {
        if (this.sendTaskFactory == value) {
            return this;
        }
        VoiceSendTaskFactory newValue = Objects.requireNonNull(value, "sendTaskFactory");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, newValue, this.receiveTaskFactory, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    @Deprecated
    public final VoiceChannelJoinSpec withReceiveTaskFactory(VoiceReceiveTaskFactory value) {
        if (this.receiveTaskFactory == value) {
            return this;
        }
        VoiceReceiveTaskFactory newValue = Objects.requireNonNull(value, "receiveTaskFactory");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, this.sendTaskFactory, newValue, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withSelfDeaf(boolean value) {
        if (this.selfDeaf == value) {
            return this;
        }
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, value, this.selfMute, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withSelfMute(boolean value) {
        if (this.selfMute == value) {
            return this;
        }
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, value, this.ipDiscoveryTimeout, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withIpDiscoveryTimeout(Duration value) {
        if (this.ipDiscoveryTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "ipDiscoveryTimeout");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, this.selfMute, newValue, this.ipDiscoveryRetrySpec));
    }

    public final VoiceChannelJoinSpec withIpDiscoveryRetrySpec(RetrySpec value) {
        if (this.ipDiscoveryRetrySpec == value) {
            return this;
        }
        RetrySpec newValue = Objects.requireNonNull(value, "ipDiscoveryRetrySpec");
        return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this.timeout, this.provider, this.receiver, this.sendTaskFactory, this.receiveTaskFactory, this.selfDeaf, this.selfMute, this.ipDiscoveryTimeout, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VoiceChannelJoinSpec && this.equalTo(0, (VoiceChannelJoinSpec)another);
    }

    private boolean equalTo(int synthetic, VoiceChannelJoinSpec another) {
        return this.timeout.equals(another.timeout) && this.provider.equals(another.provider) && this.receiver.equals(another.receiver) && this.sendTaskFactory.equals(another.sendTaskFactory) && this.receiveTaskFactory.equals(another.receiveTaskFactory) && this.selfDeaf == another.selfDeaf && this.selfMute == another.selfMute && this.ipDiscoveryTimeout.equals(another.ipDiscoveryTimeout) && this.ipDiscoveryRetrySpec.equals(another.ipDiscoveryRetrySpec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.timeout.hashCode();
        h += (h << 5) + this.provider.hashCode();
        h += (h << 5) + this.receiver.hashCode();
        h += (h << 5) + this.sendTaskFactory.hashCode();
        h += (h << 5) + this.receiveTaskFactory.hashCode();
        h += (h << 5) + Boolean.hashCode(this.selfDeaf);
        h += (h << 5) + Boolean.hashCode(this.selfMute);
        h += (h << 5) + this.ipDiscoveryTimeout.hashCode();
        h += (h << 5) + this.ipDiscoveryRetrySpec.hashCode();
        return h;
    }

    public String toString() {
        return "VoiceChannelJoinSpec{timeout=" + this.timeout + ", provider=" + this.provider + ", receiver=" + this.receiver + ", sendTaskFactory=" + this.sendTaskFactory + ", receiveTaskFactory=" + this.receiveTaskFactory + ", selfDeaf=" + this.selfDeaf + ", selfMute=" + this.selfMute + ", ipDiscoveryTimeout=" + this.ipDiscoveryTimeout + ", ipDiscoveryRetrySpec=" + this.ipDiscoveryRetrySpec + "}";
    }

    public static VoiceChannelJoinSpec create() {
        return INSTANCE;
    }

    private static VoiceChannelJoinSpec validate(VoiceChannelJoinSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static VoiceChannelJoinSpec copyOf(VoiceChannelJoinSpecGenerator instance) {
        if (instance instanceof VoiceChannelJoinSpec) {
            return (VoiceChannelJoinSpec)instance;
        }
        return VoiceChannelJoinSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VoiceChannelJoinSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SELF_DEAF = 1L;
        private static final long OPT_BIT_SELF_MUTE = 2L;
        private long optBits;
        private Duration timeout;
        private AudioProvider provider;
        private AudioReceiver receiver;
        private VoiceSendTaskFactory sendTaskFactory;
        private VoiceReceiveTaskFactory receiveTaskFactory;
        private boolean selfDeaf;
        private boolean selfMute;
        private Duration ipDiscoveryTimeout;
        private RetrySpec ipDiscoveryRetrySpec;

        private Builder() {
        }

        public final Builder from(VoiceChannelJoinSpec instance) {
            return this.from((VoiceChannelJoinSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(VoiceChannelJoinSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.timeout(instance.timeout());
            this.provider(instance.provider());
            this.receiver(instance.receiver());
            this.sendTaskFactory(instance.sendTaskFactory());
            this.receiveTaskFactory(instance.receiveTaskFactory());
            this.selfDeaf(instance.selfDeaf());
            this.selfMute(instance.selfMute());
            this.ipDiscoveryTimeout(instance.ipDiscoveryTimeout());
            this.ipDiscoveryRetrySpec(instance.ipDiscoveryRetrySpec());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeout(Duration timeout) {
            this.timeout = Objects.requireNonNull(timeout, "timeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder provider(AudioProvider provider) {
            this.provider = Objects.requireNonNull(provider, "provider");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder receiver(AudioReceiver receiver) {
            this.receiver = Objects.requireNonNull(receiver, "receiver");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
            this.sendTaskFactory = Objects.requireNonNull(sendTaskFactory, "sendTaskFactory");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder receiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
            this.receiveTaskFactory = Objects.requireNonNull(receiveTaskFactory, "receiveTaskFactory");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipDiscoveryTimeout(Duration ipDiscoveryTimeout) {
            this.ipDiscoveryTimeout = Objects.requireNonNull(ipDiscoveryTimeout, "ipDiscoveryTimeout");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ipDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
            this.ipDiscoveryRetrySpec = Objects.requireNonNull(ipDiscoveryRetrySpec, "ipDiscoveryRetrySpec");
            return this;
        }

        public VoiceChannelJoinSpec build() {
            return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this));
        }

        private boolean selfDeafIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean selfMuteIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="VoiceChannelJoinSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte timeoutBuildStage = 0;
        private Duration timeout;
        private byte providerBuildStage = 0;
        private AudioProvider provider;
        private byte receiverBuildStage = 0;
        private AudioReceiver receiver;
        private byte sendTaskFactoryBuildStage = 0;
        private VoiceSendTaskFactory sendTaskFactory;
        private byte receiveTaskFactoryBuildStage = 0;
        private VoiceReceiveTaskFactory receiveTaskFactory;
        private byte selfDeafBuildStage = 0;
        private boolean selfDeaf;
        private byte selfMuteBuildStage = 0;
        private boolean selfMute;
        private byte ipDiscoveryTimeoutBuildStage = 0;
        private Duration ipDiscoveryTimeout;
        private byte ipDiscoveryRetrySpecBuildStage = 0;
        private RetrySpec ipDiscoveryRetrySpec;

        private InitShim() {
        }

        Duration timeout() {
            if (this.timeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutBuildStage == 0) {
                this.timeoutBuildStage = (byte)-1;
                this.timeout = Objects.requireNonNull(VoiceChannelJoinSpec.this.timeoutInitialize(), "timeout");
                this.timeoutBuildStage = 1;
            }
            return this.timeout;
        }

        void timeout(Duration timeout) {
            this.timeout = timeout;
            this.timeoutBuildStage = 1;
        }

        AudioProvider provider() {
            if (this.providerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.providerBuildStage == 0) {
                this.providerBuildStage = (byte)-1;
                this.provider = Objects.requireNonNull(VoiceChannelJoinSpec.this.providerInitialize(), "provider");
                this.providerBuildStage = 1;
            }
            return this.provider;
        }

        void provider(AudioProvider provider) {
            this.provider = provider;
            this.providerBuildStage = 1;
        }

        AudioReceiver receiver() {
            if (this.receiverBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.receiverBuildStage == 0) {
                this.receiverBuildStage = (byte)-1;
                this.receiver = Objects.requireNonNull(VoiceChannelJoinSpec.this.receiverInitialize(), "receiver");
                this.receiverBuildStage = 1;
            }
            return this.receiver;
        }

        void receiver(AudioReceiver receiver) {
            this.receiver = receiver;
            this.receiverBuildStage = 1;
        }

        VoiceSendTaskFactory sendTaskFactory() {
            if (this.sendTaskFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sendTaskFactoryBuildStage == 0) {
                this.sendTaskFactoryBuildStage = (byte)-1;
                this.sendTaskFactory = Objects.requireNonNull(VoiceChannelJoinSpec.this.sendTaskFactoryInitialize(), "sendTaskFactory");
                this.sendTaskFactoryBuildStage = 1;
            }
            return this.sendTaskFactory;
        }

        void sendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
            this.sendTaskFactory = sendTaskFactory;
            this.sendTaskFactoryBuildStage = 1;
        }

        VoiceReceiveTaskFactory receiveTaskFactory() {
            if (this.receiveTaskFactoryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.receiveTaskFactoryBuildStage == 0) {
                this.receiveTaskFactoryBuildStage = (byte)-1;
                this.receiveTaskFactory = Objects.requireNonNull(VoiceChannelJoinSpec.this.receiveTaskFactoryInitialize(), "receiveTaskFactory");
                this.receiveTaskFactoryBuildStage = 1;
            }
            return this.receiveTaskFactory;
        }

        void receiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
            this.receiveTaskFactory = receiveTaskFactory;
            this.receiveTaskFactoryBuildStage = 1;
        }

        boolean selfDeaf() {
            if (this.selfDeafBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfDeafBuildStage == 0) {
                this.selfDeafBuildStage = (byte)-1;
                this.selfDeaf = VoiceChannelJoinSpec.this.selfDeafInitialize();
                this.selfDeafBuildStage = 1;
            }
            return this.selfDeaf;
        }

        void selfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.selfDeafBuildStage = 1;
        }

        boolean selfMute() {
            if (this.selfMuteBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.selfMuteBuildStage == 0) {
                this.selfMuteBuildStage = (byte)-1;
                this.selfMute = VoiceChannelJoinSpec.this.selfMuteInitialize();
                this.selfMuteBuildStage = 1;
            }
            return this.selfMute;
        }

        void selfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.selfMuteBuildStage = 1;
        }

        Duration ipDiscoveryTimeout() {
            if (this.ipDiscoveryTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ipDiscoveryTimeoutBuildStage == 0) {
                this.ipDiscoveryTimeoutBuildStage = (byte)-1;
                this.ipDiscoveryTimeout = Objects.requireNonNull(VoiceChannelJoinSpec.this.ipDiscoveryTimeoutInitialize(), "ipDiscoveryTimeout");
                this.ipDiscoveryTimeoutBuildStage = 1;
            }
            return this.ipDiscoveryTimeout;
        }

        void ipDiscoveryTimeout(Duration ipDiscoveryTimeout) {
            this.ipDiscoveryTimeout = ipDiscoveryTimeout;
            this.ipDiscoveryTimeoutBuildStage = 1;
        }

        RetrySpec ipDiscoveryRetrySpec() {
            if (this.ipDiscoveryRetrySpecBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ipDiscoveryRetrySpecBuildStage == 0) {
                this.ipDiscoveryRetrySpecBuildStage = (byte)-1;
                this.ipDiscoveryRetrySpec = Objects.requireNonNull(VoiceChannelJoinSpec.this.ipDiscoveryRetrySpecInitialize(), "ipDiscoveryRetrySpec");
                this.ipDiscoveryRetrySpecBuildStage = 1;
            }
            return this.ipDiscoveryRetrySpec;
        }

        void ipDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
            this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
            this.ipDiscoveryRetrySpecBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.timeoutBuildStage == -1) {
                attributes.add("timeout");
            }
            if (this.providerBuildStage == -1) {
                attributes.add("provider");
            }
            if (this.receiverBuildStage == -1) {
                attributes.add("receiver");
            }
            if (this.sendTaskFactoryBuildStage == -1) {
                attributes.add("sendTaskFactory");
            }
            if (this.receiveTaskFactoryBuildStage == -1) {
                attributes.add("receiveTaskFactory");
            }
            if (this.selfDeafBuildStage == -1) {
                attributes.add("selfDeaf");
            }
            if (this.selfMuteBuildStage == -1) {
                attributes.add("selfMute");
            }
            if (this.ipDiscoveryTimeoutBuildStage == -1) {
                attributes.add("ipDiscoveryTimeout");
            }
            if (this.ipDiscoveryRetrySpecBuildStage == -1) {
                attributes.add("ipDiscoveryRetrySpec");
            }
            return "Cannot build VoiceChannelJoinSpec, attribute initializers form cycle " + attributes;
        }
    }
}

