/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.StoreChannelEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="StoreChannelEditSpecGenerator", generator="Immutables")
public final class StoreChannelEditSpec
implements StoreChannelEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final StoreChannelEditSpec INSTANCE = StoreChannelEditSpec.validate(new StoreChannelEditSpec());

    private StoreChannelEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt((Possible)parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private StoreChannelEditSpec(@Nullable String reason, Possible<String> name, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Optional<Snowflake>> parentId) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Optional<Snowflake>> parentId$impl = parentId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of((Object)this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Optional<Snowflake>> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.parentId_value));
    }

    public final StoreChannelEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(value, this.name(), this.position(), this.permissionOverwrites(), this.parentId()));
    }

    public StoreChannelEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, newValue, this.position(), this.permissionOverwrites(), this.parentId()));
    }

    public StoreChannelEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, (Possible<String>)newValue, this.position(), this.permissionOverwrites(), this.parentId()));
    }

    public StoreChannelEditSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), newValue, this.permissionOverwrites(), this.parentId()));
    }

    public StoreChannelEditSpec withPosition(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), (Possible<Integer>)newValue, this.permissionOverwrites(), this.parentId()));
    }

    public StoreChannelEditSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.parentId()));
    }

    public StoreChannelEditSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), (Possible<List<PermissionOverwrite>>)newValue, this.parentId()));
    }

    @SafeVarargs
    public final StoreChannelEditSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), (Possible<List<PermissionOverwrite>>)newValue, this.parentId()));
    }

    public StoreChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue));
    }

    @Deprecated
    public StoreChannelEditSpec withParentId(@Nullable Snowflake value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), (Possible<Optional<Snowflake>>)newValue));
    }

    public StoreChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name(), this.position(), this.permissionOverwrites(), (Possible<Optional<Snowflake>>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StoreChannelEditSpec && this.equalTo(0, (StoreChannelEditSpec)another);
    }

    private boolean equalTo(int synthetic, StoreChannelEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.position().hashCode();
        h += (h << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h += (h << 5) + this.parentId().hashCode();
        return h;
    }

    public String toString() {
        return "StoreChannelEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + "}";
    }

    public static StoreChannelEditSpec create() {
        return INSTANCE;
    }

    private static StoreChannelEditSpec validate(StoreChannelEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static StoreChannelEditSpec copyOf(StoreChannelEditSpecGenerator instance) {
        if (instance instanceof StoreChannelEditSpec) {
            return (StoreChannelEditSpec)instance;
        }
        return StoreChannelEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StoreChannelEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(StoreChannelEditSpec instance) {
            return this.from((StoreChannelEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(StoreChannelEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.position(instance.position());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Optional<Snowflake>> value) {
            this.parentId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder parentId(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentIdOrNull(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public StoreChannelEditSpec build() {
            return StoreChannelEditSpec.validate(new StoreChannelEditSpec(this.reason, this.name_build(), this.position_build(), this.permissionOverwrites_build(), this.parentId_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Optional<Snowflake>> parentId_build() {
            return this.parentId_possible;
        }
    }

    @Generated(from="StoreChannelEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StoreChannelEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

