/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.RoleCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="RoleCreateSpecGenerator", generator="Immutables")
public final class RoleCreateSpec
implements RoleCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final PermissionSet permissions_value;
    private final boolean permissions_absent;
    private final Color color_value;
    private final boolean color_absent;
    private final Boolean hoist_value;
    private final boolean hoist_absent;
    private final Boolean mentionable_value;
    private final boolean mentionable_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final RoleCreateSpec INSTANCE = RoleCreateSpec.validate(new RoleCreateSpec());

    private RoleCreateSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible permissions$impl = Possible.absent();
        Possible color$impl = Possible.absent();
        Possible hoist$impl = Possible.absent();
        Possible mentionable$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.initShim = null;
    }

    private RoleCreateSpec(@Nullable String reason, Possible<String> name, Possible<PermissionSet> permissions, Possible<Color> color, Possible<Boolean> hoist, Possible<Boolean> mentionable) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<PermissionSet> permissions$impl = permissions;
        Possible<Color> color$impl = color;
        Possible<Boolean> hoist$impl = hoist;
        Possible<Boolean> mentionable$impl = mentionable;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<PermissionSet> permissions() {
        return this.permissions_absent ? Possible.absent() : Possible.of((Object)this.permissions_value);
    }

    @Override
    public Possible<Color> color() {
        return this.color_absent ? Possible.absent() : Possible.of((Object)this.color_value);
    }

    @Override
    public Possible<Boolean> hoist() {
        return this.hoist_absent ? Possible.absent() : Possible.of((Object)this.hoist_value);
    }

    @Override
    public Possible<Boolean> mentionable() {
        return this.mentionable_absent ? Possible.absent() : Possible.of((Object)this.mentionable_value);
    }

    public final RoleCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return RoleCreateSpec.validate(new RoleCreateSpec(value, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, newValue, this.permissions(), this.color(), this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, (Possible<String>)newValue, this.permissions(), this.color(), this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withPermissions(Possible<PermissionSet> value) {
        Possible<PermissionSet> newValue = Objects.requireNonNull(value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withPermissions(PermissionSet value) {
        Possible newValue = Possible.of((Object)value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), (Possible<PermissionSet>)newValue, this.color(), this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withColor(Possible<Color> value) {
        Possible<Color> newValue = Objects.requireNonNull(value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), newValue, this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withColor(Color value) {
        Possible newValue = Possible.of((Object)value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), (Possible<Color>)newValue, this.hoist(), this.mentionable()));
    }

    public RoleCreateSpec withHoist(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), newValue, this.mentionable()));
    }

    public RoleCreateSpec withHoist(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), (Possible<Boolean>)newValue, this.mentionable()));
    }

    public RoleCreateSpec withMentionable(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue));
    }

    public RoleCreateSpec withMentionable(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), (Possible<Boolean>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RoleCreateSpec && this.equalTo(0, (RoleCreateSpec)another);
    }

    private boolean equalTo(int synthetic, RoleCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.permissions().equals(another.permissions()) && this.color().equals(another.color()) && this.hoist().equals(another.hoist()) && this.mentionable().equals(another.mentionable());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.permissions().hashCode();
        h += (h << 5) + this.color().hashCode();
        h += (h << 5) + this.hoist().hashCode();
        h += (h << 5) + this.mentionable().hashCode();
        return h;
    }

    public String toString() {
        return "RoleCreateSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", permissions=" + this.permissions().toString() + ", color=" + this.color().toString() + ", hoist=" + this.hoist().toString() + ", mentionable=" + this.mentionable().toString() + "}";
    }

    public static RoleCreateSpec create() {
        return INSTANCE;
    }

    private static RoleCreateSpec validate(RoleCreateSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static RoleCreateSpec copyOf(RoleCreateSpecGenerator instance) {
        if (instance instanceof RoleCreateSpec) {
            return (RoleCreateSpec)instance;
        }
        return RoleCreateSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPermissionsPresent() {
        return !this.permissions_absent;
    }

    public PermissionSet permissionsOrElse(PermissionSet defaultValue) {
        return !this.permissions_absent ? this.permissions_value : defaultValue;
    }

    public boolean isColorPresent() {
        return !this.color_absent;
    }

    public Color colorOrElse(Color defaultValue) {
        return !this.color_absent ? this.color_value : defaultValue;
    }

    public boolean isHoistPresent() {
        return !this.hoist_absent;
    }

    public Boolean hoistOrElse(Boolean defaultValue) {
        return !this.hoist_absent ? this.hoist_value : defaultValue;
    }

    public boolean isMentionablePresent() {
        return !this.mentionable_absent;
    }

    public Boolean mentionableOrElse(Boolean defaultValue) {
        return !this.mentionable_absent ? this.mentionable_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<PermissionSet> permissions_possible = Possible.absent();
        private Possible<Color> color_possible = Possible.absent();
        private Possible<Boolean> hoist_possible = Possible.absent();
        private Possible<Boolean> mentionable_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(RoleCreateSpec instance) {
            return this.from((RoleCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(RoleCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.permissions(instance.permissions());
            this.color(instance.color());
            this.hoist(instance.hoist());
            this.mentionable(instance.mentionable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissions(Possible<PermissionSet> value) {
            this.permissions_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissions(PermissionSet value) {
            this.permissions_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder color(Possible<Color> value) {
            this.color_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder color(Color value) {
            this.color_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder hoist(Possible<Boolean> value) {
            this.hoist_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder hoist(Boolean value) {
            this.hoist_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder mentionable(Possible<Boolean> value) {
            this.mentionable_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder mentionable(Boolean value) {
            this.mentionable_possible = Possible.of((Object)value);
            return this;
        }

        public RoleCreateSpec build() {
            return RoleCreateSpec.validate(new RoleCreateSpec(this.reason, this.name_build(), this.permissions_build(), this.color_build(), this.hoist_build(), this.mentionable_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<PermissionSet> permissions_build() {
            return this.permissions_possible;
        }

        private Possible<Color> color_build() {
            return this.color_possible;
        }

        private Possible<Boolean> hoist_build() {
            return this.hoist_possible;
        }

        private Possible<Boolean> mentionable_build() {
            return this.mentionable_possible;
        }
    }

    @Generated(from="RoleCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build RoleCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

