/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.Guild;
import discord4j.core.spec.RoleCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="RoleCreateMonoGenerator", generator="Immutables")
public final class RoleCreateMono
extends RoleCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final PermissionSet permissions_value;
    private final boolean permissions_absent;
    private final Color color_value;
    private final boolean color_absent;
    private final Boolean hoist_value;
    private final boolean hoist_absent;
    private final Boolean mentionable_value;
    private final boolean mentionable_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private RoleCreateMono(Guild guild) {
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible permissions$impl = Possible.absent();
        Possible color$impl = Possible.absent();
        Possible hoist$impl = Possible.absent();
        Possible mentionable$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.initShim = null;
    }

    private RoleCreateMono(@Nullable String reason, Possible<String> name, Possible<PermissionSet> permissions, Possible<Color> color, Possible<Boolean> hoist, Possible<Boolean> mentionable, Guild guild) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<PermissionSet> permissions$impl = permissions;
        Possible<Color> color$impl = color;
        Possible<Boolean> hoist$impl = hoist;
        Possible<Boolean> mentionable$impl = mentionable;
        this.guild = guild;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.hoist_value = hoist$impl.toOptional().orElse(null);
        this.hoist_absent = hoist$impl.isAbsent();
        this.mentionable_value = mentionable$impl.toOptional().orElse(null);
        this.mentionable_absent = mentionable$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<PermissionSet> permissions() {
        return this.permissions_absent ? Possible.absent() : Possible.of((Object)this.permissions_value);
    }

    @Override
    public Possible<Color> color() {
        return this.color_absent ? Possible.absent() : Possible.of((Object)this.color_value);
    }

    @Override
    public Possible<Boolean> hoist() {
        return this.hoist_absent ? Possible.absent() : Possible.of((Object)this.hoist_value);
    }

    @Override
    public Possible<Boolean> mentionable() {
        return this.mentionable_absent ? Possible.absent() : Possible.of((Object)this.mentionable_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final RoleCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new RoleCreateMono(value, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new RoleCreateMono(this.reason, newValue, this.permissions(), this.color(), this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new RoleCreateMono(this.reason, (Possible<String>)newValue, this.permissions(), this.color(), this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withPermissions(Possible<PermissionSet> value) {
        Possible<PermissionSet> newValue = Objects.requireNonNull(value);
        return new RoleCreateMono(this.reason, this.name(), newValue, this.color(), this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withPermissions(PermissionSet value) {
        Possible newValue = Possible.of((Object)value);
        return new RoleCreateMono(this.reason, this.name(), (Possible<PermissionSet>)newValue, this.color(), this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withColor(Possible<Color> value) {
        Possible<Color> newValue = Objects.requireNonNull(value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), newValue, this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withColor(Color value) {
        Possible newValue = Possible.of((Object)value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), (Possible<Color>)newValue, this.hoist(), this.mentionable(), this.guild);
    }

    public RoleCreateMono withHoist(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), this.color(), newValue, this.mentionable(), this.guild);
    }

    public RoleCreateMono withHoist(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), this.color(), (Possible<Boolean>)newValue, this.mentionable(), this.guild);
    }

    public RoleCreateMono withMentionable(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), newValue, this.guild);
    }

    public RoleCreateMono withMentionable(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), (Possible<Boolean>)newValue, this.guild);
    }

    public final RoleCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new RoleCreateMono(this.reason, this.name(), this.permissions(), this.color(), this.hoist(), this.mentionable(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RoleCreateMono && this.equalTo(0, (RoleCreateMono)another);
    }

    private boolean equalTo(int synthetic, RoleCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.permissions().equals(another.permissions()) && this.color().equals(another.color()) && this.hoist().equals(another.hoist()) && this.mentionable().equals(another.mentionable()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.permissions().hashCode();
        h += (h << 5) + this.color().hashCode();
        h += (h << 5) + this.hoist().hashCode();
        h += (h << 5) + this.mentionable().hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "RoleCreateMono{reason=" + this.reason + ", name=" + this.name().toString() + ", permissions=" + this.permissions().toString() + ", color=" + this.color().toString() + ", hoist=" + this.hoist().toString() + ", mentionable=" + this.mentionable().toString() + ", guild=" + this.guild + "}";
    }

    public static RoleCreateMono of(Guild guild) {
        return new RoleCreateMono(guild);
    }

    static RoleCreateMono copyOf(RoleCreateMonoGenerator instance) {
        if (instance instanceof RoleCreateMono) {
            return (RoleCreateMono)instance;
        }
        return RoleCreateMono.of(instance.guild()).withReason(instance.reason()).withName((Possible<String>)instance.name()).withPermissions((Possible<PermissionSet>)instance.permissions()).withColor((Possible<Color>)instance.color()).withHoist((Possible<Boolean>)instance.hoist()).withMentionable((Possible<Boolean>)instance.mentionable());
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPermissionsPresent() {
        return !this.permissions_absent;
    }

    public PermissionSet permissionsOrElse(PermissionSet defaultValue) {
        return !this.permissions_absent ? this.permissions_value : defaultValue;
    }

    public boolean isColorPresent() {
        return !this.color_absent;
    }

    public Color colorOrElse(Color defaultValue) {
        return !this.color_absent ? this.color_value : defaultValue;
    }

    public boolean isHoistPresent() {
        return !this.hoist_absent;
    }

    public Boolean hoistOrElse(Boolean defaultValue) {
        return !this.hoist_absent ? this.hoist_value : defaultValue;
    }

    public boolean isMentionablePresent() {
        return !this.mentionable_absent;
    }

    public Boolean mentionableOrElse(Boolean defaultValue) {
        return !this.mentionable_absent ? this.mentionable_value : defaultValue;
    }

    @Generated(from="RoleCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build RoleCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

