/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.spec.NewsChannelEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="NewsChannelEditSpecGenerator", generator="Immutables")
public final class NewsChannelEditSpec
implements NewsChannelEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final String topic_value;
    private final boolean topic_absent;
    private final Boolean nsfw_value;
    private final boolean nsfw_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Snowflake parentId_value;
    private final boolean parentId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final NewsChannelEditSpec INSTANCE = NewsChannelEditSpec.validate(new NewsChannelEditSpec());

    private NewsChannelEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible topic$impl = Possible.absent();
        Possible nsfw$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        Possible parentId$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt((Possible)parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    private NewsChannelEditSpec(@Nullable String reason, Possible<String> name, Possible<Integer> position, Possible<String> topic, Possible<Boolean> nsfw, Possible<List<PermissionOverwrite>> permissionOverwrites, Possible<Optional<Snowflake>> parentId) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> position$impl = position;
        Possible<String> topic$impl = topic;
        Possible<Boolean> nsfw$impl = nsfw;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        Possible<Optional<Snowflake>> parentId$impl = parentId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.topic_value = topic$impl.toOptional().orElse(null);
        this.topic_absent = topic$impl.isAbsent();
        this.nsfw_value = nsfw$impl.toOptional().orElse(null);
        this.nsfw_absent = nsfw$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
        this.parentId_absent = parentId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of((Object)this.position_value);
    }

    @Override
    public Possible<String> topic() {
        return this.topic_absent ? Possible.absent() : Possible.of((Object)this.topic_value);
    }

    @Override
    public Possible<Boolean> nsfw() {
        return this.nsfw_absent ? Possible.absent() : Possible.of((Object)this.nsfw_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Possible<Optional<Snowflake>> parentId() {
        return this.parentId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.parentId_value));
    }

    public final NewsChannelEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(value, this.name(), this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, newValue, this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, (Possible<String>)newValue, this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), newValue, this.topic(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withPosition(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), (Possible<Integer>)newValue, this.topic(), this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withTopic(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), newValue, this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withTopic(String value) {
        Possible newValue = Possible.of((Object)value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), (Possible<String>)newValue, this.nsfw(), this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withNsfw(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), newValue, this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withNsfw(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), (Possible<Boolean>)newValue, this.permissionOverwrites(), this.parentId()));
    }

    public NewsChannelEditSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), newValue, this.parentId()));
    }

    public NewsChannelEditSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), (Possible<List<PermissionOverwrite>>)newValue, this.parentId()));
    }

    @SafeVarargs
    public final NewsChannelEditSpec withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), (Possible<List<PermissionOverwrite>>)newValue, this.parentId()));
    }

    public NewsChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), newValue));
    }

    @Deprecated
    public NewsChannelEditSpec withParentId(@Nullable Snowflake value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), (Possible<Optional<Snowflake>>)newValue));
    }

    public NewsChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name(), this.position(), this.topic(), this.nsfw(), this.permissionOverwrites(), (Possible<Optional<Snowflake>>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NewsChannelEditSpec && this.equalTo(0, (NewsChannelEditSpec)another);
    }

    private boolean equalTo(int synthetic, NewsChannelEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.position().equals(another.position()) && this.topic().equals(another.topic()) && this.nsfw().equals(another.nsfw()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.parentId().equals(another.parentId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.position().hashCode();
        h += (h << 5) + this.topic().hashCode();
        h += (h << 5) + this.nsfw().hashCode();
        h += (h << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h += (h << 5) + this.parentId().hashCode();
        return h;
    }

    public String toString() {
        return "NewsChannelEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", position=" + this.position().toString() + ", topic=" + this.topic().toString() + ", nsfw=" + this.nsfw().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", parentId=" + this.parentId().toString() + "}";
    }

    public static NewsChannelEditSpec create() {
        return INSTANCE;
    }

    private static NewsChannelEditSpec validate(NewsChannelEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static NewsChannelEditSpec copyOf(NewsChannelEditSpecGenerator instance) {
        if (instance instanceof NewsChannelEditSpec) {
            return (NewsChannelEditSpec)instance;
        }
        return NewsChannelEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isTopicPresent() {
        return !this.topic_absent;
    }

    public String topicOrElse(String defaultValue) {
        return !this.topic_absent ? this.topic_value : defaultValue;
    }

    public boolean isNsfwPresent() {
        return !this.nsfw_absent;
    }

    public Boolean nsfwOrElse(Boolean defaultValue) {
        return !this.nsfw_absent ? this.nsfw_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    public boolean isParentIdPresent() {
        return !this.parentId_absent;
    }

    public Snowflake parentIdOrElse(Snowflake defaultValue) {
        return !this.parentId_absent ? this.parentId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NewsChannelEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> position_possible = Possible.absent();
        private Possible<String> topic_possible = Possible.absent();
        private Possible<Boolean> nsfw_possible = Possible.absent();
        private List<PermissionOverwrite> permissionOverwrites_list = null;
        private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(NewsChannelEditSpec instance) {
            return this.from((NewsChannelEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(NewsChannelEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.position(instance.position());
            this.topic(instance.topic());
            this.nsfw(instance.nsfw());
            this.permissionOverwrites(instance.permissionOverwrites());
            this.parentId(instance.parentId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Possible<Integer> value) {
            this.position_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder position(Integer value) {
            this.position_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(Possible<String> value) {
            this.topic_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder topic(String value) {
            this.topic_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Possible<Boolean> value) {
            this.nsfw_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder nsfw(Boolean value) {
            this.nsfw_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addPermissionOverwrite(PermissionOverwrite element) {
            this.permissionOverwrites_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
            this.permissionOverwrites_list = null;
            elements.toOptional().ifPresent(e -> this.permissionOverwrites_getOrCreate().addAll((Collection<PermissionOverwrite>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
            this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentId(Possible<Optional<Snowflake>> value) {
            this.parentId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder parentId(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder parentIdOrNull(@Nullable Snowflake value) {
            this.parentId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public NewsChannelEditSpec build() {
            return NewsChannelEditSpec.validate(new NewsChannelEditSpec(this.reason, this.name_build(), this.position_build(), this.topic_build(), this.nsfw_build(), this.permissionOverwrites_build(), this.parentId_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> position_build() {
            return this.position_possible;
        }

        private Possible<String> topic_build() {
            return this.topic_possible;
        }

        private Possible<Boolean> nsfw_build() {
            return this.nsfw_possible;
        }

        private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
            return this.permissionOverwrites_list == null ? Possible.absent() : Possible.of(this.permissionOverwrites_list);
        }

        private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
            if (this.permissionOverwrites_list == null) {
                this.permissionOverwrites_list = new ArrayList<PermissionOverwrite>();
            }
            return this.permissionOverwrites_list;
        }

        private Possible<Optional<Snowflake>> parentId_build() {
            return this.parentId_possible;
        }
    }

    @Generated(from="NewsChannelEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build NewsChannelEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

